<?php
if (!defined('ABSPATH')) {
    exit;
}


// Check for at least one non-empty error or success message.
$has_message = false;
if (!empty($this->reports['errors'])) {
    foreach ($this->reports['errors'] as $error) {
        if (trim($error) !== '') {
            $has_message = true;
            break;
        }
    }
}
if (!$has_message && !empty($this->reports['success'])) {
    foreach ($this->reports['success'] as $message) {
        if (trim($message) !== '') {
            $has_message = true;
            break;
        }
    }
}

?>

<?php if ($has_message): ?>
    <div class="surf-sr-notice">
        <?php if (!empty($this->reports['errors'])): ?>
            <div class="notice notice-error is-dismissible">
                <?php foreach ($this->reports['errors'] as $error): ?>
                    <?php if (trim($error) !== ''): ?>
                        <p><?php echo esc_html($error); ?></p>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if (!empty($this->reports['success'])): ?>
            <div class="notice notice-success is-dismissible">
                <?php foreach ($this->reports['success'] as $message): ?>
                    <?php if (trim($message) !== ''): ?>
                        <p><?php echo esc_html($message); ?></p>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
            <?php if (!empty($this->reports['skipped'])): ?>
                <div class="notice notice-warning is-dismissible">
                    <?php foreach ($this->reports['skipped'] as $message): ?>
                        <?php if (trim($message) !== ''): ?>
                            <p><?php echo esc_html($message); ?></p>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>

    </div>
<?php endif; ?>

<?php
$hasMatches = false;
// Check if reports data is available (from AJAX or initial load)
if (!empty($this->reports)) {
    // Check if any table has modifications to display in the detailed report.
    if (!empty($this->reports['details'])) {
        foreach ($this->reports['details'] as $table => $details) {
            $occurrences = 0;
            if (!empty($details['columns']) && is_array($details['columns'])) {
                foreach ($details['columns'] as $col => $data) {
                    $occurrences += isset($data['occurrences']) ? $data['occurrences'] : 0;
                }
            }
            if ($occurrences > 0) {
                $hasMatches = true;
                break;
            }
        }
    }
}
?>

<div id="surf-sr-report-container" style="<?php echo !$hasMatches ? 'display: none;' : ''; ?>">
    <button id="surf-sr-report-close-btn" class="surf-sr-close-btn">X</button>
    <table id="surf-sr-report" class="surf-sr-table-report">
        <thead>
            <tr>
                <th>Location</th>
                <th><?php echo !empty($this->reports['dry_run']) ? 'Matches found' : 'Matches replaced'; ?>
                </th>
            </tr>
        </thead>

        <?php if (!empty($this->reports)): ?>
            <tbody>
                <?php foreach ($this->reports['details'] as $table => $details):
                    $time_taken = isset($details['time']) ? $details['time'] : 0;
                    $occurrences = 0;
                    if (!empty($details['columns']) && is_array($details['columns'])) {
                        foreach ($details['columns'] as $col => $data) {
                            $occurrences += isset($data['occurrences']) ? $data['occurrences'] : 0;
                        }
                    }
                    // Skip displaying this table if there were no modifications.
                    if ($occurrences === 0) {
                        continue;
                    }
                ?>
                    <tr>
                        <td><?php echo esc_html($table); ?></td>

                        <td><?php echo esc_html($occurrences); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        <?php endif; ?>
    </table>




</div>



<div style="<?php echo !$hasMatches &&  !empty($this->reports) ? '' : 'display: none;'; ?>" class="notice notice-info is-dismissible">
    <p>No matches found.</p>
</div>