<?php
if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="surf-sr-container">

    <div class="surf-sr-tab-content-area">




        <div class="surf-sr-main-content">

            <div class="surf-sr-page-content-wrapper">
                <div class="surf-sr-section-title">

                    <h2><span class="surf-sr-price-title">
                            <?php esc_html_e('Surflab Search & Replace', 'surflab-search-replace'); ?>
                        </span></h2>

                </div>
                <div id="surf-sr-report-container-ajax">
                    <?php require_once SURF_SR_PATH . "templates/surf-sr-report.php"; ?>
                </div>

                <form id="surf-sr-form" class="sr-form-container">
                    <?php wp_nonce_field('surf_sr', 'nonce'); ?>

                    <table class="surf-sr-table surf-sr-equal-cols">

                        <tr>

                            <td style="vertical-align: top;">
                                <label class="surf-sr-label" for="search">Search Query <?php $tooltip_text = "The exact text or string you want to search for in your database tables.";

                                                                                        require SURF_SR_PATH . 'templates/question-tooltip.php'
                                                                                        ?> </label>
                                <div class="surf-sr-input-group">

                                    <input type="text" id="search" name="search" class="regular-text"
                                        value=""
                                        placeholder="Enter the string you want to search for" required />
                                </div>

                            </td>
                            <td class="surf-sr-arrow-indicator" style="vertical-align:middle;text-align:center;height:fit-content;">
                                <div class="surf-sr-desktop-arrow" style="gap: 0;" class="surf-sr-flex-center">
                                    <?php require_once SURF_SR_PATH . 'assets/fast-forward.php' ?>
                                </div>

                            </td>

                            <td style="vertical-align: top;">
                                <label class="surf-sr-label" for="replace">Replace With <?php $tooltip_text = "The new text that will replace the matched search string.";
                                                                                        require SURF_SR_PATH . 'templates/question-tooltip.php'
                                                                                        ?> </label>
                                <div class="surf-sr-input-group">
                                    <input type="text" id="replace" name="replace" class="regular-text"
                                        value=""
                                        placeholder="Enter the replacement text" required />

                                </div>

                            </td>
                        </tr>


                        <td style="vertical-align: top;" class="surf-sr-redirect-form-td" colspan="2">
                            <label class="surf-sr-label" for="tables">Tables <?php $tooltip_text = "Select one or more database tables where the search & replace should run. Hold Ctrl (or Cmd on Mac) to select multiple.";
                                                                                require SURF_SR_PATH . 'templates/question-tooltip.php'
                                                                                ?> </label>
                            <?php
                            global $wpdb;
                            $all_tables = $wpdb->get_results(
                                $wpdb->prepare(
                                    "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = %s AND TABLE_NAME NOT LIKE %s",
                                    DB_NAME,
                                    '%surf_sr_search_replace_history%'
                                ),
                                ARRAY_N
                            );

                            $all_table_statuses = $wpdb->get_results("SHOW TABLE STATUS", ARRAY_A);
                            $table_sizes = [];
                            if ($all_table_statuses) {
                                foreach ($all_table_statuses as $status) {
                                    $table_name = $status['Name'];
                                    $size_bytes = $status['Data_length'] + $status['Index_length'];
                                    $size_mb = number_format($size_bytes / (1024 * 1024), 2);
                                    $table_sizes[$table_name] = $size_mb;
                                }
                            }



                            ?>
                            <div class="surf-sr-select-container">
                                <div class="surf-sr-key-hint">
                                    Select multiple tables with <span class="surf-sr-key">Ctrl</span> +
                                    <span class="surf-sr-key">Click</span> or <span class="surf-sr-key">Cmd</span> +
                                    <span class="surf-sr-key">Click</span>
                                </div>
                                <select class="surf-sr-select-multiple" name="tables[]" id="tables" multiple="multiple" size="10" required>
                                    <?php foreach ($all_tables as $table): ?>
                                        <?php
                                        $table_name = $table[0];
                                        $selected = ''; // No pre-selection for AJAX form
                                        ?>
                                        <option value="<?php echo esc_attr($table_name); ?>" <?php echo esc_attr($selected); ?>>
                                            <?php echo esc_html($table_name); ?>
                                            (<?php echo esc_html(
                                                    isset($table_sizes[$table_name])
                                                        ? $table_sizes[$table_name]
                                                        : '0.00'
                                                ); ?>
                                            MB)
                                        </option>
                                    <?php endforeach; ?>
                                </select>

                            </div>
                        </td>



                        <td style="vertical-align: top;">

                            <div class="surf-sr-flex-col" style="align-items: end;gap: 10px;padding-right: 18px;">



                                <div class="surf-sr-flex-start">
                                    <input type="checkbox" id="surf-sr-dry-run" name="dry_run" value="1" checked />
                                    <label id="surf-sr-status-text" for="dry_run"> Dry run is enabled – uncheck to make
                                        actual change <?php $tooltip_text = "When enabled, the plugin will show you what would be replaced without making permanent changes.";
                                                        require SURF_SR_PATH . 'templates/question-tooltip.php'
                                                        ?></label>

                                </div>
                                <div class="surf-sr-flex-start">

                                    <label class="surf-sr-flex-center" style="flex-wrap:nowrap;"><span class="dashicons dashicons-warning"></span> <span>WE RECOMMEND THAT YOU BACKUP YOUR DATABASE FIRST.</span></label>


                                </div>
                                <button style="max-width: max-content;" type="submit" id="submit-surf-sr-form"
                                    class="surf-sr-gradient-button">
                                    Run Search & Replace
                                </button>


                                <button type="button" id="surf-sr-toggle-sr-btn" class="surf-sr-toggle-options-btn">Additional
                                    Options<span class="dashicons dashicons-arrow-down-alt2 icon-down"></span>
                                    <span class="dashicons dashicons-arrow-up-alt2 icon-up" style="display: none;"></span>
                                </button>

                                <div id="surf-sr-advanced-options" class="surf-sr-additional-options" style="display: none;">
                                    <div class="surf-sr-flex-start">

                                        <input type="checkbox" id="replace_guid" name="replace_guid" value="1" />
                                        <label for="replace_guid">Replace GUID values (use with extreme caution) <?php $tooltip_text = "Select one or more database tables where the search & replace should run. Hold Ctrl (or Cmd on Mac) to select multiple.";
                                                                                                                    require SURF_SR_PATH . 'templates/question-tooltip.php'
                                                                                                                    ?></label>
                                    </div>


                                    <div class="surf-sr-flex-start">

                                        <input type="checkbox" id="case_insensitive" name="case_insensitive" value="1" />
                                        <label for="case_insensitive">Case-insensitive search & replace <?php $tooltip_text = "Enable this if you want the search to ignore letter case (e.g., 'WordPress' matches 'wordpress').";
                                                                                                        require SURF_SR_PATH . 'templates/question-tooltip.php'
                                                                                                        ?></label>
                                    </div>

                                </div>
                            </div>


                        </td>

                        </tr>

                    </table>


                </form>




            </div>
            <!-- .surf-sr-main-content -->
        </div>


        <!-- .surf-sr-tab-content-area -->
    </div>
</div>
<!-- .surf-sr-container -->