<?php

/**
 * Plugin Name: SurfLab Search & Replace
 * Description: Database Search & Replace.
 * Author: SurfLab
 * Author URI: https://surflabtech.com
 * Version: 1.0.0
 * Text Domain: surflab-search-replace
 * License: GPL-3.0-or-later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.txt
 * 
 * 
 */


// Prevent direct access.
if (!defined('WPINC')) {
    die;
}






require_once plugin_dir_path(__FILE__) . 'includes/class-surf-sr-loader.php';
require_once plugin_dir_path(__FILE__) . 'includes/uninstall.php';

if (!defined('SURF_SR_FILE')) define('SURF_SR_FILE', __FILE__);
if (!defined('SURF_SR_VERSION')) define('SURF_SR_VERSION', '1.0.0');
if (!defined('SURF_SR_PLUGIN')) define('SURF_SR_PLUGIN', plugin_basename(SURF_SR_FILE));





register_uninstall_hook(__FILE__, 'surf_sr_uninstall_cleanup');



function surf_sr_plugin_initialize()
{



    if (!defined('SURF_SR_PATH')) define('SURF_SR_PATH', plugin_dir_path(__FILE__));
    if (!defined('SURF_SR_URL'))  define('SURF_SR_URL', plugin_dir_url(__FILE__));
    if (!defined('SURF_SR_SITE_URL')) define('SURF_SR_SITE_URL', site_url());
    if (!defined('SURF_SR_HOME_URL')) define('SURF_SR_HOME_URL', home_url());


    if (is_multisite()) {
        define('SURF_SR_IS_MULTISITE', true);

        if (is_main_site()) {
            define('SURF_SR_IS_MAIN_SITE', true);
        } else {
            define('SURF_SR_IS_MAIN_SITE', false);
            define('SURF_SR_CURRENT_BLOG_ID', get_current_blog_id());
        }
    } else {
        define('SURF_SR_IS_MULTISITE', false);
    }





    $plugin = new SURF_SR_Loader();
    $plugin->run();
}



add_action('plugins_loaded', 'surf_sr_plugin_initialize');
