<?php
if (!defined('ABSPATH')) {
    exit;
}


function surf_sr_uninstall_cleanup()
{
    global $wpdb;

    // 1. Delete options with 'surf_sr_' in the option name
    $options = $wpdb->get_col("SELECT option_name FROM {$wpdb->options} WHERE option_name LIKE 'surf_sr\_%'");
    foreach ($options as $option) {
        delete_option($option);
    }

    //2. Delete transients with 'surf_sr_' in their name

    $transients = $wpdb->get_col("
    SELECT option_name 
    FROM {$wpdb->options} 
    WHERE option_name LIKE '_transient_surf_sr\_%'
       OR option_name LIKE '_transient_timeout_surf_sr\_%'
");

    foreach ($transients as $transient_option) {
        // Extract the transient key after 'surf_sr_'
        if (preg_match('/_transient_timeout_(surf_sr_.+)/', $transient_option, $matches)) {
            delete_transient($matches[1]);
        } elseif (preg_match('/_transient_(surf_sr_.+)/', $transient_option, $matches)) {
            delete_transient($matches[1]);
        }
    }
}
