<?php



if (!defined('ABSPATH')) {
    exit;
}

class SURF_SR_Loader
{


    public $surf_sr_fast_sr;

    public function __construct()
    {
        // Include other plugin files.
        $this->load_dependencies();


        // Hook to enqueue assets.
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);



        $this->surf_sr_fast_sr = new SURF_SR_HyperDBReplace();
    }



    public function load_dependencies()
    {


        require_once SURF_SR_PATH . 'includes/class-surf-sr.php';
    }

    public function enqueue_assets($hook_suffix)
    {
        if (!defined('SURF_SR_PATH')) {
            return;
        }





        // Main admin script
        wp_enqueue_script(
            'surf-sr-admin-script',
            SURF_SR_URL . 'assets/js/surf-sr.js',
            ['jquery'],
            SURF_SR_VERSION,
            true
        );

        wp_localize_script('surf-sr-admin-script', 'surf-sr-jq-obj', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('surf_sr_nonce')
        ]);




        // Admin CSS
        wp_enqueue_style(
            'surf-sr-admin-style',
            SURF_SR_URL . 'assets/css/surf-sr.css',
            [],
            SURF_SR_VERSION
        );
    }


    public function add_admin_menu()
    {


        $menu_title = 'SurfLab Search & Replace';




        add_menu_page(
            $menu_title,
            $menu_title,
            'manage_options', // Capability.
            'surflab-search-replace',
            [$this, 'display_sr_page'],
            trailingslashit(SURF_SR_URL)  . 'assets/icon_logo_sm_20.png', // Icon URL.
        );
    }






    public function display_sr_page()
    {





        $this->surf_sr_fast_sr->render_ui();
    }







    public function run()
    {
        // Hook to add admin menu.
        add_action('admin_menu', [$this, 'add_admin_menu']);
    }
}
