/*
 *
 *
 ********* SR
 *
 *
 */

jQuery(document).ready(function ($) {
  function handleCheck(checkBox, statusText) {
    const prefersDark = window.matchMedia(
      "(prefers-color-scheme: dark)",
    ).matches;
    if (checkBox.is(":checked")) {
      statusText.css("color", prefersDark ? "lightgray" : "black");
      statusText.html("Dry run is enabled – uncheck to make actual change");
    } else {
      statusText.css("color", prefersDark ? "#17c1c1" : "#050b3c");
      statusText.html("Live mode – changes will be permanent!");
    }
  }

  function slideContent(btn, content) {
    content.slideToggle(200, function () {
      // Check if form is now visible
      const isVisible = content.is(":visible");

      // Toggle icons
      btn.find(".icon-down").toggle(!isVisible);
      btn.find(".icon-up").toggle(isVisible);
    });
  }
  // SR
  $(document).on("change", "#surf-sr-dry-run", function () {
    handleCheck($(this), $("#surf-sr-status-text"));
  });
  //search-replace toggle
  $(document).on("click", "#surf-sr-toggle-sr-btn", function () {
    slideContent($(this), $("#surf-sr-advanced-options"));
  });

  $(document).on("click", "#surf-sr-report-close-btn", function () {
    $("#surf-sr-report-container").fadeOut("slow");
  });

  // Function to handle batch processing via AJAX
  function processBatch(
    form,
    submitButton,
    originalButtonText,
    action,
    containerId,
    offset = 0,
    total_rows = 0,
    processed_rows = 0,
    table_index = 0,
  ) {
    const formData =
      form.serialize() +
      `&action=${action}&offset=${offset}&current_table_index=${table_index}`;

    if (offset === 0) {
      // Initial call, show progress bar and reset
      $(containerId).html(`
        <div class="surf-sr-progress-container">
          <div class="surf-sr-progress-bar" style="width: 0%;"></div>
        </div>
        <div class="surf-sr-log-container"></div>
      `);
      submitButton
        .prop("disabled", true)
        .html(
          '<span class="dashicons dashicons-update surf-sr-loading"></span> Initializing...',
        );
    } else {
      submitButton
        .prop("disabled", true)
        .html(
          '<span class="dashicons dashicons-update surf-sr-loading"></span> Processing Batch...',
        );
    }

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: formData,
      success: function (response) {
        if (response.success) {
          const data = response.data;
          total_rows = data.total_rows || total_rows;
          processed_rows = data.processed_rows || processed_rows;
          const newOffset = data.offset || 0;
          const is_complete = data.is_complete || false;
          const report_html = data.report_html || "";

          const message = data.message || "";
          const current_table = data.current_table || "";
          const current_table_index = data.current_table_index || 0;

          // Update progress bar
          if (total_rows > 0) {
            const progress = Math.min(
              100,
              Math.round((processed_rows / total_rows) * 100),
            );
            $(containerId)
              .find(".surf-sr-progress-bar")
              .css("width", progress + "%");
            $(containerId)
              .find(".surf-sr-progress-text")
              .text(progress + "%");
          }

          // Append messages to log
          let displayMessage = "";
          if (current_table) {
            displayMessage = `Processing ${current_table}: rows scanned ${processed_rows} (${Math.min(
              100,
              Math.round((processed_rows / total_rows) * 100),
            )}%)`;
          } else if (message) {
            displayMessage = message;
          }

          if (displayMessage) {
            $(containerId)
              .find(".surf-sr-log-container")
              .html(`<p>${displayMessage}</p>`);
          }

          if (!is_complete) {
            // Continue with the next batch
            processBatch(
              form,
              submitButton,
              originalButtonText,
              action,
              containerId,
              newOffset,
              total_rows,
              processed_rows,
              current_table_index,
            );
          } else {
            // All batches complete, display final report
            $(containerId).html(report_html);
            submitButton.prop("disabled", false).html(originalButtonText);
          }
        } else {
          $(containerId).html(
            '<div class="notice notice-error is-dismissible"><p>' +
              (response.data.message || "An unknown error occurred.") +
              "</p></div>",
          );
          submitButton.prop("disabled", false).html(originalButtonText);
        }
      },
      error: function () {
        $(containerId).html(
          '<div class="notice notice-error is-dismissible"><p>An error occurred during the AJAX request.</p></div>',
        );
        submitButton.prop("disabled", false).html(originalButtonText);
      },
    });
  }

  // Handle SR form submission via AJAX
  $(document).on("submit", "#surf-sr-form", function (e) {
    e.preventDefault();
    const form = $(this);
    const submitButton = form.find("#submit-surf-sr-form");
    const originalButtonText = submitButton.html();
    processBatch(
      form,
      submitButton,
      originalButtonText,
      "surf_sr_process_replace",
      "#surf-sr-report-container-ajax",
    );
  });
});
