<?php
/**
 * CreateTag.
 * php version 5.6
 *
 * @category CreateTag
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */

namespace SureTriggers\Integrations\Wordpress\Actions;

use SureTriggers\Integrations\AutomateAction;
use SureTriggers\Traits\SingletonLoader;
use WP_User;
use Exception;

/**
 * CreateTag
 *
 * @category CreateTag
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */
class CreateTag extends AutomateAction {

	/**
	 * Integration type.
	 *
	 * @var string
	 */
	public $integration = 'WordPress';

	/**
	 * Action name.
	 *
	 * @var string
	 */
	public $action = 'create_tag';

	use SingletonLoader;

	/**
	 * Register action.
	 *
	 * @param array $actions action data.
	 * @return array
	 */
	public function register( $actions ) {
		$actions[ $this->integration ][ $this->action ] = [
			'label'    => __( 'Create New Tag', 'suretriggers' ),
			'action'   => 'create_tag',
			'function' => [ $this, 'action_listener' ],
		];

		return $actions;
	}

	/**
	 * Action listener.
	 *
	 * @param int   $user_id user_id.
	 * @param int   $automation_id automation_id.
	 * @param array $fields fields.
	 * @param array $selected_options selectedOptions.
	 * @return array|string
	 * @throws Exception Exception.
	 */
	public function _action_listener( $user_id, $automation_id, $fields, $selected_options ) {
		$tag_name        = $selected_options['tag_name'];
		$tag_description = $selected_options['tag_description'];
		$tag_slug        = $selected_options['tag_slug'];


		$category = wp_insert_term(
			$tag_name,
			'post_tag',
			[
				'description' => $tag_description,
				'slug'        => $tag_slug,
			]
		);
		if ( $category ) {
			return [
				$category,
			];
		} else {
			return [
				'status'  => 'error',
				'message' => 'Not able to create a tag.',
			];
		}
	}
}

CreateTag::get_instance();
