import{proxyCustomElement,HTMLElement,createEvent,h}from"@stencil/core/internal/client";import{i as isRtl}from"./page-align.js";import{d as defineCustomElement$3}from"./sc-icon2.js";import{d as defineCustomElement$2}from"./sc-product-line-item-note2.js";import{d as defineCustomElement$1}from"./sc-quantity-select2.js";const scProductLineItemCss=":host {\n  display: block;\n  font-family: var(--sc-font-sans);\n  --sc-product-line-item-line-gap: 6px;\n}\n\n.item {\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  gap: var(--sc-spacing-large);\n  justify-content: space-between;\n  align-items: stretch;\n  width: 100%;\n  border-bottom: none;\n  container-type: inline-size;\n}\n.item__text-container {\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  flex-direction: column;\n  gap: var(--sc-product-line-item-line-gap);\n  justify-content: space-between;\n  align-items: stretch;\n  width: 100%;\n  border-bottom: none;\n}\n.item__row {\n  display: flex;\n  gap: 18px;\n  justify-content: space-between;\n  align-items: stretch;\n  width: 100%;\n}\n.item__row.stick-bottom {\n  margin-top: auto;\n}\n.item__scratch-price {\n  text-decoration: line-through;\n  font-size: var(--sc-font-size-small);\n  line-height: 1;\n  color: var(--sc-input-help-text-color);\n  white-space: nowrap;\n}\n.item__remove-container {\n  display: flex;\n  gap: 6px;\n  align-items: center;\n  line-height: 1;\n  cursor: pointer;\n  color: var(--sc-input-help-text-color);\n  font-size: var(--sc-input-help-text-font-size-medium);\n}\n\n.item__text {\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  gap: 6px;\n  flex-direction: column;\n  align-items: flex-start;\n  justify-content: flex-start;\n  flex: 1 1 0%;\n}\n\n.item__text-details {\n  display: grid;\n  gap: var(--sc-product-line-item-line-gap);\n}\n\n.item__title {\n  box-sizing: border-box;\n  min-width: 0px;\n  margin: 0;\n  color: var(--sc-line-item-title-color, var(--sc-input-label-color));\n  font-size: var(--sc-font-size-medium);\n  font-weight: var(--sc-font-weight-semibold);\n  line-height: 1;\n  cursor: pointer;\n  display: -webkit-box;\n  display: -moz-box;\n  -webkit-box-orient: vertical;\n  -moz-box-orient: vertical;\n  -webkit-line-clamp: 3;\n  -moz-box-lines: 3;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.item__suffix {\n  flex: 1;\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  flex-direction: column;\n  -webkit-box-pack: start;\n  justify-content: space-between;\n  align-items: flex-end;\n  min-width: 100px;\n  margin-left: auto;\n  align-self: center;\n}\n\n.product-line-item__removable .item__suffix {\n  align-self: flex-start;\n}\n\n.product-line-item__editable .item__suffix {\n  align-self: flex-start;\n}\n\n.product-line-item__purchasable-status {\n  font-size: var(--sc-font-size-x-small);\n  color: var(--sc-input-error-text-color);\n}\n\n.item__price {\n  text-align: right;\n  max-width: 100%;\n  display: grid;\n  gap: var(--sc-product-line-item-line-gap);\n}\n\n.item__description {\n  color: var(--sc-price-label-color, var(--sc-input-help-text-color));\n  font-size: var(--sc-price-label-font-size, var(--sc-input-help-text-font-size-medium));\n  line-height: 1;\n  display: flex;\n  flex-wrap: wrap;\n  flex-direction: column;\n  gap: var(--sc-product-line-item-line-gap);\n  text-wrap: pretty;\n}\n.item__description:last-child {\n  align-items: flex-end;\n  text-align: right;\n}\n\n.item__image-placeholder {\n  width: var(--sc-product-line-item-image-size, 65px);\n  height: var(--sc-product-line-item-image-size, 65px);\n  background-color: var(--sc-input-border-color, var(--sc-input-border));\n  border-radius: 4px;\n  flex: 0 0 var(--sc-product-line-item-image-size, 65px);\n}\n\n.item__image,\n.attachment-thumbnail {\n  width: var(--sc-product-line-item-image-size, 65px);\n  height: var(--sc-product-line-item-image-size, 65px);\n  object-fit: cover;\n  border-radius: 4px;\n  border: solid 1px var(--sc-input-border-color, var(--sc-input-border));\n  display: block;\n  box-shadow: var(--sc-input-box-shadow);\n  align-self: flex-start;\n}\n\n@container (max-width: 380px) {\n  .item__image,\n  .item__image-placeholder {\n    display: var(--sc-product-line-item-mobile-image-display, none);\n  }\n}\n.product__description {\n  display: flex;\n  gap: 0.5em;\n  align-items: center;\n}\n\n.price {\n  font-size: var(--sc-font-size-medium);\n  font-weight: var(--sc-font-weight-semibold);\n  color: var(--sc-input-label-color);\n  line-height: 1;\n  white-space: nowrap;\n  display: flex;\n  gap: 4px;\n  align-items: baseline;\n}\n\n.price__description {\n  font-size: var(--sc-font-size-small);\n  line-height: 1;\n  color: var(--sc-input-help-text-color);\n  text-align: right;\n  white-space: nowrap;\n}\n\n.item--is-rtl.price {\n  text-align: right;\n}\n.item--is-rtl .item__price {\n  text-align: left;\n}\n\n.base {\n  display: grid;\n  gap: var(--sc-spacing-x-small);\n}\n\n.fee__description {\n  color: var(--sc-input-help-text-color);\n}\n\nsc-quantity-select::part(base) {\n  box-shadow: none;\n  background-color: transparent;\n}\n\nsc-quantity-select::part(base):not(:focus-within) {\n  border-color: transparent;\n}\n\nsc-quantity-select::part(input),\nsc-quantity-select::part(plus),\nsc-quantity-select::part(minus) {\n  background-color: transparent;\n}",ScProductLineItemStyle0=scProductLineItemCss,ScProductLineItem=proxyCustomElement(class extends HTMLElement{constructor(){super(),this.__registerHost(),this.__attachShadow(),this.scUpdateQuantity=createEvent(this,"scUpdateQuantity",3),this.scRemove=createEvent(this,"scRemove",3),this.image=void 0,this.name=void 0,this.amount=void 0,this.scratch=void 0,this.displayAmount=void 0,this.scratchDisplayAmount=void 0,this.fees=void 0,this.price=void 0,this.variant="",this.quantity=void 0,this.interval=void 0,this.trial=void 0,this.removable=void 0,this.editable=!0,this.max=void 0,this.sku="",this.purchasableStatus=void 0,this.note=void 0}render(){var e,t,i;const n="fallback"===(null===(e=this.image)||void 0===e?void 0:e.type);return h("div",{key:"6de482d720940af319563435a15f0580fc2735a7",class:"base",part:"base"},h("div",{key:"b06e4988b25b9692fdb92aecd6f813a84d703637",part:"product-line-item",class:{item:!0,"item--has-image":!!(null===(t=this.image)||void 0===t?void 0:t.src),"item--is-rtl":isRtl(),"product-line-item__editable":this.editable,"product-line-item__removable":this.removable}},(null===(i=this.image)||void 0===i?void 0:i.src)?h("img",{...this.image,part:n?"placeholder__image":"image",class:n?"item__image-placeholder":"item__image"}):h("div",{class:"item__image-placeholder",part:"placeholder__image"}),h("div",{key:"712472ca37a2655b073c7636ee1112eb0baaec4e",class:"item__text-container"},h("div",{key:"0facc94936579fbf239e8d5e4acf6d90607c1388",class:"item__row"},h("div",{key:"f4c329ba180b140718f9273b73e2e750dd1bb20a",class:"item__title",part:"title"},h("slot",{key:"70b511a95ed6fd62f0106f3d53ce67f54f643f86",name:"title"},this.name)),h("div",{key:"e0f45e5225d857f36ae43755da7d86e3ba652d36",class:"price",part:"price__amount"},!!this.scratch&&this.scratch!==this.amount&&h("span",{key:"931bb41d4c0a05ca91b2f23c05e62ce76f37a288",class:"item__scratch-price"},this.scratch),this.amount,h("div",{key:"aed8db0584cc085f5b010c1c947884a95e3015c4",class:"price__description",part:"price__description"},this.interval))),h("div",{key:"28a0d4f77b9fb304533d078f99941b0397350697",class:"item__row"},h("div",{key:"0f062d1352dd8aa17dc829b6c58a1079e83ddf14",class:"item__description",part:"description"},this.variant&&h("div",{key:"a9ef2df674b324cfdfcee9cf73e07452e9474f9b"},this.variant),this.price&&h("div",{key:"8718c8733f91e78c358bb6ceb6a74bad322f79ef"},this.price),this.sku&&h("div",{key:"8ea39efc16a00bc097b08ebbde82a87d1e46a829"},wp.i18n.__("SKU:","surecart")," ",this.sku),!!this.purchasableStatus&&h("div",{key:"ce3ebc9f1734671b24db3c8dd999a0dc43ff2d3d"},this.purchasableStatus),!!this.note&&h("sc-product-line-item-note",{key:"1c058a9a00fdb4c23849b4f08f9d9f840f83ec91",note:this.note})),h("div",{key:"37d72887f84e055101acea5c558904f6e85007c4",class:"item__description",part:"trial-fees"},!!this.trial&&h("div",{key:"e8b088809863ebca86a73cac2ec4091be3ec094f"},this.trial),(this.fees||[]).map((e=>h("div",null,null==e?void 0:e.display_amount," ",null==e?void 0:e.description))))),h("div",{key:"8143bde25630275710d71f7863fe68b0d6ad0b76",class:"item__row stick-bottom"},this.editable?h("sc-quantity-select",{max:this.max||1/0,exportparts:"base:quantity, minus:quantity__minus, minus-icon:quantity__minus-icon, plus:quantity__plus, plus-icon:quantity__plus-icon, input:quantity__input",clickEl:this.el,quantity:this.quantity,size:"small",onScChange:e=>e.detail&&this.scUpdateQuantity.emit(e.detail),"aria-label":
/** translators: %1$s: product name, %2$s: product price name */
wp.i18n.sprintf(wp.i18n.__("Change Quantity - %1$s %2$s","surecart"),this.name,this.price),productName:this.name}):h("span",{class:"item__description",part:"static-quantity"},wp.i18n.__("Qty:","surecart")," ",this.quantity),!!this.removable&&h("div",{key:"879262e88e4d6c359879a78c215fc609229cd1dd",class:"item__remove-container",onClick:()=>this.scRemove.emit(),onKeyDown:e=>{"Enter"===e.key&&this.scRemove.emit()},"aria-label":wp.i18n.sprintf(wp.i18n.__("Remove Item - %1$s %2$s","surecart"),this.name,this.amount),tabIndex:0},h("sc-icon",{key:"2923164eb505fbe045ae65146e3ea6f77de1cbe1",exportparts:"base:remove-icon__base",class:"item__remove",name:"x"}),h("span",{key:"9b34989ef6d8c61717ddb942a0764bd6a6d47957",class:"item__remove-text"},wp.i18n.__("Remove","surecart")))))))}get el(){return this}static get style(){return ScProductLineItemStyle0}},[1,"sc-product-line-item",{image:[16],name:[1],amount:[1],scratch:[1],displayAmount:[1,"display-amount"],scratchDisplayAmount:[1,"scratch-display-amount"],fees:[16],price:[1],variant:[1],quantity:[2],interval:[1],trial:[1],removable:[4],editable:[4],max:[2],sku:[1],purchasableStatus:[1,"purchasable-status"],note:[1]}]);function defineCustomElement(){"undefined"!=typeof customElements&&["sc-product-line-item","sc-icon","sc-product-line-item-note","sc-quantity-select"].forEach((e=>{switch(e){case"sc-product-line-item":customElements.get(e)||customElements.define(e,ScProductLineItem);break;case"sc-icon":customElements.get(e)||defineCustomElement$3();break;case"sc-product-line-item-note":customElements.get(e)||defineCustomElement$2();break;case"sc-quantity-select":customElements.get(e)||defineCustomElement$1()}}))}export{ScProductLineItem as S,defineCustomElement as d};