import{h}from"@stencil/core";import{__,sprintf}from"@wordpress/i18n";import{speak}from"@wordpress/a11y";import{isRtl}from"../../../functions/page-align";export class ScQuantitySelect{constructor(){this.clickEl=void 0,this.disabled=void 0,this.max=1/0,this.min=1,this.quantity=0,this.productName="Product",this.size="medium",this.hasFocus=void 0}decrease(){this.disabled||(this.quantity=Math.max(this.quantity-1,this.min),
// translators: %1$s is the product name
speak(sprintf(__("Decreased %1$s quantity by one","surecart"),this.productName),"assertive"),this.scChange.emit(this.quantity),this.scInput.emit(this.quantity))}increase(){this.disabled||(this.quantity=Math.min(this.quantity+1,this.max),
// translators: %1$s is the product name
speak(sprintf(__("Increased %1$s quantity by one","surecart"),this.productName),"assertive"),this.scChange.emit(this.quantity),this.scInput.emit(this.quantity))}handleBlur(){this.hasFocus=!1,this.scBlur.emit()}handleFocus(){this.hasFocus=!0,this.scFocus.emit()}handleChange(){this.quantity=parseInt(this.input.value)>this.max?this.max:parseInt(this.input.value),
// translators: %1$s is the product name, %2$s is the quantity
speak(sprintf(__("Quantity of %1$s changed to %2$s","surecart"),this.productName,this.quantity),"assertive"),this.scChange.emit(this.quantity)}handleInput(){this.quantity=parseInt(this.input.value),this.scInput.emit(this.quantity)}render(){return h("div",{key:"9212ec3e2c128453ae8f2456005e14d85c4f3c67",part:"base",class:{quantity:!0,"quantity--focused":this.hasFocus,"quantity--disabled":this.disabled,"quantity--is-rtl":isRtl(),"quantity--small":"small"===this.size}},h("button",{key:"aeb2ac5f1622eafc275cb27d4f4f9a359926717f",part:"minus","aria-label":
/** translators: %1$s: product name */
sprintf(__("Decrease %1$s quantity by one","surecart"),this.productName),"aria-disabled":this.disabled||this.quantity<=this.min&&this.min>1,class:{button__decrease:!0,"button--disabled":this.quantity<=this.min&&this.min>1},onClick:()=>this.quantity>this.min&&this.decrease(),disabled:this.disabled||this.quantity<=this.min&&this.min>1},h("sc-icon",{key:"02385e0a44206dcfe34811f7caa76d6db30563d8",name:"minus",exportparts:"base:minus__icon"})),h("input",{key:"668f691448a47e1866341933c6a88709a193f374",part:"input",class:"input__control",ref:e=>this.input=e,step:"1",type:"number",max:this.max,min:this.min,value:this.quantity,disabled:this.disabled,autocomplete:"off",role:"spinbutton","aria-valuemax":this.max,"aria-valuemin":this.min,"aria-valuenow":this.quantity,"aria-disabled":this.disabled,onChange:()=>this.handleChange(),onInput:()=>this.handleInput(),onFocus:()=>this.handleFocus(),onBlur:()=>this.handleBlur(),"aria-label":
/** translators: %1$s: product name */
sprintf(__("Quantity input for %1$s product","surecart"),this.productName)}),h("button",{key:"6177f71584d948eebc531d5e58452cfab81920c4",part:"plus","aria-label":
/** translators: %1$s: product name */
sprintf(__("Increase %1$s quantity by one","surecart"),this.productName),class:{button__increase:!0,"button--disabled":this.quantity>=this.max},onClick:()=>this.quantity<this.max&&this.increase(),"aria-disabled":this.disabled||this.quantity>=this.max,disabled:this.disabled||this.quantity>=this.max},h("sc-icon",{key:"3201a9cf67e55c1ef4656ff338282e92d4764daa",name:"plus",exportparts:"base:plus__icon"})))}static get is(){return"sc-quantity-select"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-quantity-select.scss"]}}static get styleUrls(){return{$:["sc-quantity-select.css"]}}static get properties(){return{clickEl:{type:"unknown",mutable:!1,complexType:{original:"HTMLElement",resolved:"HTMLElement",references:{HTMLElement:{location:"global",id:"global::HTMLElement"}}},required:!1,optional:!0,docs:{tags:[],text:""}},disabled:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"disabled",reflect:!1},max:{type:"number",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"max",reflect:!1,defaultValue:"Infinity"},min:{type:"number",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"min",reflect:!1,defaultValue:"1"},quantity:{type:"number",mutable:!0,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"quantity",reflect:!0,defaultValue:"0"},productName:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"product-name",reflect:!1,defaultValue:"'Product'"},size:{type:"string",mutable:!1,complexType:{original:"'small' | 'medium' | 'large'",resolved:'"large" | "medium" | "small"',references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"size",reflect:!0,defaultValue:"'medium'"},hasFocus:{type:"boolean",mutable:!0,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Inputs focus"},attribute:"has-focus",reflect:!0}}}static get events(){return[{method:"scChange",name:"scChange",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:""},complexType:{original:"number",resolved:"number",references:{}}},{method:"scInput",name:"scInput",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Emitted when the control receives input."},complexType:{original:"number",resolved:"number",references:{}}},{method:"scFocus",name:"scFocus",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Emitted when the control gains focus."},complexType:{original:"void",resolved:"void",references:{}}},{method:"scBlur",name:"scBlur",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Emitted when the control loses focus."},complexType:{original:"void",resolved:"void",references:{}}}]}static get elementRef(){return"el"}}