import{Fragment,h}from"@stencil/core";import{__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{formatTaxDisplay}from"../../../../functions/tax";import{productNameWithPrice}from"../../../../functions/price";export class ScUpcomingInvoice{constructor(){this.heading=void 0,this.successUrl=void 0,this.subscriptionId=void 0,this.priceId=void 0,this.variantId=void 0,this.quantity=void 0,this.discount=void 0,this.payment_method=void 0,this.quantityUpdatesEnabled=!0,this.adHocAmount=void 0,this.loading=void 0,this.busy=void 0,this.error=void 0,this.price=void 0,this.invoice=void 0,this.couponError=void 0}componentWillLoad(){onFirstVisible(this.el,(()=>{this.fetchItems()}))}isFutureInvoice(){return this.invoice.start_at>=(new Date).getTime()/1e3}async fetchItems(){var t,e;try{this.loading=!0,await Promise.all([this.getInvoice(),this.getPrice()])}catch(i){console.error(i),this.error=(null===(e=null===(t=null==i?void 0:i.additional_errors)||void 0===t?void 0:t[0])||void 0===e?void 0:e.message)||(null==i?void 0:i.message)||__("Something went wrong","surecart")}finally{this.loading=!1}}async getPrice(){this.priceId&&(this.price=await apiFetch({path:addQueryArgs(`surecart/v1/prices/${this.priceId}`,{expand:["product"]})}))}async getInvoice(){if(this.subscriptionId)return this.invoice=await apiFetch({method:"PATCH",path:addQueryArgs(`surecart/v1/subscriptions/${this.subscriptionId}/upcoming_period/`,{expand:["period.checkout","checkout.line_items","checkout.checkout_fees","checkout.shipping_fees","line_item.price","line_item.fees","price.product","checkout.payment_method","checkout.manual_payment_method","checkout.discount","discount.promotion","discount.coupon","payment_method.card","payment_method.payment_instrument","payment_method.paypal_account","payment_method.bank_account"]}),data:{price:this.priceId,variant:this.variantId,quantity:this.quantity,...this.adHocAmount?{ad_hoc_amount:this.adHocAmount}:{},...this.discount?{discount:this.discount}:{}}}),this.invoice}async applyCoupon(t){try{this.couponError="",this.busy=!0,this.discount={promotion_code:t.detail},await this.getInvoice()}catch(t){this.couponError=(null==t?void 0:t.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async updateQuantity(t){try{this.error="",this.busy=!0,this.quantity=t.detail,await this.getInvoice()}catch(t){this.error=(null==t?void 0:t.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async onSubmit(){try{this.error="",this.busy=!0,await apiFetch({path:`surecart/v1/subscriptions/${this.subscriptionId}`,method:"PATCH",data:{price:this.priceId,quantity:this.quantity,variant:this.variantId,...this.adHocAmount?{ad_hoc_amount:this.adHocAmount}:{},...this.discount?{discount:this.discount}:{}}}),this.successUrl?window.location.assign(this.successUrl):this.busy=!1}catch(t){this.error=(null==t?void 0:t.message)||__("Something went wrong","surecart"),this.busy=!1}}renderName(t){return"string"!=typeof(null==t?void 0:t.product)?productNameWithPrice(t):__("Plan","surecart")}renderRenewalText(){var t;return this.isFutureInvoice()?h("div",null,__("You'll be switched to this plan","surecart")," ",h("strong",null,__("at the end of your billing cycle on","surecart")," ",null===(t=this.invoice)||void 0===t?void 0:t.start_at_date)):h("div",null,__("You'll be switched to this plan","surecart")," ",h("strong",null,__("immediately","surecart")))}renderEmpty(){return h("slot",{name:"empty"},__("Something went wrong.","surecart"))}renderLoading(){return h("div",null,h("sc-skeleton",{style:{width:"30%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"20%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"40%"}}))}renderContent(){var t;if(this.loading)return this.renderLoading();if(!(null===(t=this.invoice)||void 0===t?void 0:t.checkout))return this.renderEmpty();const e=this.invoice.checkout;return h("div",{class:"new-plan"},h("div",{class:"new-plan__heading"},this.renderName(this.price)),h("div",null,h("span",{slot:"price"},null==e?void 0:e.subtotal_display_amount)),h("div",{style:{fontSize:"var(--sc-font-size-small)"}},this.renderRenewalText()))}renderSummary(){var t,e,i,n;if(this.loading)return this.renderLoading();if(!this.invoice)return this.renderEmpty();const o=null===(t=this.invoice)||void 0===t?void 0:t.checkout,s=(null==o?void 0:o.manual_payment)?null==o?void 0:o.manual_payment_method:null,r=null===(e=null==o?void 0:o.checkout_fees)||void 0===e?void 0:e.data,a=null===(i=null==o?void 0:o.shipping_fees)||void 0===i?void 0:i.data;return h(Fragment,null,null===(n=null==o?void 0:o.line_items)||void 0===n?void 0:n.data.map((t=>{var e,i,n,o,s,r,a,l;return h("sc-product-line-item",{image:null===(i=null===(e=t.price)||void 0===e?void 0:e.product)||void 0===i?void 0:i.line_item_image,name:null===(o=null===(n=t.price)||void 0===n?void 0:n.product)||void 0===o?void 0:o.name,price:null===(s=null==t?void 0:t.price)||void 0===s?void 0:s.name,variant:null==t?void 0:t.variant_display_options,editable:this.quantityUpdatesEnabled,purchasableStatus:null==t?void 0:t.purchasable_status_display,removable:!1,note:null==t?void 0:t.display_note,quantity:null==t?void 0:t.quantity,amount:null==t?void 0:t.subtotal_display_amount,interval:`${null===(r=null==t?void 0:t.price)||void 0===r?void 0:r.short_interval_text} ${null===(a=null==t?void 0:t.price)||void 0===a?void 0:a.short_interval_count_text}`,onScUpdateQuantity:t=>this.updateQuantity(t),fees:null===(l=null==t?void 0:t.fees)||void 0===l?void 0:l.data})})),h("sc-line-item",null,h("span",{slot:"description"},__("Subtotal","surecart")),h("span",{slot:"price"},null==o?void 0:o.subtotal_display_amount)),!!o.proration_amount&&h("sc-line-item",null,h("span",{slot:"description"},__("Proration Credit","surecart")),h("span",{slot:"price"},null==o?void 0:o.proration_display_amount)),!!o.applied_balance_amount&&h("sc-line-item",null,h("span",{slot:"description"},__("Applied Balance","surecart")),h("span",{slot:"price"},null==o?void 0:o.applied_balance_display_amount)),(null==r?void 0:r.length)>0&&h(Fragment,null,null==r?void 0:r.map((t=>h("sc-line-item",null,h("span",{slot:"description"},null==t?void 0:t.description),h("span",{slot:"price"},null==t?void 0:t.display_amount))))),!!o.trial_amount&&h("sc-line-item",null,h("span",{slot:"description"},__("Trial","surecart")),h("span",{slot:"price"},null==o?void 0:o.trial_display_amount)),h("sc-coupon-form",{discount:null==o?void 0:o.discount,discountsDisplayAmount:null==o?void 0:o.discounts_display_amount,label:__("Add Coupon Code","surecart"),onScApplyCoupon:t=>this.applyCoupon(t),error:this.couponError,collapsed:!0,buttonText:__("Add Coupon Code","surecart")}),!!(null==o?void 0:o.shipping_amount)&&h(Fragment,null,h("sc-line-item",{style:{marginTop:"var(--sc-spacing-small)"}},h("span",{slot:"description"},__("Shipping","surecart")),h("span",{slot:"price"},null==o?void 0:o.shipping_display_amount)),(null==a?void 0:a.length)>0&&h(Fragment,null,null==a?void 0:a.map((t=>h("sc-line-item",null,h("span",{slot:"description"},null==t?void 0:t.description),h("span",{slot:"price"},null==t?void 0:t.display_amount)))))),!!o.tax_amount&&h("sc-line-item",null,h("span",{slot:"description"},formatTaxDisplay(null==o?void 0:o.tax_label)),h("span",{slot:"price"},null==o?void 0:o.tax_display_amount)),h("sc-divider",{style:{"--spacing":"0"}}),h("sc-line-item",null,h("span",{slot:"description"},__("Payment","surecart")),h("a",{href:addQueryArgs(window.location.href,{action:"payment"}),slot:"price-description"},h("sc-flex",{"justify-content":"flex-start","align-items":"center",style:{"--spacing":"0.5em"}},!!s&&h("sc-manual-payment-method",{paymentMethod:s}),!s&&h("sc-payment-method",{paymentMethod:null==o?void 0:o.payment_method}),h("sc-icon",{name:"edit-3"})))),h("sc-line-item",{style:{"--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Total Due","surecart")),h("span",{slot:"price"},null==o?void 0:o.amount_due_display_amount),h("span",{slot:"currency"},o.currency)))}render(){return h("div",{key:"b10a3ae949447dc1819ccb05db85a7bc81b52736",class:"upcoming-invoice"},this.error&&h("sc-alert",{key:"566108b6e160d2435675ffb5636c73e6d7dff483",open:!!this.error,type:"danger"},h("span",{key:"847ccce5c4ac4d52eb546e5a7e56f23f615c26a7",slot:"title"},__("Error","surecart")),this.error),h(Fragment,{key:"6adf9fff95502e4a523b15773c4acace46795bd7"},h("sc-dashboard-module",{key:"b82791688a0e35453cbe385b8e67c5cd031ecf6f",heading:__("New Plan","surecart"),class:"plan-preview",error:this.error},h("sc-card",{key:"11e15e24b6932699ac8f3a309fb3febb7b088513"},this.renderContent())),h("sc-dashboard-module",{key:"d596f01b5b1a9d22070b87e0d4fb9ba426e3f997",heading:__("Summary","surecart"),class:"plan-summary"},h("sc-form",{key:"857969b5d3dc420fe897e485e442a867927f1433",onScFormSubmit:()=>this.onSubmit()},h("sc-card",{key:"6b54b82af3c54a6ca7ffdeb34726ea80163909e5"},this.renderSummary()),h("sc-button",{key:"3796db232e4e4b38863a51b3f1d39259df176dd6",type:"primary",full:!0,submit:!0,loading:this.loading||this.busy,disabled:this.loading||this.busy},__("Confirm","surecart")))),h("sc-text",{key:"04cbf28734337a138b1dc1ccbd15a6db73e4a793",style:{"--text-align":"center","--font-size":"var(--sc-font-size-small)","--line-height":"var(--sc-line-height-normal)"}},h("slot",{key:"31c98b3d458af68ea1d6eaf55d6ecbc338392805",name:"terms"}))),this.busy&&h("sc-block-ui",{key:"08c9d4aaaf3acd6d10278ef26421ac791b8ec5c5"}))}static get is(){return"sc-upcoming-invoice"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-upcoming-invoice.scss"]}}static get styleUrls(){return{$:["sc-upcoming-invoice.css"]}}static get properties(){return{heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"heading",reflect:!1},successUrl:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"success-url",reflect:!1},subscriptionId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"subscription-id",reflect:!1},priceId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"price-id",reflect:!1},variantId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"variant-id",reflect:!1},quantity:{type:"number",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"quantity",reflect:!1},discount:{type:"unknown",mutable:!0,complexType:{original:"{\n    promotion_code?: string;\n    coupon?: string;\n  }",resolved:"{ promotion_code?: string; coupon?: string; }",references:{}},required:!1,optional:!1,docs:{tags:[],text:""}},payment_method:{type:"unknown",mutable:!0,complexType:{original:"PaymentMethod",resolved:"PaymentMethod",references:{PaymentMethod:{location:"import",path:"../../../../types",id:"src/types.ts::PaymentMethod"}}},required:!1,optional:!1,docs:{tags:[],text:""}},quantityUpdatesEnabled:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"quantity-updates-enabled",reflect:!1,defaultValue:"true"},adHocAmount:{type:"number",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"ad-hoc-amount",reflect:!1}}}static get states(){return{loading:{},busy:{},error:{},price:{},invoice:{},couponError:{}}}static get elementRef(){return"el"}}