import{Fragment,h}from"@stencil/core";import{sprintf,__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{productNameWithPrice}from"../../../../functions/price";export class ScSubscription{constructor(){this.subscriptionId=void 0,this.showCancel=void 0,this.heading=void 0,this.query=void 0,this.protocol=void 0,this.subscription=void 0,this.updatePaymentMethodUrl=void 0,this.loading=void 0,this.cancelModal=void 0,this.resubscribeModal=void 0,this.busy=void 0,this.error=void 0}componentWillLoad(){onFirstVisible(this.el,(()=>{this.subscription||this.getSubscription()}))}async cancelPendingUpdate(){var e;if(confirm(__("Are you sure you want to cancel the pending update to your plan?","surecart")))try{this.busy=!0,this.subscription=await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${null===(e=this.subscription)||void 0===e?void 0:e.id}/`,{expand:["price","price.product","current_period","period.checkout","purchase","purchase.license","license.activations","discount","discount.coupon"]}),method:"PATCH",data:{purge_pending_update:!0}})}catch(e){(null==e?void 0:e.message)?this.error=e.message:this.error=__("Something went wrong","surecart"),console.error(this.error)}finally{this.busy=!1}}async renewSubscription(){var e;try{this.error="",this.busy=!0,this.subscription=await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${null===(e=this.subscription)||void 0===e?void 0:e.id}/renew`,{expand:["price","price.product","current_period","period.checkout","purchase","purchase.license","license.activations","discount","discount.coupon"]}),method:"PATCH"})}catch(e){this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getSubscription(){var e;try{this.loading=!0,this.subscription=await await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${this.subscriptionId||(null===(e=this.subscription)||void 0===e?void 0:e.id)}`,{expand:["price","price.product","current_period"],...this.query||{}})})}catch(e){(null==e?void 0:e.message)?this.error=e.message:this.error=__("Something went wrong","surecart"),console.error(this.error)}finally{this.loading=!1}}renderName(e){var t;return"string"!=typeof(null===(t=null==e?void 0:e.price)||void 0===t?void 0:t.product)?productNameWithPrice(null==e?void 0:e.price):__("Subscription","surecart")}renderRenewalText(e){const t=h("sc-subscription-status-badge",{subscription:e});return(null==e?void 0:e.cancel_at_period_end)&&e.current_period_end_at?h("span",null,t," ",
/* translators: %s: current period end date */
sprintf(__("Your plan will be canceled on %s","surecart"),e.current_period_end_at_date)):"trialing"===e.status&&e.trial_end_at?h("span",null,t," ",
/* translators: %s: trial end date */
sprintf(__("Your plan begins on %s","surecart"),e.trial_end_at_date)):"active"===e.status&&e.current_period_end_at?h("span",null,t," ",
/* translators: %s: current period end date */
sprintf(__("Your plan renews on %s","surecart"),e.current_period_end_at_date)):t}renderEmpty(){return h("slot",{name:"empty"},__("This subscription does not exist.","surecart"))}renderLoading(){return h("sc-stacked-list-row",{style:{"--columns":"2"},"mobile-size":0},h("div",{style:{padding:"0.5em"}},h("sc-skeleton",{style:{width:"30%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"20%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"40%"}})))}renderContent(){return this.loading?this.renderLoading():this.subscription?h(Fragment,null,h("sc-subscription-next-payment",{subscription:this.subscription,updatePaymentMethodUrl:this.updatePaymentMethodUrl},h("sc-subscription-details",{subscription:this.subscription}))):this.renderEmpty()}render(){var e,t,i,s,r,o,n,c;const a=(null==this?void 0:this.subscription.payment_method)||(null==this?void 0:this.subscription.manual_payment);return h("sc-dashboard-module",{key:"41b533c4fe48a6299c339e827291c248b3cda3e9",heading:this.heading||__("Current Plan","surecart"),class:"subscription",error:this.error},!!this.subscription&&(null===(e=null==this?void 0:this.subscription)||void 0===e?void 0:e.can_modify)&&h("sc-flex",{key:"5540b28a8d2bc8831103f0c694e6e90323e534f9",slot:"end",class:"subscription__action-buttons"},this.updatePaymentMethodUrl&&a&&h("sc-button",{key:"498086a691572e02bd6f9d76ceacc23a5a3befe0",type:"link",href:this.updatePaymentMethodUrl},h("sc-icon",{key:"122fc7153cb0d66bbb7a0a444dd49df0f876ebcc",name:"credit-card",slot:"prefix"}),__("Update Payment Method","surecart")),!a&&h("sc-button",{key:"b9f98d824335b33c1858ef5560556f90d320b268",type:"link",href:addQueryArgs(window.location.href,{action:"create",model:"payment_method",id:null==this?void 0:this.subscription.id,...!1===(null===(t=null==this?void 0:this.subscription)||void 0===t?void 0:t.live_mode)?{live_mode:!1}:{}})},h("sc-icon",{key:"d9316cd6c5a70bad426a8313d68e6c3857c5db7a",name:"credit-card",slot:"prefix"}),__("Add Payment Method","surecart")),!!Object.keys(null===(i=this.subscription)||void 0===i?void 0:i.pending_update).length&&h("sc-button",{key:"8153eb62aa38de9051e08df68c1ccc0ca1aaa8b2",type:"link",onClick:()=>this.cancelPendingUpdate()},h("sc-icon",{key:"ee83f4c17853b238ebe9087a490c7200e69e073c",name:"x-octagon",slot:"prefix"}),__("Cancel Scheduled Update","surecart")),(null===(s=null==this?void 0:this.subscription)||void 0===s?void 0:s.cancel_at_period_end)?h("sc-button",{type:"link",onClick:()=>this.renewSubscription()},h("sc-icon",{name:"repeat",slot:"prefix"}),__("Restore Plan","surecart")):"canceled"!==(null===(r=this.subscription)||void 0===r?void 0:r.status)&&(null===(o=this.subscription)||void 0===o?void 0:o.current_period_end_at)&&this.showCancel&&h("sc-button",{type:"link",onClick:()=>this.cancelModal=!0},h("sc-icon",{name:"x",slot:"prefix"}),__("Cancel Plan","surecart")),"canceled"===(null===(n=this.subscription)||void 0===n?void 0:n.status)&&h("sc-button",{key:"6497cbc56f4386c0d70f9a2dddf30a0bfe8c38fd",type:"link",...(null===(c=this.subscription)||void 0===c?void 0:c.payment_method)||(null==this?void 0:this.subscription.manual_payment)?{onClick:()=>this.resubscribeModal=!0}:{href:null==this?void 0:this.updatePaymentMethodUrl}},h("sc-icon",{key:"cb01f33008de985aa68a2b805d672fc6b28add8e",name:"repeat",slot:"prefix"}),__("Resubscribe","surecart"))),h("sc-card",{key:"6d5b5af082c5c4d3ef920d03f9e01df220bf760f",style:{"--overflow":"hidden"},noPadding:!0},this.renderContent()),this.busy&&h("sc-block-ui",{key:"dbbf45e0dc55da0096a0eb70c241a370b61cd233",spinner:!0}),h("sc-cancel-dialog",{key:"a9a37e6ebdd3600566b70f6e1d77ae7902a4f04b",subscription:this.subscription,protocol:this.protocol,open:this.cancelModal,onScRequestClose:()=>this.cancelModal=!1,onScRefresh:()=>this.getSubscription()},h("slot",{key:"3c020dd10acfb4d2454d4e2d59031c922d51e478",name:"cancel-popup-content",slot:"cancel-popup-content"})),h("sc-subscription-reactivate",{key:"2c5dd253a7d565c13e91f91737cf4e1064a54550",subscription:this.subscription,open:this.resubscribeModal,onScRequestClose:()=>this.resubscribeModal=!1,onScRefresh:()=>this.getSubscription()}))}static get is(){return"sc-subscription"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-subscription.scss"]}}static get styleUrls(){return{$:["sc-subscription.css"]}}static get properties(){return{subscriptionId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"The subscription ID"},attribute:"subscription-id",reflect:!1},showCancel:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether to show the cancel button"},attribute:"show-cancel",reflect:!1},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Heading to display"},attribute:"heading",reflect:!1},query:{type:"unknown",mutable:!1,complexType:{original:"object",resolved:"object",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Query to pass to the API"}},protocol:{type:"unknown",mutable:!1,complexType:{original:"SubscriptionProtocol",resolved:"SubscriptionProtocol",references:{SubscriptionProtocol:{location:"import",path:"../../../../types",id:"src/types.ts::SubscriptionProtocol"}}},required:!1,optional:!1,docs:{tags:[],text:"The subscription protocol"}},subscription:{type:"unknown",mutable:!0,complexType:{original:"Subscription",resolved:"Subscription",references:{Subscription:{location:"import",path:"../../../../types",id:"src/types.ts::Subscription"}}},required:!1,optional:!1,docs:{tags:[],text:"The subscription"}},updatePaymentMethodUrl:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Update the payment method url"},attribute:"update-payment-method-url",reflect:!1}}}static get states(){return{loading:{},cancelModal:{},resubscribeModal:{},busy:{},error:{}}}static get elementRef(){return"el"}}