import{Fragment,h}from"@stencil/core";import{__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{formatTaxDisplay}from"../../../../functions/tax";export class ScOrder{constructor(){this.orderId=void 0,this.customerIds=void 0,this.heading=void 0,this.order=void 0,this.purchases=void 0,this.loading=void 0,this.busy=void 0,this.error=void 0}componentDidLoad(){onFirstVisible(this.el,(()=>{this.fetchOrder(),this.fetchDownloads()}))}async fetchOrder(){try{this.loading=!0,await this.getOrder()}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.loading=!1}}async fetchDownloads(){try{this.busy=!0,this.purchases=await apiFetch({path:addQueryArgs("surecart/v1/purchases",{expand:["product","product.downloads","download.media"],order_ids:[this.orderId],customer_ids:this.customerIds,downloadable:!0})})}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getOrder(){this.order=await apiFetch({path:addQueryArgs(`surecart/v1/orders/${this.orderId}`,{expand:["checkout","checkout.checkout_fees","checkout.shipping_fees","checkout.line_items","line_item.price","line_item.fees","line_item.variant","variant.image","price.product","checkout.manual_payment_method","checkout.payment_method","checkout.selected_shipping_choice","shipping_choice.shipping_method","payment_method.card","payment_method.payment_instrument","payment_method.paypal_account","payment_method.bank_account","checkout.discount","discount.promotion","checkout.charge"]})})}renderLoading(){return h("sc-flex",{flexDirection:"column",style:{gap:"1em"}},h("sc-skeleton",{style:{width:"20%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"60%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"40%",display:"inline-block"}}))}renderCheckoutFees(e){var t,i,o,s;return(null===(i=null===(t=null==e?void 0:e.checkout_fees)||void 0===t?void 0:t.data)||void 0===i?void 0:i.length)?h(Fragment,null,null===(s=null===(o=null==e?void 0:e.checkout_fees)||void 0===o?void 0:o.data)||void 0===s?void 0:s.map((e=>h("sc-line-item",{key:e.id},h("span",{slot:"description"},e.description),h("span",{slot:"price"},e.display_amount))))):null}renderShippingFees(e){var t,i,o,s;return(null===(i=null===(t=null==e?void 0:e.shipping_fees)||void 0===t?void 0:t.data)||void 0===i?void 0:i.length)?h(Fragment,null,null===(s=null===(o=null==e?void 0:e.shipping_fees)||void 0===o?void 0:o.data)||void 0===s?void 0:s.map((e=>h("sc-line-item",{key:e.id},h("span",{slot:"description"},e.description),h("span",{slot:"price"},e.display_amount))))):null}renderEmpty(){return h("sc-empty",{icon:"shopping-bag"},__("Order not found.","surecart"))}renderContent(){var e,t,i,o,s,l,n,r;if(this.loading)return this.renderLoading();if(!(null===(e=this.order)||void 0===e?void 0:e.id))return this.renderEmpty();const a=null===(t=this.order)||void 0===t?void 0:t.checkout,d=null===(i=null==a?void 0:a.selected_shipping_choice)||void 0===i?void 0:i.shipping_method,c=null==d?void 0:d.name;return h(Fragment,null,((null===(o=null==a?void 0:a.line_items)||void 0===o?void 0:o.data)||[]).map((e=>{var t,i,o,s,l,n,r;return h("sc-product-line-item",{key:e.id,image:null==e?void 0:e.image,name:null===(i=null===(t=null==e?void 0:e.price)||void 0===t?void 0:t.product)||void 0===i?void 0:i.name,price:null===(o=null==e?void 0:e.price)||void 0===o?void 0:o.name,variant:null==e?void 0:e.variant_display_options,editable:!1,removable:!1,quantity:e.quantity,note:null==e?void 0:e.display_note,amount:e.subtotal_display_amount,trial:null===(s=null==e?void 0:e.price)||void 0===s?void 0:s.trial_text,interval:`${null===(l=null==e?void 0:e.price)||void 0===l?void 0:l.short_interval_text} ${null===(n=null==e?void 0:e.price)||void 0===n?void 0:n.short_interval_count_text}`,scratch:null==e?void 0:e.scratch_display_amount,purchasableStatus:null==e?void 0:e.purchasable_status_display,fees:null===(r=null==e?void 0:e.fees)||void 0===r?void 0:r.data})})),(null==a?void 0:a.subtotal_amount)!==(null==a?void 0:a.total_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Subtotal","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.subtotal_display_amount)),this.renderCheckoutFees(a),!!(null==a?void 0:a.trial_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Trial","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.trial_display_amount)),!!(null==a?void 0:a.discounts)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discounts","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.discounts_display)),!!(null===(l=null===(s=null==a?void 0:a.discount)||void 0===s?void 0:s.promotion)||void 0===l?void 0:l.code)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discount","surecart"),h("br",null),h("sc-tag",{type:"success"},__("Coupon:","surecart")," ",null===(r=null===(n=null==a?void 0:a.discount)||void 0===n?void 0:n.promotion)||void 0===r?void 0:r.code)),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.discounts_display_amount)),!!(null==a?void 0:a.shipping_amount)&&h(Fragment,null,h("sc-line-item",null,h("span",{slot:"description"},`${__("Shipping","surecart")} ${c?`(${c})`:""}`),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.shipping_display_amount)),this.renderShippingFees(a)),!!(null==a?void 0:a.tax_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${formatTaxDisplay(null==a?void 0:a.tax_label,"estimated"===(null==a?void 0:a.tax_status))} (${null==a?void 0:a.tax_percent}%)`),h("span",{slot:"price"},null==a?void 0:a.tax_display_amount),!!(null==a?void 0:a.tax_inclusive_amount)&&h("span",{slot:"price-description"},`(${__("included","surecart")})`)),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Total","surecart")),h("span",{slot:"price"},null==a?void 0:a.total_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),!!(null==a?void 0:a.proration_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Proration","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.proration_display_amount)),!!(null==a?void 0:a.applied_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Applied Balance","surecart")),h("span",{style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},slot:"price"},null==a?void 0:a.applied_balance_display_amount)),!!(null==a?void 0:a.credited_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Credited Balance","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.credited_balance_display_amount)),(null==a?void 0:a.amount_due)!==(null==a?void 0:a.total_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Amount Due","surecart")),h("span",{slot:"price"},null==a?void 0:a.amount_due_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),!!(null==a?void 0:a.paid_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Paid","surecart")),h("span",{slot:"price"},null==a?void 0:a.paid_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),!!(null==a?void 0:a.refunded_amount)&&h(Fragment,null,h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"description"},__("Refunded","surecart")),h("span",{slot:"price"},null==a?void 0:a.refunded_display_amount)),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Net Payment","surecart")),h("span",{slot:"price"},null==a?void 0:a.net_paid_display_amount))),(null==a?void 0:a.tax_reverse_charged_amount)>0&&h("sc-line-item",null,h("span",{slot:"description"},__("*Tax to be paid on reverse charge basis","surecart"))))}render(){var e,t,i,o,s,l,n;const r=null===(e=null==this?void 0:this.order)||void 0===e?void 0:e.checkout,a=null==r?void 0:r.manual_payment_method;return h("sc-spacing",{key:"925ca9af740c46777bdad1dff24d4e73c410c377",style:{"--spacing":"var(--sc-spacing-large)"}},h("sc-dashboard-module",{key:"c1928a640301fe2d206be4ce7284dd83a1030a92",error:this.error},h("span",{key:"42eff9423dc5f65bd815298d3d87362c159e9f26",slot:"heading"},this.loading?h("sc-skeleton",{style:{width:"120px"}}):`#${null===(t=null==this?void 0:this.order)||void 0===t?void 0:t.number}`),!this.loading&&!(null==r?void 0:r.live_mode)&&h("sc-tag",{key:"7aa1db7bbcba789291ebbdbb081e691aa5720023",type:"warning",slot:"end"},__("Test Mode","surecart")),!!(null==a?void 0:a.name)&&!!(null==a?void 0:a.instructions)&&h("sc-order-manual-instructions",{key:"26f758b51d6b43420b9acf8d4845910db94d2b56",manualPaymentTitle:null==a?void 0:a.name,manualPaymentInstructions:null==a?void 0:a.instructions}),h("sc-card",{key:"80c7ee49c5b21dea8ca22be77da627d135720c10","no-padding":!this.loading},this.loading?this.renderLoading():h(Fragment,null,h("sc-stacked-list",null,h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Order Status","surecart")),h("sc-order-status-badge",{status:null===(i=null==this?void 0:this.order)||void 0===i?void 0:i.status})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Date","surecart")),h("span",null,null===(o=this.order)||void 0===o?void 0:o.created_at_date)),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Payment Method","surecart")),h("sc-payment-method",{paymentMethod:null==r?void 0:r.payment_method})),h("div",{class:"order__row"},this.renderContent()))))),(null===(s=this.order)||void 0===s?void 0:s.statement_url)&&h("sc-button",{key:"9121d8a4872672dc0d67444a77e26d45bc9818a5",type:"primary",href:null===(l=this.order)||void 0===l?void 0:l.statement_url,target:"_blank"},h("sc-icon",{key:"e4f744ea74d0f3297081d5970edc207823faabcf",name:"inbox",slot:"prefix"}),__("Download Receipt/Invoice","surecart")),!!(null===(n=this.purchases)||void 0===n?void 0:n.length)&&h("sc-purchase-downloads-list",{key:"8c4a8f0319ee062649f389036f7fdf6bb4ec6fb8",heading:__("Downloads","surecart"),purchases:this.purchases}))}static get is(){return"sc-order"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-order.scss"]}}static get styleUrls(){return{$:["sc-order.css"]}}static get properties(){return{orderId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"order-id",reflect:!1},customerIds:{type:"unknown",mutable:!1,complexType:{original:"string[]",resolved:"string[]",references:{}},required:!1,optional:!1,docs:{tags:[],text:""}},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"heading",reflect:!1}}}static get states(){return{order:{},purchases:{},loading:{},busy:{},error:{}}}static get elementRef(){return"el"}}