<?php

if (!defined('ABSPATH')) {
	exit;
}

?>
<div class="sumup_container">
	<div id="sumup_notice" class="sumup_notice">
		<p class="sumup-notice__message"></p>
	</div>

	<div class="sumup_modal">
		<svg xmlns="http://www.w3.org/2000/svg" width="111" height="32" viewBox="0 0 111 32" fill="none">
			<g clip-path="url(#clip0_144_6689)">
				<path
					d="M74.9633 8.90819H74.8943C73.6646 8.90819 72.5496 9.41266 71.7566 10.2267C70.9636 9.42414 69.8486 8.91966 68.6188 8.91966H68.5498C66.1361 8.91966 64.1593 10.8688 64.1593 13.2651V21.7495H64.1708C64.2053 22.403 64.7453 22.9304 65.4121 22.9304C66.0786 22.9304 66.6188 22.403 66.6533 21.7495H66.6648V13.2651C66.6648 12.2332 67.5153 11.3847 68.5613 11.3847H68.6303C69.6533 11.3847 70.4808 12.1758 70.5153 13.1848C70.5153 13.2077 70.5153 13.2307 70.5153 13.2536V21.7495C70.5268 22.0017 70.6071 22.2196 70.7451 22.4145C70.9751 22.7355 71.3428 22.9419 71.7566 22.9419C72.4231 22.9419 72.9633 22.4145 72.9978 21.7609H73.0093V13.2765C73.0093 13.2536 73.0093 13.2192 73.0093 13.1963C73.0438 12.1988 73.8828 11.3962 74.8943 11.3962H74.9633C76.0093 11.3962 76.8598 12.2332 76.8598 13.2765V21.6807C76.8598 21.6921 76.8598 21.6921 76.8598 21.7036C76.8598 21.7151 76.8598 21.7265 76.8598 21.7265V21.7609C76.8943 22.4145 77.4343 22.9419 78.1011 22.9419C78.7676 22.9419 79.3078 22.4145 79.3423 21.7609H79.3538V13.2651C79.3423 10.8573 77.3771 8.90819 74.9633 8.90819Z"
					fill="black" />
				<path
					d="M60.2046 8.90819C59.5266 8.90819 58.9864 9.43561 58.9519 10.0891V18.585C58.9519 19.6169 58.0899 20.4539 57.0324 20.4539H56.9636C55.9061 20.4539 55.0556 19.6169 55.0556 18.585V10.1694C55.0556 10.1579 55.0556 10.1579 55.0556 10.1465V10.1235V10.0891C55.0211 9.43561 54.4809 8.90819 53.8029 8.90819C53.1246 8.90819 52.5844 9.43561 52.5499 10.0891H52.5384V18.585C52.5384 20.9813 54.5269 22.9304 56.9749 22.9304H57.0439C59.4921 22.9304 61.4806 20.9813 61.4806 18.585V10.0891C61.4231 9.43561 60.8829 8.90819 60.2046 8.90819Z"
					fill="black" />
				<path
					d="M89.7768 8.90819C89.0988 8.90819 88.5585 9.43561 88.524 10.0891H88.5125V18.585C88.5125 19.6169 87.6505 20.4539 86.6045 20.4539H86.5358C85.4783 20.4539 84.6278 19.6169 84.6278 18.585V10.1694C84.6278 10.1579 84.6278 10.1579 84.6278 10.1465V10.1235V10.0891C84.5933 9.43561 84.053 8.90819 83.375 8.90819C82.6968 8.90819 82.1565 9.43561 82.122 10.0891H82.1105V18.585C82.1105 20.9813 84.099 22.9304 86.5473 22.9304H86.616C89.0643 22.9304 91.0528 20.9813 91.0528 18.585V10.0891H91.0413C91.0068 9.43561 90.455 8.90819 89.7768 8.90819Z"
					fill="black" />
				<path
					d="M98.0988 8.90819H98.0298C95.5473 8.90819 93.5473 10.9032 93.5473 13.3453V18.4818C93.5473 18.6309 93.5358 18.7799 93.5473 18.929V28.709C93.5473 29.3855 94.1105 29.9357 94.8003 29.9357C95.4898 29.9357 96.053 29.3855 96.053 28.709V22.3113C96.5243 22.724 97.3173 22.9304 98.0298 22.9304H98.0988C100.582 22.9304 102.478 20.8093 102.478 18.3672V13.2307C102.478 10.7771 100.582 8.90819 98.0988 8.90819ZM100.041 18.4933C100.041 19.8347 99.1678 20.408 98.0988 20.408H98.0298C96.961 20.408 96.0875 19.8347 96.0875 18.4933V13.3568C96.0875 12.302 96.961 11.442 98.0298 11.442H98.0988C99.1678 11.442 100.041 12.302 100.041 13.3568V18.4933Z"
					fill="black" />
				<path
					d="M46.3883 14.446C44.9745 13.8957 44.1125 13.5173 44.1125 12.6918C44.1125 12.0383 44.6413 11.3733 45.825 11.3733C46.5723 11.3733 47.1928 11.6943 47.641 12.302C47.94 12.6918 48.2733 12.8867 48.641 12.8867C49.3535 12.8867 49.9513 12.3134 49.9513 11.637C49.9513 11.3733 49.8823 11.1325 49.7445 10.9376C48.9628 9.74516 47.3538 8.90819 45.825 8.90819C43.7218 8.90819 41.5953 10.2038 41.5953 12.6918C41.5953 15.2486 43.7103 16.0626 45.3998 16.7161C46.756 17.2436 47.9285 17.6907 47.9285 18.8143C47.9285 19.6398 47.1583 20.4768 45.6755 20.4768C45.2273 20.4768 44.3768 20.3736 43.8138 19.6972C43.5148 19.3532 43.1585 19.1583 42.8138 19.1583C42.1355 19.1583 41.5035 19.7545 41.5035 20.408C41.5035 20.6717 41.5838 20.9125 41.7448 21.1533C42.5263 22.3227 44.3078 22.9419 45.6643 22.9419C47.9858 22.9419 50.4455 21.4972 50.4455 18.8258C50.4455 16.0282 48.1928 15.1568 46.3883 14.446Z"
					fill="black" />
				<path
					d="M29.9755 0H2.31023C1.03443 0 0 1.02042 0 2.28162V29.7185C0 30.9795 1.03443 32 2.31023 32H29.9755C31.2512 32 32.2858 30.9795 32.2858 29.7185V2.28162C32.2743 1.02042 31.2512 0 29.9755 0ZM20.2748 24.0889C17.4589 26.8865 12.9534 27.0125 9.98798 24.4557C9.9765 24.4443 9.9535 24.4328 9.94203 24.4099C9.75813 24.2264 9.75813 23.9398 9.93052 23.7563L19.9415 13.8273C20.1254 13.6553 20.4127 13.6553 20.5966 13.8388C23.2172 16.7854 23.1022 21.2798 20.2748 24.0889ZM22.3552 8.23217L12.3442 18.1612C12.1603 18.3332 11.8729 18.3332 11.689 18.1498C9.0685 15.2146 9.17195 10.7202 12.0109 7.91115C14.8268 5.11357 19.3323 4.99893 22.2977 7.54425C22.3092 7.55573 22.3322 7.56717 22.3437 7.5901C22.5276 7.7621 22.5276 8.04873 22.3552 8.23217Z"
					fill="black" />
				<path
					d="M108.305 8.90819C106.926 8.90819 105.811 10.0203 105.811 11.3847C105.811 12.7491 106.926 13.8613 108.305 13.8613C109.684 13.8613 110.799 12.7491 110.799 11.3847C110.799 10.0203 109.684 8.90819 108.305 8.90819ZM108.305 13.265C107.259 13.265 106.42 12.4281 106.42 11.3847C106.42 10.3528 107.271 9.51586 108.305 9.51586C109.351 9.51586 110.19 10.3528 110.19 11.3847C110.19 12.4166 109.339 13.265 108.305 13.265Z"
					fill="black" />
				<path
					d="M108.582 11.4776C108.904 11.4203 109.111 11.1795 109.111 10.8469C109.111 10.4226 108.812 10.1474 108.352 10.1474H107.731C107.593 10.1474 107.478 10.2392 107.478 10.3997V12.1427C107.478 12.3262 107.582 12.4179 107.731 12.4179C107.881 12.4179 107.984 12.3262 107.984 12.1427V11.5005H107.996L108.628 12.2918C108.697 12.372 108.743 12.4179 108.869 12.4179C109.065 12.4179 109.134 12.2574 109.134 12.1771C109.134 12.0968 109.099 12.028 109.03 11.9592L108.582 11.4776ZM108.329 11.1221H107.996V10.629H108.329C108.478 10.629 108.593 10.7208 108.593 10.8699C108.593 11.0075 108.49 11.1221 108.329 11.1221Z"
					fill="black" />
			</g>
		</svg>

		<p class="sumup_modal-description">
			<?php esc_html_e('Accept payments through your SumUp account in WooCommerce. Take all payments in your online store with an easy and quick integration. No coding required.', 'sumup-payment-gateway-for-woocommerce'); ?>
		</p>

		<p class="sumup_modal-subheader">
			<?php esc_html_e('Connect in 4 steps:', 'sumup-payment-gateway-for-woocommerce'); ?>
		</p>

		<ol class="sumup_modal-list">
			<li>
				<?php esc_html_e('Start by connecting your account. Learn more', 'sumup-payment-gateway-for-woocommerce'); ?>
			</li>
			<li>
				<?php esc_html_e('Log into your SumUp account, if you are not already logged in.', 'sumup-payment-gateway-for-woocommerce'); ?>
			</li>
			<li>
				<?php esc_html_e('Select the “Connect” button to begin.', 'sumup-payment-gateway-for-woocommerce'); ?>
			</li>
			<li>
				<?php esc_html_e('Return to WooCommerce by selecting the “View plugin” button.', 'sumup-payment-gateway-for-woocommerce'); ?>
			</li>
		</ol>

		<div class="sumup__modal-action-wrapper">
			<a id="sumup-payment-settings-connect"
				class="sumup_modal-button sumup_modal-button--primary sumup__button sumup__button--connect" href="#"
				data-text="<?php esc_attr_e('Connect Account', 'sumup-payment-gateway-for-woocommerce'); ?>">
				<?php esc_html_e('Connect Account', 'sumup-payment-gateway-for-woocommerce'); ?>
			</a>
		</div>
	</div>
</div>
