<?php
/**
 * Plugin Name: SummPressAI
 * Plugin URI: https://vned.pro/sumpressai
 * Description: Create AI-powered summaries of articles and publish them as WordPress posts.
 * Version: 1.1.2
 * Requires at least: 5.6
 * Requires PHP: 7.4
 * Author: VNED.PRO
 * Author URI: https://vned.pro
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: summpressai
 * Domain Path: /languages
 *
 * SummPress is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * SummPress is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SummPressAI. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */

// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// Define plugin constants.
define( 'SUMMPRESS_VERSION', '1.1.0' );
define( 'SUMMPRESS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SUMMPRESS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'SUMMPRESS_PLUGIN_FILE', __FILE__ );

// Load Composer autoloader.
if ( file_exists( SUMMPRESS_PLUGIN_DIR . 'vendor/autoload.php' ) ) {
	require_once SUMMPRESS_PLUGIN_DIR . 'vendor/autoload.php';
}

// Include core files.
require_once SUMMPRESS_PLUGIN_DIR . 'includes/ai-services/interface-ai-service.php';
require_once SUMMPRESS_PLUGIN_DIR . 'includes/class-settings.php';
require_once SUMMPRESS_PLUGIN_DIR . 'includes/class-summpress.php';


/**
 * Plugin activation callback.
 *
 * @since 1.0.0
 */
function summpress_activate() {
	$default_settings = [
		'gemini_api_key'    => '',
		'openai_api_key'    => '',
		'summary_language'  => 'original',
		'post_status'       => 'draft',
		'post_type'         => 'post',
	];

	if ( ! get_option( 'summpress_settings' ) ) {
		add_option( 'summpress_settings', $default_settings );
	}

	flush_rewrite_rules();
}
// Activation hook.
register_activation_hook( SUMMPRESS_PLUGIN_FILE, 'summpress_activate' );


/**
 * Plugin deactivation callback.
 *
 * @since 1.0.0
 */
function summpress_deactivate() {
	flush_rewrite_rules();
}
// Deactivation hook.
register_deactivation_hook( SUMMPRESS_PLUGIN_FILE, 'summpress_deactivate' );
