<?php
/**
 * Plugin Name:       SummaTap
 * Description:       Floating button that opens ChatGPT to summarize the current page.
 * Version:           1.0.0
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            GuruWalk
 * Author URI:        https://summatap.guruwalk.com
 * Text Domain:       summatap
 * Domain Path:       /languages
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package SummaTap
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'SUMMATAP_VERSION', '1.0.0' );
define( 'SUMMATAP_PATH', plugin_dir_path( __FILE__ ) );
define( 'SUMMATAP_URL', plugin_dir_url( __FILE__ ) );

require_once SUMMATAP_PATH . 'includes/helpers.php';
require_once SUMMATAP_PATH . 'includes/class-summatap-loader.php';
require_once SUMMATAP_PATH . 'admin/class-summatap-admin.php';
require_once SUMMATAP_PATH . 'public/class-summatap-public.php';

// Translations are auto-loaded on WordPress.org since WP 4.6 using the plugin slug.

/**
 * Activation: defaults + notice flag + counters.
 */
function summatap_activate() {
	$defaults = summatap_default_options();
	$opts     = get_option( 'summatap_options', array() );
	$merged   = wp_parse_args( $opts, $defaults );
	update_option( 'summatap_options', $merged, false );
}
register_activation_hook( __FILE__, 'summatap_activate' );

/** Uninstall hook (logic lives in uninstall.php). */
register_uninstall_hook( __FILE__, 'summatap_uninstall_handler' );
function summatap_uninstall_handler() { /* WP loads uninstall.php */ }

/**
 * Bootstrap components.
 */
function summatap_bootstrap() {
	new SummaTap_Admin();
	new SummaTap_Public();
}
add_action( 'plugins_loaded', 'summatap_bootstrap', 20 );
