# Contributing to Plubo Routes
Contributions to this projects are more than welcome, whether it's:

- Reporting a bug 🐛
- Submitting a fix or improvement of the code 🩹
- Proposing new features 💡
- Becoming a maintainer 🧑‍💼

*All code is hosted on github.*

## All Code Changes Happen Through Pull Requests. [Github Flow](https://guides.github.com/introduction/flow/index.html)
Pull requests are the best way to propose changes to the codebase.

To make a pull request:

1. Fork the repo and create your branch from `main`.
2. Make your changes.
3. Make sure everything is OK and your code lints.
4. Issue a pull request
5. Update the documentation if necessary.

## Report bugs using Github's [issues](https://github.com/joanrodas/plubo-routes/issues)
GitHub issues are great to track public bugs. Report a bug by [opening a new issue](https://github.com/joanrodas/plubo-routes/issues/new/choose); it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Specific steps to reproduce, preferably with sample code
- What you expected to happen
- What actually happens
- Notes. Anything you think could be helpful. Things you've tried, what you think could be the cause or even suggesting possible solutions


## Use a Consistent Coding Style

* Tabs for indentation
* You can try running `npm run lint` for style unification

## License

Any contributions you make will be under GNU GPLv3 Software License. By contributing, you agree that your code will be licensed under the GNU GPLv3 License.
Feel free to contact the author if that's a concern.
