<div class="sf-account-page">

    <div class="logout-message">

        <?php
        printf(
            __('Hello <strong>%s</strong>, you are currently logged in. <a href="%s">Click here to log out.</a>', 'subscriptionflow-add-on-for-paywall'),
            esc_html($user_display_name),
            esc_url($logout_url)
        );

        ?>
    </div>
    <div class="flex flex-wrap lg:justify-between">
        <div class="w-full lg:w-1/2 lg:pr-20">
            <div class="mb-10">

                <div class="flex items-center justify-between border-b border-black py-1 mb-6">
                    <h5 class="font-callunasans text-xl"><?php echo esc_attr__('Subscriber Information', 'subscriptionflow-add-on-for-paywall'); ?></h5>

                </div>

                <div class="mb-8">
                    <h5 class="uppercase text-sm font-bold font-callunasans mb-1"><?php echo esc_attr__('Name', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                    <div class="font-calluna"><?php echo esc_attr($user_display_name); ?></div>
                </div>

                <div class="mb-8">
                    <h5 class="uppercase text-sm font-bold font-callunasans mb-1 mr-1"><?php echo esc_attr__('Email', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                    <div class="font-calluna"><?php echo esc_attr($user_email); ?></div>
                </div>
                <div class="mb-8">
                    <h5 class="uppercase text-sm font-bold font-callunasans mb-1"><?php echo esc_attr__('Organization', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                    <div class="font-calluna">--</div>
                </div>

                <div>
                    <h5 class="uppercase text-sm font-bold font-callunasans mb-1"><?php echo esc_attr__('Phone', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                    <div class="font-calluna"><?php echo esc_attr($billing_phone); ?></div>
                </div>
            </div>

            <div class="mb-10">
                <div class="flex items-center justify-between border-b border-black py-1 mb-6">
                    <h5 class="font-callunasans text-xl"><?php echo esc_attr__('Mailing Address', 'subscriptionflow-add-on-for-paywall'); ?></h5>

                </div>

                <div class="font-calluna">
                    <?php if (!empty($shipping_address_1) || !empty($shipping_address_2) || !empty($shipping_details)): ?>
                        <div><?php echo esc_attr($shipping_address_1); ?></div>
                        <div><?php echo esc_attr($shipping_address_2); ?></div>

                        <div><?php echo esc_attr($shipping_address_3); ?></div>
                        <div><?php echo (!empty($formatted_shipping_address) ? nl2br($formatted_shipping_address) : ''); ?> </div>
                    <?php else: ?>
                        --
                    <?php endif; ?>
                    <div></div>
                </div>
            </div>

            <div class="mb-10">
                <div class="flex items-center justify-between border-b border-black py-1 mb-6">
                    <h5 class="font-callunasans text-xl"><?php echo esc_attr__('Password', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                    <a href="<?php echo esc_url($current_url); ?>?pw_sf_edit=profile&update_type=password" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">

                            <path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4Z" />
                        </svg>

                    </a>
                </div>



                <div class="mb-8">
                    <h5 class="uppercase text-sm font-bold font-callunasans mb-1 mr-1"><?php echo esc_attr__('Password', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                    <div class="font-calluna">********</div>
                </div>
            </div>


        </div>

        <div class="w-full lg:w-1/2 lg:pr-20">
            <div class="mb-10">
                <div class="flex items-center justify-between border-b border-black py-1 mb-6">
                    <h5 class="font-callunasans text-xl"><?php echo esc_attr__('My Subscription', 'subscriptionflow-add-on-for-paywall'); ?></h5>
                </div>

                <h5 class="uppercase text-sm font-bold font-callunasans mb-1 mr-1"><?php echo esc_attr__('Account', 'subscriptionflow-add-on-for-paywall'); ?></h5>

                <div class="font-calluna">


                    <?php
                    $pw_sf_user_repeater_plan_list = get_user_meta($current_user_id, 'pw_sf_repeater_plan_list', true);


                    // Add table for plan details
                    if (!empty($pw_sf_user_repeater_plan_list)) {
                        $pw_sf_user_repeater_plan_list = json_decode($pw_sf_user_repeater_plan_list, true);

                        if (!empty($pw_sf_user_repeater_plan_list)) {
                            foreach ($pw_sf_user_repeater_plan_list as $pw_sf_user_plan) {
                                $pw_sf_is_auto_renew = isset($pw_sf_user_plan['is_auto_renew']) ? $pw_sf_user_plan['is_auto_renew'] : '';
                    ?>
                                <div class="mt-4">
                                    <?php echo esc_attr__('Subscription Type', 'subscriptionflow-add-on-for-paywall'); ?>: <?php echo esc_html($pw_sf_user_plan['plan_name']); ?>
                                </div>
                                <div class="flex items-center mb-1">
                                    <div><?php echo esc_attr__('Status', 'subscriptionflow-add-on-for-paywall'); ?>: </div>
                                    <div class="text-info font-bold status-info">
                                        <?php


                                        echo esc_html($pw_sf_user_plan['status']);

                                        if (!empty($pw_sf_user_plan['billing_end_date'])) {
                                            $billing_end_date = date_create($pw_sf_user_plan['billing_end_date']);
                                            if ($pw_sf_user_plan['status'] == 'Active') {
                                                echo sprintf(
                                                    "<span class='blling-date-desc'> until %s</span><br>",
                                                    esc_html(date_format($billing_end_date, "F j, Y"))
                                                );
                                            }
                                        }

                                        ?>
                                    </div>
                                </div>
                                <div class="flex items-center mb-1">
                                    <?php

                                    if ($pw_sf_user_plan['status'] == 'Active') {
                                        echo sprintf(
                                            "<p>%s</p>",
                                            ($pw_sf_is_auto_renew == 1)
                                                ? esc_html__("Your subscription will automatically renew on this date.", 'subscriptionflow-add-on-for-paywall')
                                                : esc_html__("Your subscription will end on this date unless you manually renew.", 'subscriptionflow-add-on-for-paywall')
                                        );
                                    }


                                    ?>
                                </div>


                    <?php
                            }
                        }
                    }
                    ?>


                </div>
            </div>

            <div class="mb-10">
                <div class="flex items-center justify-between border-b border-black py-1 mb-6">
                    <h5 class="font-callunasans text-xl"><?php echo esc_attr__('Billing Address', 'subscriptionflow-add-on-for-paywall'); ?></h5>

                </div>



                <div class="font-calluna mb-5">

                    <div class="font-calluna">
                        <div><?php echo esc_attr($billing_address_1); ?></div>
                        <div><?php echo esc_attr($billing_address_2); ?></div>

                        <div><?php echo esc_attr($billing_address_3); ?></div>
                        <div><?php echo (!empty($formatted_billing_address) ? nl2br($formatted_billing_address) : ''); ?> </div>
                        <div></div>
                    </div>
                </div>


            </div>

            <div class="mt-10 font-calluna">
                <?php echo wp_kses_post($pw_sf_customer_profile_billing_info); ?>
            </div>
        </div>
    </div>
</div>