<?php
// Prevent direct access to the file
if (!defined('ABSPATH')) exit;

/**
 * 
 * Show/hide content 
 * 
 */
function pw_sf_content_shortcode($atts, $content = null)
{
    // Extract attributes with defaults
    $atts = shortcode_atts(
        [
            'show' => 'logged_in',
            'plan_ids' => '', // Comma-separated list of plan IDs
        ],
        $atts,
        'pw_sf_content'
    );

    // Retrieve helper and configuration
    $pw_sf_helper_object = PW_sf_Helper::pw_sf_helper_object();
    $pw_sf_options = $pw_sf_helper_object->pw_sf_get_pw_sf_option_name();
    $restricted_html = (!empty($pw_sf_options['pw_sf_restricted_html'])) ? $pw_sf_options['pw_sf_restricted_html']  : '<div class="paywall-box">You need an active plan to access this content.</div>';

    // Check if user is logged in
    if (is_user_logged_in()) {


        $current_user_id = get_current_user_id();
        $pw_sf_user = wp_get_current_user();
        /***
         * 
         * Allow the selected user roles to always bypass the paywall. Administrators can always bypass the paywall. 
         * 
         * 
         */
        if (!empty($pw_sf_helper_object->pw_sf_should_bypass_paywall($pw_sf_user))) {

            return do_shortcode($content);
        }

        $plan_ids = array_filter(array_map('trim', explode(',', $atts['plan_ids'])));

        // Check if the user has specific plans or any active plan
        if (!empty($plan_ids) && sf_pw_userlogin_restriction($plan_ids)) {
            return do_shortcode($content);
        }

        if (empty($plan_ids) && pw_sf_is_user_plan_status_active()) {
            return do_shortcode($content);
        }

        // User is logged in but lacks required plans
        return $restricted_html;
    }

    // User is not logged in
    return $restricted_html;
}

// Register the shortcode
add_shortcode('pw_sf_content', 'pw_sf_content_shortcode');







/**
 * 
 * Shortcode function for login form
 * 
 * 
 */
function pw_sf_ajax_login_form_shortcode()
{

    // Use the singleton instance
    $pw_sf_helper_object = PW_sf_Helper::pw_sf_helper_object();
    $pw_sf_get_pw_sf_option_name = $pw_sf_helper_object->pw_sf_get_pw_sf_option_name();

    ob_start();

    $current_url = get_permalink();
    if (is_user_logged_in()) {



        $pw_sf_domain_url = (!empty($pw_sf_get_pw_sf_option_name['pw_sf_domain_url']) ? $pw_sf_get_pw_sf_option_name['pw_sf_domain_url'] :  '');

        $pw_sf_customer_profile_billing_info = (!empty($pw_sf_get_pw_sf_option_name['pw_sf_customer_profile_billing_info']) ? $pw_sf_get_pw_sf_option_name['pw_sf_customer_profile_billing_info'] :  '');

        $pw_sf_client_id = (!empty($pw_sf_get_pw_sf_option_name['pw_sf_client_id']) ? $pw_sf_get_pw_sf_option_name['pw_sf_client_id'] :  '');
        $pw_sf_enable_inapp_portal = (!empty($pw_sf_get_pw_sf_option_name['pw_sf_enable_inapp_portal']) ? $pw_sf_get_pw_sf_option_name['pw_sf_enable_inapp_portal'] :  '');

        $pw_sf_logout_form_redirect_url = (!empty($pw_sf_get_pw_sf_option_name['pw_sf_logout_form_redirect_url']) ? $pw_sf_get_pw_sf_option_name['pw_sf_logout_form_redirect_url'] :  '');

        $current_user_id = get_current_user_id();

        $current_user = wp_get_current_user();


        $user_display_name = $current_user->display_name;
        $user_email = $current_user->user_email;
        $first_name = $current_user->first_name;
        $last_name  = $current_user->last_name;

        // Retrieve custom user meta (you can replace 'billing_' with your custom meta field prefix)
        $billing_first_name = get_user_meta($current_user_id, 'billing_first_name', true);
        $billing_last_name = get_user_meta($current_user_id, 'billing_last_name', true);
        $billing_address_1 = get_user_meta($current_user_id, 'billing_address_1', true);
        $billing_address_2 = get_user_meta($current_user_id, 'billing_address_2', true);

        $billing_address_3 = get_user_meta($current_user_id, 'billing_address_3', true);
        $billing_city = get_user_meta($current_user_id, 'billing_city', true);
        $billing_postcode = get_user_meta($current_user_id, 'billing_postcode', true);
        $billing_country = get_user_meta($current_user_id, 'billing_country', true);
        $billing_phone = get_user_meta($current_user_id, 'billing_phone', true);

        $billing_state = get_user_meta($current_user_id, 'billing_state', true);


        $city_state_postcode = [];
        $billing_details = array();
        if (!empty($billing_city)) {
            $city_state_postcode[] = esc_attr($billing_city);
        }
        if (!empty($billing_state) && !empty($billing_postcode)) {
            $city_state_postcode[] = esc_attr($billing_state) . ' ' . esc_attr($billing_postcode); // No comma before ZIP
        } elseif (!empty($billing_state)) {
            $city_state_postcode[] = esc_attr($billing_state);
        } elseif (!empty($billing_postcode)) {
            $city_state_postcode[] = esc_attr($billing_postcode);
        }

        if (!empty($city_state_postcode)) {
            $billing_details[] = implode(', ', $city_state_postcode); // Keep comma only between City & State
        }

        if (!empty($billing_country)) {
            $billing_details[] = esc_attr($billing_country);
        }

        // Format address as a newline-separated string
        $formatted_billing_address = implode("\n", $billing_details);


        $wc_sf_customer_id = get_user_meta($current_user_id, 'wc_sf_customer_id', true);



        $shipping_first_name = get_user_meta($current_user_id, 'shipping_first_name', true);
        $shipping_last_name = get_user_meta($current_user_id, 'shipping_last_name', true);
        $shipping_address_1 = get_user_meta($current_user_id, 'shipping_address_1', true);

        $shipping_address_2 = get_user_meta($current_user_id, 'shipping_address_2', true);

        $shipping_address_3 = get_user_meta($current_user_id, 'shipping_address_3', true);
        $shipping_city = get_user_meta($current_user_id, 'shipping_city', true);
        $shipping_postcode = get_user_meta($current_user_id, 'shipping_postcode', true);
        $shipping_country = get_user_meta($current_user_id, 'shipping_country', true);
        $shipping_state = get_user_meta($current_user_id, 'shipping_state', true);


        $shipping_details = [];


        $city_state_postcode = [];
        if (!empty($shipping_city)) {
            $city_state_postcode[] = esc_attr($shipping_city);
        }
        if (!empty($shipping_state) && !empty($shipping_postcode)) {
            $city_state_postcode[] = esc_attr($shipping_state) . ' ' . esc_attr($shipping_postcode); // No comma before ZIP
        } elseif (!empty($shipping_state)) {
            $city_state_postcode[] = esc_attr($shipping_state);
        } elseif (!empty($shipping_postcode)) {
            $city_state_postcode[] = esc_attr($shipping_postcode);
        }

        if (!empty($city_state_postcode)) {
            $shipping_details[] = implode(', ', $city_state_postcode); // Keep comma only between City & State
        }

        if (!empty($shipping_country)) {
            $shipping_details[] = esc_attr($shipping_country);
        }

        // Format address as a newline-separated string
        $formatted_shipping_address = implode("\n", $shipping_details);


        $logout_url = wp_logout_url($pw_sf_logout_form_redirect_url);

?>
        <style>
            #sf-pw-customer-info-form h3 {

                font-weight: 700;
            }

            #sf-pw-customer-info-form input[type="text"],
            #sf-pw-customer-info-form input[type="date"],
            #sf-pw-customer-info-form input[type="email"],
            #sf-pw-customer-info-form input[type="number"],
            #sf-pw-customer-info-form input[type="password"],
            #sf-pw-customer-info-form input[type="search"],
            #sf-pw-customer-info-form input[type="tel"],
            #sf-pw-customer-info-form input[type="url"],
            #sf-pw-customer-info-form select,
            #sf-pw-customer-info-form textarea {
                border: solid 1px #66666680;
                border-radius: 3px;
                padding: 0.5rem 1rem;
                transition: all .3s;
                margin: 10px 0px 0px;
            }

            .sf_pw_form_group.pw_sf_full-size {
                float: left;
                width: 100%;

            }

            .status-info {
                padding: 0px 0px 0px 4px;
            }

            .sf-account-page .flex-wrap {
                flex-wrap: wrap;
            }

            .sf-account-page .flex {
                display: flex;
            }

            .sf-account-page .uppercase {
                text-transform: uppercase;
            }

            .sf-account-page .mb-1 {
                margin-bottom: .25rem;
            }

            .sf-account-page .text-sm {
                font-size: .875rem;
            }

            .sf-account-page .font-bold {
                font-weight: 700;
            }

            .sf-account-page .mb-8 {
                margin-bottom: 2rem;
            }

            .sf-account-page .border-b {
                border-bottom: 1px solid #000;
                border-bottom-color: rgb(0, 0, 0);
            }

            .sf-account-page .mb-6 {
                margin-bottom: 1.5rem;
            }

            .sf-account-page .justify-between {
                justify-content: space-between;
            }

            .sf-account-page .border-black {
                --border-opacity: 1;
                border-color: #000;
                border-color: rgba(0, 0, 0, var(--border-opacity));
            }

            .sf-account-page .mb-10 {
                margin-bottom: 2.5rem;
            }

            .sf-account-page h5 {
                font-weight: 600;
            }

            .sf-account-page {
                margin: 30px auto;
                max-width: 1200px;
            }

            #sf-pw-customer-info-form {
                display: flex;
                flex-wrap: wrap;
                justify-content: space-between;
            }

            .sf_pw_form_group {
                width: 49%;
                margin: 0px 0px 10px;
            }

            #sf-pw-customer-info-form h3 {
                width: 100%;
                font-size: 20px;
                font-weight: 600;
                padding: 22px 0px 0px;
            }

            .sf_pw_form_group.sf_pw_update-button {
                width: 100%;
                text-align: center;
                margin: 50px 0px 0px;
            }

            .sf_pw_form_group.sf_pw_update-button button {

                padding: 7px 30px 7px;
            }

            .sf-pw-customer-info-popup-inner {
                max-width: 1200px;
                margin: 30px auto;
            }

            .logout-message {
                padding: 16px 0px 21px;
            }

            @media (min-width: 1024px) {
                .sf-account-page .lg\:w-1\/2 {
                    width: 50%;
                }
            }

            @media (min-width: 1024px) {
                .sf-account-page .lg\:pr-20 {
                    padding-right: 5rem;
                }
            }
        </style>
    <?php
        if (!empty($_REQUEST['pw_sf_edit'])) {

            include plugin_dir_path(__FILE__) . 'templates/pw-sf-update-password-form.php';

        } else {

            include plugin_dir_path(__FILE__) . 'templates/pw-sf-user-dashboard.php';
        }



    }
    else{ 

      include plugin_dir_path(__FILE__) . 'templates/pw-sf-login-form.php'; 

    }
    
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('pw_sf_ajax_login_form', 'pw_sf_ajax_login_form_shortcode');




/**
 * 
 * Hide admin top bar
 * 
 */
function pw_sf_hide_admin_bar_for_roles()
{

    $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
    $pw_sf_option_name = $pw_sf_Helper_class_obj->pw_sf_get_pw_sf_option_name();


    $roles_to_hide = [(!empty($pw_sf_option_name['pw_sf_user_role']) ? $pw_sf_option_name['pw_sf_user_role'] : 'sf_customers')]; // Add roles here
    foreach ($roles_to_hide as $role) {
        if (current_user_can($role)) {
            add_filter('show_admin_bar', '__return_false');
            break;
        }
    }
}
add_action('after_setup_theme', 'pw_sf_hide_admin_bar_for_roles');
