<?php 
if ( !defined( 'ABSPATH' ) ) exit;
/***
 * 
 * Login form
 * 
*/
function pw_sf_frontend_ajax_login() {
    // Check nonce for security
    check_ajax_referer('pw-sf-ajax-login-nonce', 'security' );

    // Prepare login data
    $info = array();
    $info['user_login'] = sanitize_text_field( $_POST['pw_sf_username'] );
    $info['user_password'] = sanitize_text_field( $_POST['pw_sf_password'] );
    $info['remember'] = true;

    // Attempt to sign in
    $user_signon = wp_signon( $info, false );

    if ( is_wp_error( $user_signon ) ) {
        
        echo json_encode( array( 
            'loggedin' => false, 
            'message' => sprintf( wp_kses_post( $user_signon->get_error_message() ) )
        ) );
        
    } else {
        echo json_encode( array( 
            'loggedin' => true, 
            'message' => __( 'Login successful, redirecting...', 'subscriptionflow-add-on-for-paywall' ) 
        ) );
        
    }

    die();
}
add_action( 'wp_ajax_nopriv_ajaxlogin', 'pw_sf_frontend_ajax_login' ); // For non-logged-in users



/**
 * 
 * Update Customer Password
 * 
*/

function pw_sf_update_customer_password()
{
    // Check nonce for security
    check_ajax_referer('pw-sf-ajax-customer-info-update-nonce', 'pw_sf_customer_info_update_nonce');

    $current_user_id = get_current_user_id();
    $password = $_POST['sf_pw_customer_password'] ?? '';
    $confirm_password = $_POST['sf_pw_customer_confirm_password'] ?? '';

    // Ensure passwords match before updating
    if (!empty($password) && !empty($confirm_password)) {
        if ($password !== $confirm_password) {
            wp_send_json_error(['message' => __( 'Passwords do not match.', 'subscriptionflow-add-on-for-paywall' )]);
        } else {
            // Update password if provided
            if (!empty($password) && !empty($confirm_password)) {
                wp_set_password($password, $current_user_id);
            }

            wp_send_json_success([
                'message' => __('Password updated successfully.', 'subscriptionflow-add-on-for-paywall' ) 
            ]);
        }
    }

    wp_die();

    
}

add_action( 'wp_ajax_pw_sf_update_customer_password', 'pw_sf_update_customer_password' ); // For logged-in users


/**
 * 
 * Customer Info Update
 * 
*/

function pw_sf_update_customer_info()
{
    // Check nonce for security
    check_ajax_referer('pw-sf-ajax-customer-info-update-nonce', 'pw_sf_customer_info_update_nonce');

    // Initialize helper class object
    $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
    $token_response_msg = $pw_sf_Helper_class_obj->pw_sf_api_get_token();

    // Check if token retrieval was successful
    if (empty($token_response_msg->status)) {
        wp_send_json_error(['message' => 'Failed to retrieve token.']);
    }

    $access_token = $token_response_msg->data->access_token;
    $wc_sf_customer_id = $_POST['wc_sf_customer_id']; // Ensure it's an integer

    $current_user_id = get_current_user_id();
    $user_info = get_userdata($current_user_id); // Get user data

    // Sanitize input fields
    $first_name = sanitize_text_field($_POST['sf_pw_customer_first_name'] ?? '');
    $last_name = sanitize_text_field($_POST['sf_pw_customer_last_name'] ?? '');
    $email = sanitize_email($_POST['sf_pw_customer_email'] ?? '');
    $password = $_POST['sf_pw_customer_password'] ?? '';
    $confirm_password = $_POST['sf_pw_customer_confirm_password'] ?? '';

    // Ensure passwords match before updating
    if (!empty($password) && !empty($confirm_password)) {
        if ($password !== $confirm_password) {
            wp_send_json_error(['message' => 'Passwords do not match.']);
        }
    }

    // Update user email if provided and valid
    $user_update_data = [
        'ID'         => $current_user_id,
        'first_name' => $first_name,
        'last_name'  => $last_name,
    ];


    // Sanitize and store customer data for API & user meta update
    $customer_data = [
        'name'               => trim($first_name . ' ' . $last_name),
        'billing_address_1'  => sanitize_text_field($_POST['billing_address_1'] ?? ''),
        'billing_address_2'  => sanitize_text_field($_POST['billing_address_2'] ?? ''),
        'billing_city'       => sanitize_text_field($_POST['billing_city'] ?? ''),
        'billing_postal_code'   => sanitize_text_field($_POST['billing_postcode'] ?? ''),
        'billing_country'    => sanitize_text_field($_POST['billing_country'] ?? ''),
        'shipping_address_1' => sanitize_text_field($_POST['shipping_address_1'] ?? ''),
        'shipping_address_2' => sanitize_text_field($_POST['shipping_address_2'] ?? ''),
        'shipping_city'      => sanitize_text_field($_POST['shipping_city'] ?? ''),
        'shipping_postal_code'  => sanitize_text_field($_POST['shipping_postcode'] ?? ''),
        'shipping_country'   => sanitize_text_field($_POST['shipping_country'] ?? ''),
    ];

  

    
    // Update customer in external API
    $update_data_response = '';

    $get_customer_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(
        PW_SF_DOMAIN_URL . '/api/v1/customers/' . $wc_sf_customer_id, 
        $access_token, 
        'GET'
    );

    if (!empty($get_customer_detail_req['res_data']['data']['id'])) {
        $url = PW_SF_DOMAIN_URL . '/api/v1/customers/' . $wc_sf_customer_id;
        $update_data_response = $pw_sf_Helper_class_obj->pw_sf_curl_post_domain_form_request(
            $customer_data, 
            $url, 
            $access_token, 
            'PUT'
        );
    } else {
        $url = PW_SF_DOMAIN_URL . '/api/v1/contacts/' . $wc_sf_customer_id;
        $get_contacts_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(
            PW_SF_DOMAIN_URL . '/api/v1/contacts/' . $wc_sf_customer_id, 
            $access_token, 
            'GET'
        );

        if (!empty($get_contacts_detail_req['res_data']['data']['id'])) {
            $update_data_response = $pw_sf_Helper_class_obj->pw_sf_curl_post_domain_form_request(
                $customer_data, 
                $url, 
                $access_token, 
                'PUT'
            );
        }
    }


    if(!empty($update_data_response['res_data']['data']['id'])){


        wp_update_user($user_update_data);

        // Update password if provided
        if (!empty($password) && !empty($confirm_password)) {
            wp_set_password($password, $current_user_id);
        }

        if (!empty($email) && is_email($email)) {

            if ($email !== $user_info->user_email) {
    
                $user_update_data['user_email'] = $email;
                update_user_meta($current_user_id, 'nickname', $email);
    
            }
        }

        //Update WordPress user meta (billing & shipping info)
        foreach ($customer_data as $key => $value) {
            update_user_meta($current_user_id, $key, $value);
        }

        wp_send_json_success([
            'message' => 'User information updated successfully.'
        ]);

    }


    wp_send_json_error(array(
        'message' => (!empty($update_data_response['res_data']) ? $update_data_response['res_data'] : 'Looks like you made a mistake!')
    ));
    

    wp_die();
}

//add_action( 'wp_ajax_pw_sf_update_customer_info', 'pw_sf_update_customer_info' ); // For logged-in users

