<?php
// Prevent direct access to the file
if ( !defined( 'ABSPATH' ) ) exit;
/**
 * 
 * Customer Route
 * 
 * Set in SF Webhook
 * 
 * Webhook: http://example.com/wp-json/api/sf-pw-create-update-user?customer_id=e4f505c4-4af8-4c87-b938-7462216edeef
 * 
*/

add_action('rest_api_init', function () {
	register_rest_route( 'api', 'sf-pw-create-update-user',array(
				  'methods'  => 'GET',
				  'callback' => 'pw_sf_creat_customer_webhook',
				  'permission_callback' => '__return_true'
		));
  });



function pw_sf_creat_customer_webhook($request) {

	
	

	
	$pw_sf_response_logs=array();

	if(!empty($request['customer_id'])){

		ini_set('memory_limit', '512M'); // Increase memory limit only for this function
		ini_set('max_execution_time', 300); // Set execution time limit to 5 minutes for this function

		$pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
		$token_response_msg = $pw_sf_Helper_class_obj->pw_sf_api_get_token();


		if(!empty($token_response_msg->status)){

			if(!empty($token_response_msg->data->access_token)){

				$access_token=$token_response_msg->data->access_token;
				



				$get_customer_related_subscription_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/customers/'.$request['customer_id'].'/link/subscriptions',$access_token,'GET');



				$pw_sf_normal_subscription_plan_id_arr=array();
				$pw_sf_gift_subscription_arr=array();

				$counter_index=0;
				$pw_sf_gift_counter_index=0;
				if(!empty($get_customer_related_subscription_detail_req['res_data']['data'])){

					foreach($get_customer_related_subscription_detail_req['res_data']['data'] as $subscription_index => $pw_sf_single_subscription){

						$pw_sf_single_subscription_id=(!empty($pw_sf_single_subscription['id'])) ? $pw_sf_single_subscription['id'] : '';
						$pw_sf_single_subscription_status=(!empty($pw_sf_single_subscription['status'])) ? $pw_sf_single_subscription['status'] : '';
						$pw_sf_single_subscription_payment_status=(!empty($pw_sf_single_subscription['payment_status'])) ?  $pw_sf_single_subscription['payment_status'] : '';


						//Get Subscription by subscription ID
						$get_customer_subscription_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/subscriptions/'.$pw_sf_single_subscription_id,$access_token,'GET');

						if(!empty($get_customer_subscription_detail_req['res_data']['data']['attributes']['items'])){

							$pw_sf_nbilling_end_date=(!empty($get_customer_subscription_detail_req['res_data']['data']['attributes']['billing_end_date'])) ? $get_customer_subscription_detail_req['res_data']['data']['attributes']['billing_end_date'] : '';
							$pw_sf_nnext_bill_date=(!empty($get_customer_subscription_detail_req['res_data']['data']['attributes']['next_bill_date'])) ? $get_customer_subscription_detail_req['res_data']['data']['attributes']['next_bill_date'] : '';

							$pw_sf_is_auto_renew=(isset($get_customer_subscription_detail_req['res_data']['data']['attributes']['is_auto_renew'])) ? $get_customer_subscription_detail_req['res_data']['data']['attributes']['is_auto_renew'] : '';


							foreach($get_customer_subscription_detail_req['res_data']['data']['attributes']['items'] as $item_index => $pw_sf_singal_items){

							
								$pw_sf_plan_name=(!empty( $pw_sf_singal_items['plan_name'])) ? $pw_sf_singal_items['plan_name'] : '';
								$pw_sf_plan_id= (!empty( $pw_sf_singal_items['plan_id'])) ? $pw_sf_singal_items['plan_id'] : '';

								if(!empty($pw_sf_single_subscription['is_gift']) && !empty($pw_sf_single_subscription['recipient_id'])){

									$pw_sf_gift_subscription_arr[$pw_sf_single_subscription['recipient_id']][] = array(
										'plan_id' => $pw_sf_plan_id,
										'plan_name' => $pw_sf_plan_name,
										'status' => $pw_sf_single_subscription_status,
										'payment_status' => $pw_sf_single_subscription_payment_status,
										'is_gift' =>$pw_sf_single_subscription['is_gift'],
										'recipient_id' => $pw_sf_single_subscription['recipient_id'],
										'next_bill_date'=>$pw_sf_nnext_bill_date,
										'billing_end_date'=>$pw_sf_nbilling_end_date,
										'is_auto_renew'=>$pw_sf_is_auto_renew,
									);

									$pw_sf_gift_counter_index++;

								}
								else{
									// If it is a normal subscription
									$pw_sf_normal_subscription_plan_id_arr[] = array(
										'plan_id' => $pw_sf_plan_id,
										'plan_name' => $pw_sf_plan_name,
										'status' => $pw_sf_single_subscription_status,
										'payment_status' => $pw_sf_single_subscription_payment_status,
										'next_bill_date'=>$pw_sf_nnext_bill_date,
										'billing_end_date'=>$pw_sf_nbilling_end_date,
										'is_auto_renew'=>$pw_sf_is_auto_renew,
									);

									$counter_index++;

								}
				

								

							}


						}


					}

				}

			
				$pw_sf_option_name =$pw_sf_Helper_class_obj->pw_sf_get_pw_sf_option_name();
				
				/**
				 * 
				 * Create Subscription Contact as Customer into WP
				 * 
				 * 
				*/


				$pw_sf_response=array();

				if(!empty($pw_sf_gift_subscription_arr)){


					foreach($pw_sf_gift_subscription_arr as $pw_sf_single_gift_recipient_id => $pw_sf_single_gift_subscription_arr){

						$get_contacts_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/contacts/'.$pw_sf_single_gift_recipient_id,$access_token,'GET');

				
						if(!empty($get_contacts_detail_req['res_data']['data']['attributes'])){

							$get_contacts_detail_arr=$get_contacts_detail_req['res_data']['data']['attributes'];
							$pw_sf_contact_res=pw_sf_create_customer($request,$get_contacts_detail_arr,$pw_sf_option_name,$pw_sf_single_gift_subscription_arr);
							$pw_sf_response[]=(!empty($pw_sf_contact_res['res_data']) ? esc_html($pw_sf_contact_res['res_data']) : esc_html__('No record found!', 'subscriptionflow-add-on-for-paywall'));
							
						
						}
						
					
					}
					


				}

				/**
				 * 
				 * Create Customer if no Gift Subscription
				 * Create Customer If normal Plan
				 * 
				*/
				if(!empty($pw_sf_normal_subscription_plan_id_arr) || empty($pw_sf_gift_subscription_arr)){

				
					$get_customer_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/customers/'.$request['customer_id'],$access_token,'GET');

				
					if(!empty($get_customer_detail_req['res_data']['data']['attributes'])){

						$get_customer_detail_arr=$get_customer_detail_req['res_data']['data']['attributes'];
						$pw_sf_customer_res=pw_sf_create_customer($request,$get_customer_detail_arr,$pw_sf_option_name,$pw_sf_normal_subscription_plan_id_arr);

						$pw_sf_response[]=(!empty($pw_sf_customer_res['res_data']) ? esc_html($pw_sf_customer_res['res_data']) : esc_html__('No record found!', 'subscriptionflow-add-on-for-paywall'));
						
			
						
						
					}
					else{

						$pw_sf_response[]=(!empty($get_customer_detail_req['res_data']) ? esc_html($get_customer_detail_req['res_data']) : esc_html__('No record found!', 'subscriptionflow-add-on-for-paywall'));

			
					
						
					}
						

				}


				$pw_sf_response_logs['status']=true;
				if (!empty($pw_sf_response)) {
					// Concatenate all values from $pw_sf_response into a single string
					$pw_sf_response_logs['res_data'] = implode(', ', $pw_sf_response);
				} else {
					$pw_sf_response_logs['res_data'] = esc_html__('No record found!', 'subscriptionflow-add-on-for-paywall');
				}
				$pw_sf_response_logs['created_at']=date('Y-m-d H:i:s');
			

			}
		

		}
		else{

			$pw_sf_response_logs['status']=false;
			$pw_sf_response_logs['res_data']=(!empty($token_response_msg->data) ? $token_response_msg->data : 'Something went wrong,please try after again!' );
			$pw_sf_response_logs['created_at']=date('Y-m-d H:i:s');
		}
								
		$pw_sf_Helper_class_obj->pw_sf_api_logs('-----------------pw_sf_creat_customer_webhook triger---------------');
		$pw_sf_Helper_class_obj->pw_sf_api_logs(wp_json_encode($pw_sf_response_logs));
		$pw_sf_Helper_class_obj->pw_sf_api_logs('-----------------pw_sf_creat_customer_webhook triger end---------------');
		$pw_sf_Helper_class_obj->pw_sf_api_logs(' ');

		return wp_send_json($pw_sf_response_logs);


	
	}


   
}
/**
 * 
 * Create customer WP 
 * 
 * 
*/
function pw_sf_create_customer($request='',$customer_detail = array(),$pw_sf_option_name='',$pw_sf_subscription_arr=array()) {

	if(empty($customer_detail['email']))
		return;

	
	/**
	 * 
	 * Get user by SF customer ID
	 * 
	*/

	$get_user_by_key_val=get_users(array(
		'meta_key' => 'wc_sf_customer_id',
		'meta_value' => (!empty($customer_detail['id']) ? $customer_detail['id'] : '')
	));

	$email=(!empty($customer_detail['email']) ? $customer_detail['email']  : '');
	$user_exists = email_exists($email);


	$userdata=array();
	if(!empty($user_exists))
		$userdata['ID']= $user_exists;
	else
		$userdata['ID']= (!empty($get_user_by_key_val[0]->ID) ? $get_user_by_key_val[0]->ID : '');


	$user_pass=wp_generate_password( 8, false );


	if(!empty($customer_detail['name'])){
		$userdata['user_nicename']=sanitize_text_field($customer_detail['name']);
		$userdata['display_name']=sanitize_text_field($customer_detail['name']);
		$userdata['first_name']=sanitize_text_field($customer_detail['name']);
	}
	else{
		$userdata['user_nicename']=sanitize_text_field((!empty($customer_detail['first_name']) ? $customer_detail['last_name'] : '').' '.(!empty($customer_detail['last_name']) ? $customer_detail['first_name'] : ''));
		$userdata['display_name']=sanitize_text_field((!empty($customer_detail['first_name']) ? $customer_detail['last_name'] : '').' '.(!empty($customer_detail['last_name']) ? $customer_detail['first_name'] : ''));
		$userdata['first_name']=sanitize_text_field((!empty($customer_detail['first_name']) ? $customer_detail['last_name'] : '').' '.(!empty($customer_detail['last_name']) ? $customer_detail['first_name'] : ''));
	}
	if(!empty($customer_detail['email'])){
		$userdata['user_login']=sanitize_email($customer_detail['email']);
		$userdata['user_email']=sanitize_email($customer_detail['email']);
	}

	if(!$user_exists && (empty($get_user_by_key_val[0]->ID))){

		$userdata['user_pass']= $user_pass;

		pw_sf_customer_send_email($pw_sf_option_name,$userdata);
	
	}
	$userdata['role']= (!empty(	$pw_sf_option_name['pw_sf_user_role']) ? $pw_sf_option_name['pw_sf_user_role'] : 'sf_customers' );

    $pw_sf_response_logs = array();
    $user_id = wp_insert_user($userdata);

    if (is_wp_error($user_id)) {

        $pw_sf_response_logs = array(
            'status' => false,
            'res_data' => $user_id->get_error_message(),
            'email' => $customer_detail['email'],
            'created_at' => date('Y-m-d H:i:s')
		);

		return $pw_sf_response_logs;
    } 
	else {
        // Helper function to update user meta fields
        $update_user_meta_fields = function($fields, $prefix = '') use ($user_id, $customer_detail) {
            foreach ($fields as $key => $meta_key) {
				$value = '';
				if (!empty($customer_detail[$key])) {
					$value = $key === 'email' ? sanitize_email($customer_detail[$key]) : sanitize_text_field($customer_detail[$key]);
				}
                    update_user_meta($user_id, $prefix . $meta_key, $value);
                
            }
        };

		// Billing and Shipping fields mapping
		$billing_fields = [
			'name' => 'first_name',
			'billing_address_1' => 'address_1',
			'billing_address_2' => 'address_2',
			'billing_address_3' => 'address_3',
			'billing_city' => 'city',
			'billing_postal_code' => 'postcode',
			'billing_country' => 'country',
			'billing_state' => 'state',
			'email' => 'email',
			'phone_number' => 'phone'
		];

		$shipping_fields = [
				'name' => 'first_name',
				'shipping_address_1' => 'address_1',
				'shipping_address_2' => 'address_2',
				'shipping_address_3' => 'address_3',
				'shipping_city' => 'city',
				'shipping_postal_code' => 'postcode',
				'shipping_country' => 'country',
				'shipping_state' => 'state',
				'phone_number' => 'phone',
				'email' => 'email'
			];

        // Update user meta for billing and shipping
        $update_user_meta_fields($billing_fields, 'billing_');
        $update_user_meta_fields($shipping_fields, 'shipping_');

        // Additional user meta
        if (!empty($customer_detail['id'])) {
            update_user_meta($user_id, 'wc_sf_customer_id', sanitize_key($customer_detail['id']));
        }

        update_user_meta(
            $user_id,
            'pw_sf_allow_content_access',
            !empty($request['pw_sf_allow_content_access']) ? sanitize_text_field($request['pw_sf_allow_content_access']) : ''
        );

        update_user_meta(
            $user_id,
            'pw_sf_repeater_plan_list',
            !empty($pw_sf_subscription_arr) ? wp_json_encode($pw_sf_subscription_arr) : ''
        );

        // Prepare success response
        $pw_sf_response_logs = [
            'status' => true,
            'res_data' => sprintf(
                esc_html__('WP User has been updated. Email: %s', 'subscriptionflow-add-on-for-paywall'),
                !empty($customer_detail['email']) ? esc_html($customer_detail['email']) : ''
            ),
            'created_at' => date('Y-m-d H:i:s')
        ];

		return $pw_sf_response_logs;
    }

    
}


function pw_sf_customer_send_email($pw_sf_option_name='',$userdata=array()){


	$userlogins=(!empty($userdata['user_login'])) ? $userdata['user_login'] :'';
	$display_namess=(!empty($userdata['display_name'])) ? $userdata['display_name'] : '';
	$user_emailss=(!empty($userdata['user_email'])) ? $userdata['user_email'] : '';

	$pw_sf_site_title = get_bloginfo('name');

	// Email subject and message
	$subject = sprintf(__('Welcome to %s', 'subscriptionflow-add-on-for-paywall'), $pw_sf_site_title);


	$pw_sf_email_text=get_option('pw_sf_email_text');
	$pw_sf_email_customer_login=$pw_sf_option_name['pw_sf_email_customer_login'];



	if(!empty($pw_sf_option_name['pw_sf_customer_email']) && !empty($userdata['user_email']) && !empty($pw_sf_option_name['pw_sf_email_customer_login'])){

		$pw_sf_email_template=$pw_sf_option_name['pw_sf_customer_email'];
		$pw_sf_admin_email = get_option('admin_email');

		// Array of placeholders and their replacements
		$pw_sf_customer_email_placeholders = array('[display_name]', '[user_login]', '[user_pass]');
		$pw_sf_customer_email_placeholders_replacements = array($display_namess, $userlogins, $userdata['user_pass']);

		// Replace placeholders with actual values
		$email_content = str_replace($pw_sf_customer_email_placeholders, $pw_sf_customer_email_placeholders_replacements, $pw_sf_email_template);


		//$headers = array('Content-Type: text/html; charset=UTF-8');
		$headers = array(
			"Content-Type: text/html; charset=UTF-8",
			'From: ' . get_bloginfo('name') . ' <' . $pw_sf_admin_email . '>'
		);
		// Send email
		wp_mail($user_emailss, $subject, $email_content,$headers);


	}
}