<?php
// Prevent direct access to the file
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * 
 * Check if checkbox check on Post or Page
 * 
*/

add_filter('the_content', 'pw_sf_restrict_content');
function pw_sf_restrict_content($content) {

    
    if (is_single() || is_page()) {

        $post_id = get_the_ID();
    
        $checkbox_restrict = get_post_meta($post_id, '_pw_restrict_content', true);

        //Remove Restriction and it's a free article
        $pw_sf_free_article_checkbox = get_post_meta($post_id, 'pw_sf_free_article_checkbox', true);
        
        if(!empty($pw_sf_free_article_checkbox))
            return $content;

        $pw_sf_plans_array=array();

        $PW_sf_Helper=PW_sf_Helper::pw_sf_helper_object();
        $pw_sf_post_plan_arr= $PW_sf_Helper->pw_sf_repeater_field_data_arr($post_id, 'post');
        
        if(!empty($pw_sf_post_plan_arr))
            $pw_sf_plans_array = array_merge($pw_sf_plans_array, $pw_sf_post_plan_arr); 
     

        $pw_sf_check__pw_restrict_content=false;


        // Get categories and tags associated with the post
        // $pw_sf_categories = get_the_category($post_id);

    
        // if(!empty($pw_sf_categories)){

        //     foreach ($pw_sf_categories as $category) {
        //         $pw_sf_cate_meta_value = get_term_meta($category->term_id, '_pw_restrict_content', true);
        //         $pw_sf_post_plan_arr= $PW_sf_Helper->pw_sf_repeater_field_data_arr($category->term_id, 'term');
                
        //         if(!empty($pw_sf_post_plan_arr))
        //             $pw_sf_plans_array = array_merge($pw_sf_plans_array, $pw_sf_post_plan_arr); 

        //         if (!empty($pw_sf_cate_meta_value)) {
        
        //             $pw_sf_check__pw_restrict_content=true;
                    
        //         }
        //     }

        // }

    
        // Get all registered taxonomies for the post type, including the default 'category' taxonomy
        $pw_sf_taxonomies = get_object_taxonomies(get_post_type($post_id), 'names');

        if (!empty($pw_sf_taxonomies)) {
            foreach ($pw_sf_taxonomies as $pw_sf_taxonomy) {


                // Exclude 'post_format' and 'post_tag' taxonomies
                if ($pw_sf_taxonomy === 'post_format' || $pw_sf_taxonomy === 'post_tag') {
                    continue;
                }

                // Get terms associated with the post in this taxonomy
                $pw_sf_terms = get_the_terms($post_id, $pw_sf_taxonomy);

                if (!empty($pw_sf_terms) && !is_wp_error($pw_sf_terms)) {
                    foreach ($pw_sf_terms as $pw_sf_term) {
                        // Get term meta for '_pw_restrict_content'
                        $pw_sf_term_meta_value = get_term_meta($pw_sf_term->term_id, '_pw_restrict_content', true);

                        // Repeater fields
                        $pw_sf_post_plan_arr = $PW_sf_Helper->pw_sf_repeater_field_data_arr($pw_sf_term->term_id, 'term');

                        // Merge plan arrays if not empty
                        if (!empty($pw_sf_post_plan_arr)) {
                            $pw_sf_plans_array = array_merge($pw_sf_plans_array, $pw_sf_post_plan_arr);
                        }

                        // Set the flag if '_pw_restrict_content' meta value exists
                        if (!empty($pw_sf_term_meta_value)) {
                            $pw_sf_check__pw_restrict_content = true;
                        }
                    }
                }
            }
        }

        $pw_sf_check__tag_restrict_content=false;
        

        $pw_sf_tags = get_the_tags($post_id);
        if ($pw_sf_tags) {
            foreach ($pw_sf_tags as $tag) {
                $pw_sf_tag_meta_value = get_term_meta($tag->term_id, '_pw_restrict_content', true);

                //Repeater fields
                $pw_sf_post_plan_arr= $PW_sf_Helper->pw_sf_repeater_field_data_arr($tag->term_id, 'term');
              
                if(!empty($pw_sf_post_plan_arr))
                    $pw_sf_plans_array = array_merge($pw_sf_plans_array, $pw_sf_post_plan_arr); 

                if (!empty($pw_sf_tag_meta_value)) {

                    $pw_sf_check__tag_restrict_content=true;
                    
                }
            }
        }


   

        $restrict_content_check=false;
        if (!is_user_logged_in()) {

            /***
             * 
             * If user not loggedIN
             * 
             * &
             * 
             * Content is restricted
             * 
            */
            if (!empty($checkbox_restrict) || !empty( $pw_sf_check__tag_restrict_content) || !empty( $pw_sf_check__pw_restrict_content))
                $restrict_content_check=true;
        }
        else{



           


            /**
             * 
             * If user is loggendIN and Content is Blocked
             * 
            */

            $current_user_id = get_current_user_id();
            $pw_sf_user = wp_get_current_user();

            $pw_sf_option_name =$PW_sf_Helper->pw_sf_get_pw_sf_option_name();


            /***
             * 
             * Allow the selected user roles to always bypass the paywall. Administrators can always bypass the paywall. 
             * 
             * 
            */
            if(!empty($PW_sf_Helper->pw_sf_should_bypass_paywall($pw_sf_user))){
            
                    return $content;
            }

            $pw_sf_allow_content_access = get_user_meta( $current_user_id, 'pw_sf_allow_content_access', true);

    


            /**
             * 
             * Check if customer plan match with post/category/tag assign plan
             * 
            */

            $pw_sf_user_repeater_plan_list=get_user_meta($current_user_id,'pw_sf_repeater_plan_list',true);

            // echo '<pre>';
            // print_r($pw_sf_user_repeater_plan_list);
            // die;
 

            $check_repeater_field_plan=true;

            if(!empty( $pw_sf_user_repeater_plan_list)){

                if(!empty( $pw_sf_plans_array)){

                    $pw_sf_user_repeater_plan_list=json_decode($pw_sf_user_repeater_plan_list,true);

                    // echo '<pre>';
                    // print_r($pw_sf_user_repeater_plan_list);
                    // die;

                    // Use array_column to extract 'plan_id' indexed by 'plan_name'
                    $pw_sf_user_repeater_plan_plan_lookup = array_column($pw_sf_user_repeater_plan_list, 'plan_id', 'plan_name');

                 

                    // Compare values between the two arrays
                    $pw_sf_repeater_field_common_values = array_intersect($pw_sf_plans_array, $pw_sf_user_repeater_plan_plan_lookup);


                    foreach($pw_sf_plans_array as $single_pw_sf_plans_array){

                        // $pw_sf_user_arr_key = array_search($single_pw_sf_plans_array, array_column($pw_sf_user_repeater_plan_list, 'plan_id'));
                        foreach ($pw_sf_user_repeater_plan_list as $pw_sf_user_arr_key => $pw_sf_single_user_rplan) {
                            if ($pw_sf_single_user_rplan['plan_id'] === $single_pw_sf_plans_array) {

                                if(!empty($pw_sf_user_repeater_plan_list[$pw_sf_user_arr_key]['status'])){

                                    // && $pw_sf_user_repeater_plan_list[$pw_sf_user_arr_key]['payment_status']=='Paid'

                                    if($pw_sf_user_repeater_plan_list[$pw_sf_user_arr_key]['status']=='Active')
                                        $check_repeater_field_plan=false;

                                }
                         
                            }
                        }
                            
            

                    }


                    // if (!empty($pw_sf_repeater_field_common_values)) 
                    //     $check_repeater_field_plan=false;
    

                }
                else{
                    $check_repeater_field_plan=false;
                }

            }
           
          



            if ( (!empty($checkbox_restrict) || !empty( $pw_sf_check__tag_restrict_content) || !empty( $pw_sf_check__pw_restrict_content) ) && ($pw_sf_allow_content_access=='block' || !empty( $check_repeater_field_plan))  )
                $restrict_content_check=true;


        }
        
        if (!empty($restrict_content_check)) {

            $pw_sf_option_name = get_option('pw_sf_option_name');

            $pw_sf_content_before_paywall_box = get_post_meta($post_id, 'pw_sf_content_before_paywall_box', true);

            $pw_sf_lead_in_elements ="";
            if(!empty($pw_sf_option_name['pw_sf_lead_in_elements']) && empty($pw_sf_content_before_paywall_box)){
            
                if(!empty($pw_sf_option_name['pw_sf_gutenberg_lead_in_elements'])){
                    

                    $pw_sf_lead_in_elements .= force_balance_tags( 
                        wp_trim_words( 
                            wpautop($content), 
                            $pw_sf_option_name['pw_sf_lead_in_elements'], 
                            '' 
                        ) 
                    );

                }
                else{

                    if ( has_excerpt() ) {
						$pw_sf_lead_in_elements.=get_the_excerpt(); // Get manually added excerpt
					}
					else{
						
						$pw_sf_lead_in_elements.=force_balance_tags( html_entity_decode( wp_trim_words( htmlentities( wpautop($content) ), $pw_sf_option_name['pw_sf_lead_in_elements'], '' ) ) );
						
					}
                }
                
            }
            
            //$pw_sf_lead_in_elements.= wp_trim_words($content,$pw_sf_option_name['pw_sf_lead_in_elements']);

             

            

            $pw_sf_lead_in_elements.=(!empty($pw_sf_content_before_paywall_box) ? do_shortcode($pw_sf_content_before_paywall_box) : '');

            if(!empty($pw_sf_option_name['pw_sf_restricted_html'])){
                
                return (!empty( $pw_sf_lead_in_elements ) ?  $pw_sf_lead_in_elements  : '').$pw_sf_option_name['pw_sf_restricted_html'];
            }
            else{
                
                return (!empty($pw_sf_lead_in_elements) ? $pw_sf_lead_in_elements : '') . '<p>' . esc_html__('This content is restricted.', 'subscriptionflow-add-on-for-paywall') . '</p>';

            }
            
        }

    }
    
    
    return $content;
}

/**
 * 
 * Restriction content base on PLAN ID(Optional)
 * 
 * Check if is SF_Customer and Not blocked
 * 
*/
function sf_pw_userlogin_restriction($pw_sf_target_plan_ids = '') {

    if (is_user_logged_in()) {

        $current_user_id = get_current_user_id();
        $pw_sf_user = wp_get_current_user();

  

        $pw_sf_allow_content_access = get_user_meta($current_user_id, 'pw_sf_allow_content_access', true);

        $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();

        /***
         * 
         * Allow the selected user roles to always bypass the paywall. Administrators can always bypass the paywall. 
         * 
         * 
        */
        if(!empty($pw_sf_Helper_class_obj->pw_sf_should_bypass_paywall($pw_sf_user))){

            return true;
        }


        $pw_sf_option_name = $pw_sf_Helper_class_obj->pw_sf_get_pw_sf_option_name();


        $pw_sf_user_role = (!empty($pw_sf_option_name['pw_sf_user_role']) ? $pw_sf_option_name['pw_sf_user_role'] : 'sf_customers');
        $pw_sf_user_repeater_plan_list = get_user_meta($current_user_id, 'pw_sf_repeater_plan_list', true);

        // Convert the target plan IDs into an array, handling spaces and formatting
        if (!is_array($pw_sf_target_plan_ids)) {
            $pw_sf_target_plan_ids = explode(',', preg_replace('/\s+/', '', $pw_sf_target_plan_ids));
        }

        if (in_array($pw_sf_user_role, (array)$pw_sf_user->roles) && $pw_sf_allow_content_access !== 'block' && !empty($pw_sf_user_repeater_plan_list)) {

            $pw_sf_user_repeater_plan_list = json_decode($pw_sf_user_repeater_plan_list, true);

            if (!empty($pw_sf_user_repeater_plan_list)) {
                foreach ($pw_sf_target_plan_ids as $target_plan_id) {

                    foreach ($pw_sf_user_repeater_plan_list as $pw_sf_user_arr_key => $pw_sf_single_user_rplan) {
                        if ($pw_sf_single_user_rplan['plan_id'] === $target_plan_id) {

                            if(!empty($pw_sf_user_repeater_plan_list[$pw_sf_user_arr_key]['status'])){

                                // && $pw_sf_user_repeater_plan_list[$pw_sf_user_arr_key]['payment_status']=='Paid'

                                if($pw_sf_user_repeater_plan_list[$pw_sf_user_arr_key]['status']=='Active')
                                    return true;

                            }
                     
                        }
                    }
                    
                }
            }
        }
    }

    return false;
}


/**
 * 
 * Check if login user Plan Status is active or not
 * 
 * 
*/
function pw_sf_is_user_plan_status_active() {
    // Check if the user is logged in
    if (!is_user_logged_in()) {
        return false; // User is not logged in
    }

    $pw_sf_user = wp_get_current_user();

    $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
    /***
     * 
     * Allow the selected user roles to always bypass the paywall. Administrators can always bypass the paywall. 
     * 
     * 
    */
    if(!empty($pw_sf_Helper_class_obj->pw_sf_should_bypass_paywall($pw_sf_user))){

        return true;
    }
    // Get the logged-in user's ID
    $pw_sf_current_user_id = get_current_user_id();

    // Get the user's plan list from user meta
    $pw_sf_user_repeater_plan_list = get_user_meta($pw_sf_current_user_id, 'pw_sf_repeater_plan_list', true);

    // Decode the JSON string into an array
    $pw_sf_plan_list = json_decode($pw_sf_user_repeater_plan_list, true);

    // Check if the plan list exists and is an array
    if (!empty($pw_sf_plan_list) && is_array($pw_sf_plan_list)) {
        foreach ($pw_sf_plan_list as $pw_sf_plan) {
            // Check if the plan has 'Active' status
            if (isset($pw_sf_plan['status']) && $pw_sf_plan['status'] === 'Active') {
                return true; // Found an active plan
            }
        }
    }

    return false; // No active plans found
}

/**
 * 
 * 
 * Wordpress login should only work if the subscription is active and payment status is paid
 * 
 */
add_filter('authenticate', 'pw_sf_check_user_subscription_before_login', 30, 3);

function pw_sf_check_user_subscription_before_login($user, $username, $password) {
    // Only run this for valid users
    if (is_wp_error($user)) {
        return $user; // Return error if the user is already invalid
    }
    
    // Define user role for the subscription feature
    $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
    $pw_sf_option_name = $pw_sf_Helper_class_obj->pw_sf_get_pw_sf_option_name();

    // Check if the login restriction checkbox is enabled
    $pw_sf_login_restriction_enabled = !empty($pw_sf_option_name['pw_sf_customer_login_restriction']) ? $pw_sf_option_name['pw_sf_customer_login_restriction'] : false;

    if (!$pw_sf_login_restriction_enabled) {
        return $user; // Allow login if the restriction is disabled
    }

    $get_pw_sf_user_role = !empty($pw_sf_option_name['pw_sf_user_role']) ? $pw_sf_option_name['pw_sf_user_role'] : 'sf_customers';

    // Only check for subscribers
    if (in_array($get_pw_sf_user_role, (array) $user->roles)) {
        // Get the user meta field
        $pw_sf_subscriptions_json = get_user_meta($user->ID, 'pw_sf_repeater_plan_list', true);

        // If no subscription data, deny login
        if (empty($pw_sf_subscriptions_json)) {
            return new WP_Error('no_subscription', __('Login denied. No subscriptions found.', 'subscriptionflow-add-on-for-paywall'));
        }

        // Decode the JSON string safely
        $pw_sf_subscriptions_array = json_decode($pw_sf_subscriptions_json, true);
        if (!is_array($pw_sf_subscriptions_array)) {
            return new WP_Error('invalid_subscription_data', __('Login denied. Subscription data is invalid.', 'subscriptionflow-add-on-for-paywall'));
        }

        $has_active_plan = false;

        foreach ($pw_sf_subscriptions_array as $pw_sf_single_plan) {
            if (
                isset($pw_sf_single_plan['status'], $pw_sf_single_plan['payment_status']) && 
                trim(strtolower($pw_sf_single_plan['status'])) === 'active' && 
                trim(strtolower($pw_sf_single_plan['payment_status'])) === 'paid' // Ensure payment is completed
            ) {
                $has_active_plan = true;
                break;
            }
        }

        // If no active plans with completed payments are found, deny login
        if (!$has_active_plan) {
            return new WP_Error('inactive_subscription', __('Login denied. No active subscription plans with paid status found.', 'subscriptionflow-add-on-for-paywall'));
        }
    }

    // Allow login if everything is fine
    return $user;
}
