<?php
// Prevent direct access to the file
if ( !defined( 'ABSPATH' ) ) exit;
/**
 * 
 * Customer Route
 * 
 * Set in SF Webhook
 * 
 * Webhook: http://example.com/wp-json/api/sf-pw-create-update-user?customer_id=e4f505c4-4af8-4c87-b938-7462216edeef
 * 
*/

add_action('rest_api_init', function () {
	register_rest_route( 'api', 'sf-pw-create-update-user',array(
				  'methods'  => 'GET',
				  'callback' => 'pw_sf_creat_customer_webhook',
				  'permission_callback' => '__return_true'
		));
  });



function pw_sf_creat_customer_webhook($request) {

	
	

	
	$pw_sf_response_logs=array();

	if(!empty($request['customer_id'])){

		

		$pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
		$token_response_msg = $pw_sf_Helper_class_obj->pw_sf_api_get_token();


		if(!empty($token_response_msg->status)){

			if(!empty($token_response_msg->data->access_token)){

				$access_token=$token_response_msg->data->access_token;
				$get_customer_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/customers/'.$request['customer_id'],$access_token,'GET');



				$get_customer_related_subscription_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/customers/'.$request['customer_id'].'/link/subscriptions',$access_token,'GET');



				$plan_id_arr=array();

				$counter_index=0;
				if(!empty($get_customer_related_subscription_detail_req['res_data']['data'])){

					foreach($get_customer_related_subscription_detail_req['res_data']['data'] as $subscription_index => $pw_sf_single_subscription){

						$pw_sf_single_subscription_id=(!empty($pw_sf_single_subscription['id'])) ? $pw_sf_single_subscription['id'] : '';
						$pw_sf_single_subscription_status=(!empty($pw_sf_single_subscription['status'])) ? $pw_sf_single_subscription['status'] : '';
						$pw_sf_single_subscription_payment_status=(!empty($pw_sf_single_subscription['payment_status'])) ?  $pw_sf_single_subscription['payment_status'] : '';


						//Get Subscription by subscription ID
						$get_customer_subscription_detail_req = $pw_sf_Helper_class_obj->pw_sf_curl_get_sf_request(PW_SF_DOMAIN_URL.'/api/v1/subscriptions/'.$pw_sf_single_subscription_id,$access_token,'GET');


						if(!empty($get_customer_subscription_detail_req['res_data']['data']['attributes']['items'])){

							foreach($get_customer_subscription_detail_req['res_data']['data']['attributes']['items'] as $item_index => $pw_sf_singal_items){

							
								$pw_sf_plan_name=(!empty( $pw_sf_singal_items['plan_name'])) ? $pw_sf_singal_items['plan_name'] : '';
								$pw_sf_plan_id= (!empty( $pw_sf_singal_items['plan_id'])) ? $pw_sf_singal_items['plan_id'] : '';

								$plan_id_arr[$counter_index]['plan_id']=$pw_sf_plan_id;
								$plan_id_arr[$counter_index]['plan_name']=$pw_sf_plan_name;
								$plan_id_arr[$counter_index]['status']=$pw_sf_single_subscription_status;
								$plan_id_arr[$counter_index]['payment_status']=$pw_sf_single_subscription_payment_status;

								$counter_index++;

							}


						}


					}

				}

			


				if(!empty($get_customer_detail_req['res_data']['data']['attributes'])){

					$customer_detail=$get_customer_detail_req['res_data']['data']['attributes'];
					$userdata=array();

				
					if(empty($customer_detail['email']))
						return;


					/**
					 * 
					 * Get user by SF customer ID
					 * 
					*/

					$get_user_by_key_val=get_users(array(
						'meta_key' => 'wc_sf_customer_id',
						'meta_value' => $request['customer_id']
					));

				
					//$pw_sf_option_name = get_option('pw_sf_option_name');


					$pw_sf_option_name =$pw_sf_Helper_class_obj->pw_sf_get_pw_sf_option_name();
					
					//Check user exist
					$email=(!empty($customer_detail['email']) ? $customer_detail['email']  : '');
					$user_exists = email_exists($email);

	
					if(!empty($user_exists))
						$userdata['ID']= $user_exists;
					else
						$userdata['ID']= (!empty($get_user_by_key_val[0]->ID) ? $get_user_by_key_val[0]->ID : '');

					$user_pass=wp_generate_password( 8, false );


					if(!empty($customer_detail['name'])){
						$userdata['user_nicename']=sanitize_text_field($customer_detail['name']);
						$userdata['display_name']=sanitize_text_field($customer_detail['name']);
						$userdata['first_name']=sanitize_text_field($customer_detail['name']);
					}
					if(!empty($customer_detail['email'])){
						$userdata['user_login']=sanitize_email($customer_detail['email']);
						$userdata['user_email']=sanitize_email($customer_detail['email']);
					}
					
					if(!$user_exists && (empty($get_user_by_key_val[0]->ID))){
						$pw_sf_site_title = get_bloginfo('name');

						$userdata['user_pass']= $user_pass;
						
						$userlogins=(!empty($userdata['user_login'])) ? $userdata['user_login'] :'';
						$display_namess=(!empty($userdata['display_name'])) ? $userdata['display_name'] : '';
						$user_emailss=(!empty($userdata['user_email'])) ? $userdata['user_email'] : '';

						// Email subject and message
						$subject = sprintf(__('Welcome to %s', 'subscriptionflow-add-on-for-paywall'), $pw_sf_site_title);


						$pw_sf_email_text=get_option('pw_sf_email_text');
						$pw_sf_email_customer_login=$pw_sf_option_name['pw_sf_email_customer_login'];
						
						

						if(!empty($pw_sf_option_name['pw_sf_customer_email']) && !empty($customer_detail['email']) && !empty($pw_sf_email_customer_login)){

							$pw_sf_email_template=$pw_sf_option_name['pw_sf_customer_email'];
							$pw_sf_admin_email = get_option('admin_email');

							// Array of placeholders and their replacements
							$pw_sf_customer_email_placeholders = array('[display_name]', '[user_login]', '[user_pass]');
							$pw_sf_customer_email_placeholders_replacements = array($display_namess, $userlogins, $user_pass);

							// Replace placeholders with actual values
							$email_content = str_replace($pw_sf_customer_email_placeholders, $pw_sf_customer_email_placeholders_replacements, $pw_sf_email_template);


							//$headers = array('Content-Type: text/html; charset=UTF-8');
							$headers = array(
								"Content-Type: text/html; charset=UTF-8",
								'From: ' . get_bloginfo('name') . ' <' . $pw_sf_admin_email . '>'
							);
							// Send email
							$res=wp_mail($user_emailss, $subject, $email_content,$headers);

						}
						
						
					}
					
					
					if($request['user_role']==1)
						$userdata['role']= PW_SF_USER_1_ROLE;
					else if($request['user_role']==2)
						$userdata['role']= PW_SF_USER_2_ROLE;
					else if($request['user_role']==3)
						$userdata['role']= PW_SF_USER_3_ROLE;
					else if($request['user_role']==4)
						$userdata['role']= PW_SF_USER_4_ROLE;
					else
						$userdata['role']= (!empty(	$pw_sf_option_name['pw_sf_user_role']) ? $pw_sf_option_name['pw_sf_user_role'] : 'sf_customers' );


						
					$user_id = wp_insert_user( $userdata ) ;

					if ( is_wp_error( $user_id ) ) {

						$error_message =$user_id->get_error_message();

						$pw_sf_response_logs['status']=false;
						$pw_sf_response_logs['res_data']=$error_message;
						$pw_sf_response_logs['created_at']=date('Y-m-d H:i:s');
						
					}
					else{

						/**
						 * 
						 * Billing fields
						 * 
						*/

						if(!empty($customer_detail['name'])){
							update_user_meta($user_id,'billing_first_name',sanitize_text_field($customer_detail['name']));
						}
					
						if(!empty($customer_detail['billing_address_1'])){
							update_user_meta($user_id,'billing_address_1',sanitize_text_field($customer_detail['billing_address_1']));
						}
						
						if(!empty($customer_detail['billing_address_2'])){
							update_user_meta($user_id,'billing_address_2',sanitize_text_field($customer_detail['billing_address_2']));
						}
						if(!empty($customer_detail['billing_city'])){
							update_user_meta($user_id,'billing_city',sanitize_text_field($customer_detail['billing_city']));
						}
						
						if(!empty($customer_detail['billing_postal_code'])){
							update_user_meta($user_id,'billing_postcode',sanitize_text_field($customer_detail['billing_postal_code']));
						}

						if(!empty($customer_detail['billing_country'])){
							update_user_meta($user_id,'billing_country',sanitize_text_field($customer_detail['billing_country']));
						}

						if(!empty($customer_detail['billing_state'])){
							update_user_meta($user_id,'billing_state',sanitize_text_field($customer_detail['billing_state']));
						}
		
						if(!empty($customer_detail['email'])){
							update_user_meta($user_id,'billing_email',sanitize_email($customer_detail['email']));
						}

						if(!empty($customer_detail['phone_number'])){
							update_user_meta($user_id,'billing_phone',sanitize_text_field($customer_detail['phone_number']));
						}

						/**
						 * 
						 * Shipping fields
						 * 
						 * 
						*/

						if(!empty($customer_detail['name'])){
							update_user_meta($user_id,'shipping_first_name',sanitize_text_field($customer_detail['name']));
						}
						
						if(!empty($customer_detail['shipping_address_1'])){
							update_user_meta($user_id,'shipping_address_1',sanitize_text_field($customer_detail['shipping_address_1']));
						}
						
						if(!empty($customer_detail['shipping_address_2'])){
							update_user_meta($user_id,'shipping_address_2',sanitize_text_field($customer_detail['shipping_address_2']));
						}
						if(!empty($customer_detail['shipping_city'])){
							update_user_meta($user_id,'shipping_city',sanitize_text_field($customer_detail['shipping_city']));
						}
						
						if(!empty($customer_detail['shipping_postal_code'])){
							update_user_meta($user_id,'shipping_postcode',sanitize_text_field($customer_detail['shipping_postal_code']));
						}
						
						if(!empty($customer_detail['shipping_country'])){
							update_user_meta($user_id,'shipping_country',sanitize_text_field($customer_detail['shipping_country']));
						}
						
						if(!empty($customer_detail['shipping_state'])){
							update_user_meta($user_id,'shipping_state',sanitize_text_field($customer_detail['shipping_state']));
						}
						if(!empty($customer_detail['phone_number'])){
							update_user_meta($user_id,'shipping_phone',sanitize_text_field($customer_detail['phone_number']));
						}
						
						if(!empty($customer_detail['email'])){
							update_user_meta($user_id,'shipping_email',sanitize_email($customer_detail['email']));
						}
						

						if(!empty($customer_detail['id']))
							update_user_meta($user_id,'wc_sf_customer_id', sanitize_key($customer_detail['id']));

					
						update_user_meta($user_id, 'pw_sf_allow_content_access', (!empty($request['pw_sf_allow_content_access']) ? sanitize_text_field($request['pw_sf_allow_content_access']) : ''));

						update_user_meta($user_id, 'pw_sf_repeater_plan_list', (!empty($plan_id_arr) ? wp_json_encode($plan_id_arr) : ''));


						
						/**
						 * 
						 *  Update customer back to sf
						 *
						*/

						$sf_data_array=array();

						$sf_data_array['wp_user']='Yes';
						$sf_data_array['wp_temp_pass']=$user_pass;
						$sf_data_array['wp_password']=$user_pass;
						// $res=$pw_sf_Helper_class_obj->pw_sf_curl_post_domain_form_request($sf_data_array,PW_SF_DOMAIN_URL.'/api/v1/customers/'.$request['customer_id'], $access_token,'PUT');

						$pw_sf_response_logs['status']=true;
						$pw_sf_response_logs['res_data'] = sprintf(
							esc_html__('WP User has been updated ID: %d Email: %s', 'subscriptionflow-add-on-for-paywall'),
							$user_id,
							!empty($customer_detail['email']) ? esc_html($customer_detail['email']) : ''
						);
						
						$pw_sf_response_logs['created_at']=date('Y-m-d H:i:s');
			
					}
						


				
				}
				else{
				
					$pw_sf_response_logs['status']=false;
					$pw_sf_response_logs['res_data'] = (!empty($get_customer_detail_req['res_data']) ? esc_html($get_customer_detail_req['res_data']) : esc_html__('No record found!', 'subscriptionflow-add-on-for-paywall'));
					

					$pw_sf_response_logs['created_at']=date('Y-m-d H:i:s');
					
				}

			}
		

		}
		else{

			$pw_sf_response_logs['status']=false;
			$pw_sf_response_logs['res_data']=(!empty($token_response_msg->data) ? $token_response_msg->data : 'Something went wrong,please try after again!' );
			$pw_sf_response_logs['created_at']=date('Y-m-d H:i:s');
		}
								
		$pw_sf_Helper_class_obj->pw_sf_api_logs('-----------------pw_sf_creat_customer_webhook triger---------------');
		$pw_sf_Helper_class_obj->pw_sf_api_logs(json_encode($pw_sf_response_logs));
		$pw_sf_Helper_class_obj->pw_sf_api_logs('-----------------pw_sf_creat_customer_webhook triger end---------------');
		$pw_sf_Helper_class_obj->pw_sf_api_logs(' ');

		return wp_send_json($pw_sf_response_logs);


	
	}


   
}

