jQuery(document).ready(function($) {

    /**
     * 
     * Login Form code
     * 
     * 
    */
    $('#pw-sf-ajax-login-form').on('submit', function(e) {
        e.preventDefault();

        // Capture form data
        var pw_sf_username = $('#pw_sf_username').val();
        var pw_sf_password = $('#pw_sf_password').val();

        // Basic validation
        if(pw_sf_username === '' || pw_sf_password === '') {
            $('.pw-sf-status').text('Username and password are required').css('color', 'red');
            return;
        }

        var ajaxurl = ajax_login_object.ajaxurl;

        try {
            // AJAX request
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: ajaxurl,
                data: {
                    'action': 'ajaxlogin',
                    'pw_sf_username': pw_sf_username,
                    'pw_sf_password': pw_sf_password,
                    'security': $('#pw-sf-login-security').val()
                },
                success: function(response) {
                    // Handle response if success
                    if (response.loggedin == true) {
                        $('.pw-sf-status').html(response.message).css('color', 'green'); // Success message in green
                        document.location.href = ajax_login_object.redirecturl;
                    } else {
                        // Display error message from server response
                        $('.pw-sf-status').html(response.message || 'Invalid login credentials. Please try again.').css('color', 'red');
                    }
                },
                error: function(xhr, status, error) {
                    // Handle AJAX errors
                    $('.pw-sf-status').html('An error occurred during the login process. Please try again later.').css('color', 'red');
                    console.error('AJAX Error:', error);
                }
            });
        } catch (err) {
            // Catch any unexpected JavaScript errors
            $('.pw-sf-status').html('An unexpected error occurred. Please try again later.').css('color', 'red');
            console.error('Caught Exception:', err);
        }
    });

    /**
     * 
     * Update customer info
     * 
     * 
    */

    $('#sf-pw-customer-info-form').on('submit', function(e) {
        e.preventDefault();
    
        // Capture form data
        var formData = $(this).serialize();
        var ajaxurl = ajax_login_object.ajaxurl;
        var $response_element=$('.pw-sf-customer-info-update-response');
    

        // Show loader and disable form
        $response_element.html('<span class="loader">Processing......</span>').css('color', 'blue');
        
    
        try {
            // AJAX request
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: ajaxurl,
                data: formData + '&action=pw_sf_update_customer_password',
                success: function(response) {
                    // Handle response if success
                    if (response.success) {
                        $response_element.html(response.data.message).css('color', 'green');
                    } else {
                        $response_element.html(response.data.message || 'Update failed. Please try again.').css('color', 'red');
                    }
                },
                error: function(xhr, status, error) {
                    // Handle AJAX errors
                    $response_element.html('An error occurred. Please try again later.').css('color', 'red');
                    console.error('AJAX Error:', error);
                },
                complete: function() {
                    // Hide loader and enable form after response
                    $('.pw-sf-customer-info-update-response .loader').remove();
                
                }
            });
        } catch (err) {
            // Catch any unexpected JavaScript errors
            $response_element.html('An unexpected error occurred. Please try again later.').css('color', 'red');
            console.error('Caught Exception:', err);
            $('.pw-sf-customer-info-update-response .loader').remove();
         
        }
    });
    
});
