<?php
/**
 * Plugin Name: SubscriptionFlow Add-On for Paywall
 * Plugin URI: https://support.subscriptionflow.com/hc/en-us/articles/39430322553881-WordPress-Paywall-Plugin-Installation-Guide
 * Description: Use this addon to manage the SubscriptionFlow Paywall feature. It allows you to create customers and set content restrictions, including articles, categories/tags, custom post types, and multimedia.
 * Version: 1.0.8
 * Author: SubscriptionFlow Team
 * Author URI: https://www.subscriptionflow.com/
 * License: GPLv2 or later
 * Text Domain: subscriptionflow-add-on-for-paywall
 * Requires at least: 5.8
 * Requires PHP: 7.2
 *
 */

defined( 'ABSPATH' ) || exit;
define('WC_SF_API_V','v1');
define('PW_SF_DIRECTORY_PATH',plugin_dir_path( __FILE__ ));
// define('PW_SF_CLIENT_ID','53302ec2-e625-4a0a-a035-ca2734ec8e36');

// define('PW_SF_CLIENT_SECRET_ID','JxzTTuVcWzxAWpKdk16Ovhw6IbyRtx1FXYUbx7Ks');
// define('PW_SF_DOMAIN_URL','https://vrafy.subscriptionflow.com');

define('PW_SF_USER_1_ROLE','aamrole_55ba0a3aea516');
define('PW_SF_USER_2_ROLE','aamrole_55ba0a43efc74');
define('PW_SF_USER_3_ROLE','aamrole_570b60c7c3266');
define('PW_SF_USER_4_ROLE','aamrole_5722001b111f0');



// Include our integration class.
include_once 'class-pw-sf-helper.php';


/**
 * 
 * Admin script detail
 * 
*/
add_action('admin_enqueue_scripts', 'pw_sf_register_admin_script');

function pw_sf_register_admin_script($hook) {

    //make sure we are on the backend
    if (!is_admin()) return false;
    global $pagenow;

    // if(!empty($_GET['page'])){

    //     if($_GET['page']=='pw-sf-settings-page'){

            wp_enqueue_script('pw_sf_admin_js', plugins_url('admin/js/pw-sf-admin-script.js?v='.rand(1,100000),__FILE__ ),array( 'jquery' ),rand(1,100),true);
            wp_localize_script(
                'pw_sf_admin_js',
                'pw_sf_ajax_obj',
                array(
                    'ajax_url' => admin_url( 'admin-ajax.php' )
                )
            );

    //     }
    // }
        wp_enqueue_style( 'wc_sf_admin_css', plugins_url('admin/css/wc-sf-custom-style.css?v='.rand(1,100000), __FILE__), array(), '1.0.'.rand(1,1000), 'all');

    
    

}



function pw_sf_enqueue_custom_front_end_script() {

    /***
     * 
     * 
     * Check if the current post/page has the ajax login form shortcode
     * 
    */

    global $post;
    //if ( has_shortcode( $post->post_content, 'pw_sf_ajax_login_form' ) ) {


        // Use the singleton instance
        $pw_sf_helper_object = PW_sf_Helper::pw_sf_helper_object();
        $pw_sf_get_pw_sf_option_name = $pw_sf_helper_object->pw_sf_get_pw_sf_option_name();

        $pw_sf_domain_url=(!empty($pw_sf_get_pw_sf_option_name['pw_sf_domain_url']) ? $pw_sf_get_pw_sf_option_name['pw_sf_domain_url'] :  '');
        $pw_sf_client_id=(!empty($pw_sf_get_pw_sf_option_name['pw_sf_client_id']) ? $pw_sf_get_pw_sf_option_name['pw_sf_client_id'] :  '');

        // Enqueue the script
        wp_enqueue_script( 'pw-sf-custom-script', plugins_url('front-end/js/pw-sf-frontend-custom-script.js?v='.rand(1,100000),__FILE__ ) , array('jquery'), null, true );

        // Localize the script with dynamic data
        wp_localize_script( 'pw-sf-custom-script', 'ajax_login_object', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'redirecturl' => (!empty($pw_sf_get_pw_sf_option_name['pw_sf_login_form_redirect_url']) ? $pw_sf_get_pw_sf_option_name['pw_sf_login_form_redirect_url'] :  home_url()),
        ));



  
            
    //}
        
    
}

add_action( 'wp_enqueue_scripts', 'pw_sf_enqueue_custom_front_end_script' );



/**
 * 
 * Admin
 * 
*/
include_once 'admin/class-pw-sf-setting.php';
include_once 'admin/pw-sf-customer-metafields.php';
include_once 'admin/class-pw-sf-metabox.php';
include_once 'admin/pw-sf-ajax-request.php';




/**
 * 
 * Front end side
 * 
*/

include_once 'front-end/pw-sf-customer-route.php';
include_once 'front-end/pw-sf-content-restrict.php';
include_once 'front-end/pw-sf-shortcode.php';
include_once 'front-end/pw-sf-fontend-ajax-request.php';













