<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
if ( ! class_exists( 'PW_sf_Helper' ) ) :

    class PW_sf_Helper{


        private static $obj;
        public $domain_URL,$client_id,$client_secret,$pw_sf_option_name;

        private function __construct() {

            $this->pw_sf_option_name = get_option('pw_sf_option_name');
            define('PW_SF_DOMAIN_URL', $this->pw_sf_option_name['pw_sf_domain_url']);
            
        }


        public static function pw_sf_helper_object() {

            if (!isset(self::$obj)) {
                self::$obj = new PW_sf_Helper();
            }
             
            return self::$obj;
        }

        /**
         * 
         * @@ function to generate access_token
         * 
        **/

        public function pw_sf_generate_token_function()
        {

          
            $pw_sf_client_id = (!empty($this->pw_sf_option_name['pw_sf_client_id'])) ? $this->pw_sf_option_name['pw_sf_client_id'] : '';
            $pw_sf_client_secret = (!empty($this->pw_sf_option_name['pw_sf_client_secret'])) ? $this->pw_sf_option_name['pw_sf_client_secret'] : '';

   
         
            $message=array();

            try {
                
                $pw_sf_token_response = wp_remote_post( PW_SF_DOMAIN_URL.'/oauth/token', array(
                    'method'      => 'POST',
                    'timeout'     => 120,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking'    => true,
                    'headers'     => array(),
                    'body'        => array(
                        'client_id' =>  $pw_sf_client_id,
                        'client_secret' =>$pw_sf_client_secret,
                        'grant_type' => 'client_credentials'
                    ),
                    'cookies'     => array()
                    )
                );
                

                if ( is_wp_error( $pw_sf_token_response ) ) {

                    $error_message = $pw_sf_token_response->get_error_message();

                    $message['status']=false;
                    $message['data']=$error_message;
                    $message['created_at']=date('Y-m-d H:i:s');

                

                } else {

                    $pw_sf_token_response_arr = json_decode(wp_remote_retrieve_body($pw_sf_token_response), true);

                    if(!empty($pw_sf_token_response_arr['access_token'])){
                        $message['status']=true;
                        $message['data']=$pw_sf_token_response_arr;
                        $message['created_at']=date('Y-m-d H:i:s');

                    }
                    else{

                        $message['status']=false;
                        $message['data']=(!empty($pw_sf_token_response_arr['message'])) ? $pw_sf_token_response_arr['message'] : 'Looks like you made a mistake!';
                        $message['created_at']=date('Y-m-d H:i:s');

                    }
         
                   
                    
                    
                }
                
            } 
            catch (Exception $e) {
                
                $message['status']=false;
                $message['data']=$e->getMessage();
                $message['created_at']=date('Y-m-d H:i:s');
            }
            


            //Store log incase api fail...
            if(!$message['status']){

                self::pw_sf_api_logs('-----------------Authentication error---------------');
                //self::pw_sf_api_logs(json_encode( $message));
                self::pw_sf_api_logs('-----------------Authentication error end---------------');
                self::pw_sf_api_logs(' ');
            }
   

          
            return $message;
        
        }

        /**
         * 
         * @@ Store token into file and regenrate after token expiry
         * 
         * 
        */
        public function pw_sf_api_get_token(){
            
            $pw_sf_auth_access_token=get_option('pw_sf_auth_access_token');
      
     
            $json_arr=array();
      
            if (!empty($pw_sf_auth_access_token)) {
                $data_arr=json_decode($pw_sf_auth_access_token);
                $mindiff = round((strtotime(date('Y-m-d H:i:s')) - strtotime($data_arr->created_at))/60);

                if($mindiff > 45 || !$data_arr->status){

                    $response_msg=self::pw_sf_generate_token_function();
                    update_option('pw_sf_auth_access_token',json_encode($response_msg));

                    
                }
                    
            }
            else{

                $response_msg=self::pw_sf_generate_token_function();	
                update_option('pw_sf_auth_access_token',json_encode($response_msg));	
            }

            $data_arr=get_option('pw_sf_auth_access_token');

            if(!empty($data_arr))
                $data_arr=json_decode( $data_arr);

            return $data_arr;
            
        }


        /**
         * 
         * Call SF get request
         * 
         * @param $url,$access_token,$method
         * 
        */
        public function pw_sf_curl_get_sf_request($url=null, $access_token = null,$method='POST'){

            
            $pw_sf_response_data=array();

            try {
                $pw_sf_data_response = wp_remote_get( $url, array(
                    'headers' => array(
                        'Authorization' => 'Bearer '.$access_token,
                    ),
                    'timeout' => 120
                ) );

                if ( is_wp_error( $pw_sf_data_response ) ) {

                    $error_message = $pw_sf_data_response->get_error_message();
                    $pw_sf_response_data['status']=false;
                    $pw_sf_response_data['url']=$url;
                    $pw_sf_response_data['res_data']=$error_message;
                    $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                

                } else {

                    $pw_sf_data_response_arr = json_decode(wp_remote_retrieve_body($pw_sf_data_response), true);

                    if (200 === wp_remote_retrieve_response_code( $pw_sf_data_response ) ) {


                        $pw_sf_response_data['status']=true;
                        $pw_sf_response_data['url']=$url;
                        $pw_sf_response_data['res_data']=$pw_sf_data_response_arr;
                        $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');
                     
                    }
                    else{

                        $pw_sf_response_data['status']=false;
                        $pw_sf_response_data['url']=$url;
                        $pw_sf_response_data['res_data']=(!empty($pw_sf_data_response_arr['message']) ? $pw_sf_data_response_arr['message'] : 'Looks like you made a mistake' );
                        $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');


                    }
                   

                }

              
               
            }
            catch( Exception $ex ) {

                $pw_sf_response_data['status']=false;
                $pw_sf_response_data['url']=$url;
                $pw_sf_response_data['res_data']='Looks like you made a mistake, '.$ex->getMessage();
                $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');
            
            }
            

            //Store log incase api fail...
            if(!$pw_sf_response_data['status']){

                self::pw_sf_api_logs('-----------------Get request api error---------------');
                //self::pw_sf_api_logs(json_encode( $pw_sf_response_data));
                self::pw_sf_api_logs('-----------------Get request api error end---------------');
                self::pw_sf_api_logs(' ');
            }
   


            return $pw_sf_response_data;
        }


        /**
         * 
         * @Function to post data in SF
         * 
         * 
        */
        
        public function pw_sf_curl_post_domain_form_request($all_data=array(),$url=null, $access_token = null,$method='POST')
        {

			$fields_string = '';
            foreach($all_data as $key=>$value) { 
                $fields_string .= $key.'='.$value.'&'; 
            }
            rtrim($fields_string, '&');
			
            $pw_sf_response_data=array();

            try {
                
                $pw_sf_token_response = wp_remote_post($url, array(
                    'method'      => $method,
                    'timeout'     => 120,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking'    => true,
                    'headers'     => array(
						  'Authorization' => 'Bearer ' . $access_token
					),
                    'body'        => 	$all_data,
                    'cookies'     => array()
                    )
                );
                

    
     
                if ( is_wp_error( $pw_sf_token_response ) ) {

                    $error_message = $pw_sf_token_response->get_error_message();

                    $pw_sf_response_data['status']=false;
                    $pw_sf_response_data['res_data']=$error_message;
                    $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                

                } else {

                    $pw_sf_response_arr = json_decode(wp_remote_retrieve_body($pw_sf_token_response), true);

                    if(!empty($pw_sf_response_arr['data']['id'])){
                        $pw_sf_response_data['status']=true;
                        $pw_sf_response_data['res_data']=$pw_sf_response_arr;
                        $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                    }
                    else{

                        $pw_sf_response_data['status']=false;
                        $pw_sf_response_data['res_data']=(!empty($pw_sf_response_arr)) ? $pw_sf_response_arr: 'Looks like you made a mistake!';
                        $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                    }
         
                   
                    
                    
                }
                
            } 
            catch (Exception $e) {
                
                $pw_sf_response_data['status']=false;
                $pw_sf_response_data['res_data']=$e->getMessage();
                $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');
            }
            


            //Store log incase api fail...
            if(!$pw_sf_response_data['status']){

                self::pw_sf_api_logs('-----------------Post request api error---------------');
                //self::pw_sf_api_logs(json_encode( $pw_sf_response_data));
                self::pw_sf_api_logs('-----------------Post request api error end---------------');
                self::pw_sf_api_logs(' ');
            }
          
            return $pw_sf_response_data;
        
        }

        /**
         * 
         * @Function to post Filter request data in SF
         * 
         * 
        */

        public function pw_sf_curl_filter_post_domain_form_request($all_data=array(),$url=null, $access_token = null,$method='POST')
        {

			$fields_string = '';
            foreach($all_data as $key=>$value) { 
                $fields_string .= $key.'='.$value.'&'; 
            }
            rtrim($fields_string, '&');
			
            $pw_sf_response_data=array();

            try {
                
                $pw_sf_token_response = wp_remote_post($url, array(
                    'method'      => $method,
                    'timeout'     => 120,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking'    => true,
                    'headers'     => array(
						  'Authorization' => 'Bearer ' . $access_token
					),
                    'body'        => 	$all_data,
                    'cookies'     => array()
                    )
                );
                

    
     
                if ( is_wp_error( $pw_sf_token_response ) ) {

                    $error_message = $pw_sf_token_response->get_error_message();

                    $pw_sf_response_data['status']=false;
                    $pw_sf_response_data['res_data']=$error_message;
                    $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                

                } else {

                    $pw_sf_response_arr = json_decode(wp_remote_retrieve_body($pw_sf_token_response), true);

                    if(!empty($pw_sf_response_arr['data'][0]['id'])){
                        $pw_sf_response_data['status']=true;
                        $pw_sf_response_data['res_data']=$pw_sf_response_arr;
                        $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                    }
                    else{

                        $pw_sf_response_data['status']=false;
            
                        $pw_sf_response_data['res_data']=(!empty($pw_sf_response_arr)) ? $pw_sf_response_arr: 'Looks like you made a mistake!';
                        $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');

                    }
         
                   
                    
                    
                }
                
            } 
            catch (Exception $e) {
                
                $pw_sf_response_data['status']=false;
            
                $pw_sf_response_data['res_data']=$e->getMessage();
                $pw_sf_response_data['created_at']=date('Y-m-d H:i:s');
            }
            


            //Store log incase api fail...
            if(!$pw_sf_response_data['status']){

                self::pw_sf_api_logs('-----------------Post request api error---------------');
                //self::pw_sf_api_logs(json_encode( $pw_sf_response_data));
                self::pw_sf_api_logs('-----------------Post request api error end---------------');
                self::pw_sf_api_logs(' ');
            }
          
            return $pw_sf_response_data;
        
        }

        /**
         * 
         *  @Strore API response to array
         * 
         * 
        */


        public function pw_sf_api_logs($response_msg) {
            if (empty($response_msg)) {
                return null;
            }
        
            // Get the uploads directory path for logs
            $upload_dir = wp_upload_dir();
            $log_dir = $upload_dir['basedir'] . '/pw-sf-integration-logs/';
        
            // Ensure the logs directory exists
            if (!file_exists($log_dir)) {
                wp_mkdir_p($log_dir); // Create the directory if it doesn't exist
            }
        
            // Set directory permissions securely
            @chmod($log_dir, 0755);
        
            // Create a file name with the current date
            $current_date = date('Y-m-d');
            $log_file = $log_dir . "api_logs_{$current_date}.txt";
        
            // Append the log message to the file
            file_put_contents($log_file, $response_msg . PHP_EOL, FILE_APPEND | LOCK_EX);
        
            // Set file permissions securely
            @chmod($log_file, 0644);
        
            // Remove log files older than 7 days
            self::pw_sf_delete_old_logs($log_dir);
        }
        
        private function pw_sf_delete_old_logs($log_dir) {
            $files = glob($log_dir . '*.txt'); // Get all log files
            $seven_days_ago = time() - (7 * 24 * 60 * 60); // Timestamp for 7 days ago
        
            foreach ($files as $file) {
                if (filemtime($file) < $seven_days_ago) {
                    unlink($file); // Delete files older than 7 days
                }
            }
        }

        
        
         /**
         * A custom sanitization function that will take the incoming input, and sanitize
         * the input before handing it back to WordPress to save to the database.
         *
         * @since    1.0.0
         *
         * @param    array    $input        The address input.
         * @return   array    $new_input    The sanitized input.
         */
        public function pw_sf_meta_box_sanitize( $input=array(),$key_type='' ) {

            $new_input = array();

            if(!empty($input)){
                
                // Loop through the input and sanitize each of the values
                foreach ( $input as $key => $val ) {

                    if(!empty($val)){

                        switch ( $key_type ) {

                            case 'pw_sf_hpp_button_text':
        
                                $new_input[ $key ] = sanitize_text_field( $val );
                                break;
        
                            case 'pw_sf_hpp_product_id':
        
                                $new_input[ $key ] = sanitize_key( $val );
                                break;
        
                            case 'pw_sf_hpp_plan_id_name':
        
                                $new_input[ $key ] = sanitize_text_field( $val );
                                break;
        
        
                        }
                    }


                }
            }


	        return $new_input;
        }



        /***
         * 
         * Repeater field use on front-end/pw-sf-content-restrict.php
         * 
         * Tags/Categories/Posts
         * 
        */
        public function pw_sf_repeater_field_data_arr($post_id=null, $type_data=null){

            if (empty($post_id) && empty($type_data)) return;

            $plan_id_arr=array();
            //Repeater fields


            if($type_data=='post')
                $pw_sf_meta_repeatable_fields = get_post_meta($post_id, 'pw_sf_meta_repeatable_fields', true);
            else
                $pw_sf_meta_repeatable_fields = get_term_meta($post_id, 'pw_sf_meta_repeatable_fields', true);

            if(!empty( $pw_sf_meta_repeatable_fields)){

                foreach( $pw_sf_meta_repeatable_fields as  $single_pw_sf_meta_repeatable_fields){

                    $pw_sf_plan_id= substr($single_pw_sf_meta_repeatable_fields['pw_sf_hpp_plan_id_name'],0, strpos($single_pw_sf_meta_repeatable_fields['pw_sf_hpp_plan_id_name'], "|"));

                    $pw_sf_plan_name= substr($single_pw_sf_meta_repeatable_fields['pw_sf_hpp_plan_id_name'], strpos($single_pw_sf_meta_repeatable_fields['pw_sf_hpp_plan_id_name'], "|")+1);

                    $plan_id_arr[$pw_sf_plan_name]=$pw_sf_plan_id;


                }

            }

            return $plan_id_arr;

        }


        /**
         * 
         * Get admin option value
         * 
         * 
        */
        public function pw_sf_get_pw_sf_option_name() {

            return  $this->pw_sf_option_name;
        }


        public function get_subdomain_from_url($url) {

            if(!empty($url)){
                // Parse the URL to get the host
                $parsed_url = parse_url($url);
                
                if (isset($parsed_url['host'])) {
                    // Split the host into parts
                    $host_parts = explode('.', $parsed_url['host']);
                    
                    // Check if there are at least three parts (subdomain.domain.tld)
                    if (count($host_parts) > 2) {
                        // Return the first part (subdomain)
                        return $host_parts[0];
                    }
                }
            }
            
            // Return empty if no subdomain is found
            return '';
        }

        /**
         * 
         * ByPass Paywall users role
         * 
        */
        public function pw_sf_should_bypass_paywall($pw_sf_user = null) {            

            
            // Get the option name (configuration values)
            $pw_sf_option_name = self::pw_sf_get_pw_sf_option_name();
            
            // Check if the 'bypass restrictions' option is not empty
            if (!empty($pw_sf_option_name['pw_sf_bypass_restrictions'])) {
                // Retrieve the roles that can bypass the paywall
                $pw_sf_by_pass_user_role = array_map('trim', explode(',', $pw_sf_option_name['pw_sf_bypass_restrictions']));
                
                // Find any matching roles between user roles and the bypass roles
                $matching_roles = array_intersect($pw_sf_user->roles, $pw_sf_by_pass_user_role);
                
                // If any matching roles are found, return true to bypass the paywall
                if (!empty($matching_roles)) {
                    return true;
                }
            }
            
            // Return false by default (no bypass)
            return false;
        }
        
    }

endif;