<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * 
 * Custom Role For SF
 * 
 */

function PW_SF_register_custom_role()
{
    add_role(
        'sf_customers',         // Role slug
        'SF Customers',         // Role display name
        array(
            'read'         => false,  // Allow the role to read posts and pages
            'edit_posts'   => false, // Don't allow the role to edit posts
            'delete_posts' => false, // Don't allow the role to delete posts
        )
    );
}
add_action('init', 'PW_SF_register_custom_role');


/**
 * 
 * 
 *  Display custom user meta field in user profile
 * 
 */

add_action('show_user_profile', 'PW_SF_user_profile_fields');
add_action('edit_user_profile', 'PW_SF_user_profile_fields');

function PW_SF_user_profile_fields($user)
{
?>
    <h3><?php esc_html_e("SubscriptionFlow Data", "subscriptionflow-add-on-for-paywall"); ?></h3>
    <table class="form-table">
        <tr>
            <?php $pw_sf_allow_content_access = get_user_meta($user->ID, 'pw_sf_allow_content_access', true); ?>
            <th><label for="pw_sf_allow_content_access"><?php esc_html_e("Allow Access", "subscriptionflow-add-on-for-paywall"); ?></label></th>
            <td>
                <select name="pw_sf_allow_content_access" id="allow_content_access">
                    <option value=""><?php esc_html_e("Please select access level", "subscriptionflow-add-on-for-paywall"); ?>
                    </option>
                    <option value="allow" <?php selected($pw_sf_allow_content_access, 'allow'); ?>><?php echo esc_html(__('Allow', 'subscriptionflow-add-on-for-paywall')); ?></option>
                    <option value="block" <?php selected($pw_sf_allow_content_access, 'block'); ?>><?php echo esc_html(__('Block', 'subscriptionflow-add-on-for-paywall')); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php esc_html_e("Customer ID", "subscriptionflow-add-on-for-paywall"); ?></label></th>
            <td>
                <input type="text" name="wc_sf_customer_id" id="wc_sf_customer_id" value="<?php echo esc_attr(get_user_meta($user->ID, 'wc_sf_customer_id', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing Address Line 1', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_address_1" id="billing_address_1" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_address_1', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing Address Line 2', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_address_2" id="billing_address_2" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_address_2', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing Address Line 3', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_address_3" id="billing_address_3" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_address_3', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing City', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_city" id="billing_city" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_city', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing State', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_state" id="billing_state" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_state', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing Postal Code', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_postal_code" id="billing_postal_code" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_postcode', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Billing Country', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="billing_country" id="billing_country" value="<?php echo esc_attr(get_user_meta($user->ID, 'billing_country', true)); ?>" class="regular-text">

            </td>
        </tr>

        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping Address Line 1', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_address_1" id="shipping_address_1" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_address_1', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping Address Line 2', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_address_2" id="shipping_address_2" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_address_2', true)); ?>" class="regular-text">

            </td>
        </tr>
        
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping Address Line 3', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_address_3" id="shipping_address_3" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_address_3', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping City', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_city" id="shipping_city" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_city', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping State', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_state" id="shipping_state" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_state', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping Postal Code', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_postal_code" id="shipping_postal_code" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_postcode', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>
            <th><label for="custom_field"><?php echo esc_html(__('Shipping Country', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <input type="text" name="shipping_country" id="billing_country" value="<?php echo esc_attr(get_user_meta($user->ID, 'shipping_country', true)); ?>" class="regular-text">

            </td>
        </tr>
        <tr>

            <th><label for="custom_field"><?php echo esc_html(__('Subscription Detail', 'subscriptionflow-add-on-for-paywall')); ?></label></th>
            <td>
                <textarea class="regular-text">
                    <?php
                    $pw_sf_user_repeater_plan_list = get_user_meta($user->ID, 'pw_sf_repeater_plan_list', true);

                    if (!empty($pw_sf_user_repeater_plan_list)) {


                        echo esc_html($pw_sf_user_repeater_plan_list);
                    }
                    ?>
                </textarea>


            </td>
        </tr>
    </table>
    <?php wp_nonce_field('pw_sf_user_profile_update', 'pw_sf_nonce'); ?>
<?php
}


/**
 * Update custom user meta fields with nonce verification
 */
add_action('personal_options_update', 'PW_SF_save_user_profile_fields');
add_action('edit_user_profile_update', 'PW_SF_save_user_profile_fields');

function PW_SF_save_user_profile_fields($user_id)
{
    // Verify nonce
    if (!isset($_POST['pw_sf_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['pw_sf_nonce'])), 'pw_sf_user_profile_update')) {
        return;
    }
    // Don't save if the current user cannot edit user profiles
    if (! current_user_can('edit_user', $user_id)) {
        return;
    }

    // Update meta fields
    update_user_meta($user_id, 'pw_sf_allow_content_access', sanitize_text_field($_POST['pw_sf_allow_content_access']));
}
