<?php

defined( 'ABSPATH' ) || exit;

/**
 * 
 * Send plans in reponse against selected product
 * 
*/
add_action("wp_ajax_pw_sf_get_product_plan", "pw_sf_get_product_plan");
//add_action("wp_ajax_nopriv_wc_sf_get_product_plan", "WC_SF_get_product_plan");

function pw_sf_get_product_plan() {



      $pw_sf_product_id=esc_html(sanitize_key($_REQUEST['pw_sf_product_id']));
      $pw_sf_helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
      
      $pw_sf_get_access_token_obj=$pw_sf_helper_class_obj->pw_sf_api_get_token();
      $wc_sf_get_access_token=(!empty($pw_sf_get_access_token_obj->data->access_token)) ?$pw_sf_get_access_token_obj->data->access_token : '';

		$url=PW_SF_DOMAIN_URL.'/api/'.WC_SF_API_V.'/products/'.$pw_sf_product_id.'/link/plans';

		$pw_sf_product_list=$pw_sf_helper_class_obj->pw_sf_curl_get_sf_request($url, $wc_sf_get_access_token);
      
      $html='';
            if(!empty($pw_sf_product_list['res_data']['data'])):

               //$html.='<select class="widefat" name="wc_sf_hpp_plan_id_name[]">';
                
                  $html .= '<option value="">' . esc_attr( __( 'Select plan', 'subscriptionflow-add-on-for-paywall' ) ) . '</option>';

                  foreach($pw_sf_product_list['res_data']['data']  as $wc_sf_single_product): 

                     $wc_sf_single_product_val='';
                     if(!empty($wc_sf_single_product['id']) && !empty($wc_sf_single_product['name']))
                        $wc_sf_single_product_val=$wc_sf_single_product['id'] .'|'.$wc_sf_single_product['name'];
 
                     $html .= sprintf(
                        '<option value="%s">%s</option>',
                        esc_attr($wc_sf_single_product_val),
                        esc_attr(!empty($wc_sf_single_product['name']) ? $wc_sf_single_product['name'] : '')
                    );
                    
                  endforeach;
            else:
               $html .= sprintf(
                  '<option value="">%s</option>',
                  esc_html__("Sorry, No plan found!", 'subscriptionflow-add-on-for-paywall')
              );
              
               //$html.='</select>';
           
            endif;
      
      echo wp_send_json(array('res_data' => $html,'status'=>true));
 

   die();

}

/**
 * 
 * Send plans in reponse against selected product
 * 
*/
 add_action("wp_ajax_pw_sf_sync_product", "pw_sf_sync_product");


function pw_sf_sync_product() {


      $html='';

      $pw_sf_helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
	
      $pw_sf_get_access_token_obj=$pw_sf_helper_class_obj->pw_sf_api_get_token();
      $wc_sf_get_access_token=(!empty($pw_sf_get_access_token_obj->data->access_token)) ? $pw_sf_get_access_token_obj->data->access_token : '';

      $url=PW_SF_DOMAIN_URL.'/api/'.WC_SF_API_V.'/products';

      $wc_sf_product_list=$pw_sf_helper_class_obj->pw_sf_curl_get_sf_request($url, $wc_sf_get_access_token);


      if(!empty($wc_sf_product_list['res_data']['data'])){

         $pw_sf_plan_data=array();
         $pw_sf_plan_data['data'][]=$wc_sf_product_list['res_data']['data'];
         $pw_sf_plan_data['date']=date('Y-m-d H:i:s');
         
         update_option('pw_sf_product_data',json_encode($pw_sf_plan_data));

         $html = sprintf(
            '<span class="notice notice-success is-dismissible wc-sf-msg">%s</span>',
            esc_html__("Your data has been successfully updated", 'subscriptionflow-add-on-for-paywall')
        );
        
      }
      else{

   
         $html = sprintf(
            '<span class="notice notice-error is-dismissible wc-sf-msg">%s</span>',
            esc_html__("Something went wrong. Please try after sometime", 'subscriptionflow-add-on-for-paywall')
        );
      }

    
      echo wp_send_json(array('res_data' => $html,'status'=>true));
   

      die();

}

add_action('wp_ajax_pw_sf_sync_import_customers', 'pw_sf_sync_import_customers_callback'); // For logged-in users


function pw_sf_sync_import_customers_callback() {


   $pw_sf_response_logs = array();


   // Initialize helper class object
   $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();
   $token_response_msg = $pw_sf_Helper_class_obj->pw_sf_api_get_token();

   // Check if token retrieval was successful
   if (empty($token_response_msg->status)) {

      $pw_sf_response_logs['status'] = 'complete';
      $pw_sf_response_logs['message'] = sprintf(
         '<span class="notice notice-error is-dismissible wc-sf-msg" style="font-size: 14px;">%s</span>',
         esc_html__('Failed to retrieve token: ', 'subscriptionflow-add-on-for-paywall') . 
         (isset($token_response_msg->data) ? esc_html($token_response_msg->data) : esc_html__('Unknown error.', 'subscriptionflow-add-on-for-paywall'))
     );
     

      wp_send_json($pw_sf_response_logs);
   }

   if (empty($token_response_msg->data->access_token)) {

      $pw_sf_response_logs['status'] = 'complete';
      $pw_sf_response_logs['message'] = sprintf(
         '<span class="notice notice-error is-dismissible wc-sf-msg" style="font-size: 14px;">%s</span>',
         esc_html__('Access token not available in the response.', 'subscriptionflow-add-on-for-paywall')
     );
     
      wp_send_json($pw_sf_response_logs);

   }

   // Access token obtained
   $access_token = $token_response_msg->data->access_token;

   // Get the counter value from the request
   $counter = isset($_POST['counter']) ? intval($_POST['counter']) : 0;

   // Prepare data for customer API call
   $sf_data_array = array(
      'filter[$limit]' => 1,
      'filter[$offset]' => $counter
   );

   // Request customer data
   $customer_res = $pw_sf_Helper_class_obj->pw_sf_curl_filter_post_domain_form_request($sf_data_array, PW_SF_DOMAIN_URL . '/api/v1/customers/filter', $access_token, 'POST');

   // Check for customer data in response
   if (empty($customer_res['res_data']['data'][0]['id'])) {
      

      $pw_sf_response_logs['status'] = 'complete';
      $pw_sf_response_logs['message'] = sprintf(
         '<span class="notice notice-success is-dismissible wc-sf-msg" style="font-size: 14px;">%s</span>',
         esc_html__('Import finished successfully. No more customer data available.', 'subscriptionflow-add-on-for-paywall')
     );
     
      wp_send_json($pw_sf_response_logs);
   }


    // Customer ID found
    $customer_id = $customer_res['res_data']['data'][0]['id'];

 
    // Set the URL for WordPress API
    $url = home_url() . "/wp-json/api/sf-pw-create-update-user?customer_id=" . $customer_id . "&pw_sf_allow_content_access=allow";
 
    // Define request arguments with timeout
    $args = array(
        'timeout' => 120, // Timeout in seconds
    );
 
   // Make the GET request with timeout
   $response = wp_remote_get($url, $args);

    // Retrieve and process response data
    $body = wp_remote_retrieve_body($response);
    $decoded_body = json_decode($body, true);

    // Log the progress


   $pw_sf_response_logs = array(
      'status' => 'in_progress',
      'message' => sprintf(
         esc_html__('Request #%d processed successfully.', 'subscriptionflow-add-on-for-paywall'),
         $counter
      ),
      'response_data' => $decoded_body,
      'created_at' => date('Y-m-d H:i:s')
   );

  // Send final response back
  wp_send_json($pw_sf_response_logs);
   
    

   
}
