
jQuery(document).ready(function( $ ){



   /**
     * 
     * Repeater fields on product edit page
     * 
     * 
    */
       $( '#pw-sf-add-row' ).on('click', function() {
        
         var row = $( '.pw-sf-empty-row.screen-reader-text' ).clone(true);
         row.removeClass( 'pw-sf-empty-row screen-reader-text' );
         row.insertBefore( '#pw-sf-repeatable-fieldset-one tbody>tr:last' );
         return false;
     });
 
     $( '.pw-sf-remove-row' ).on('click', function() {
         $(this).parents('tr').remove();
         return false;
     });


     /**
       * 
       * Repeater fields on product edit page
       * 
       * On change plan dropdown 
       * 
       * Send ajax request admin\wc-sf-ajax-request.php
       * 
      */

     $(document).on('change','.pw-sf-product-list-dropdown', function(e) {
      e.preventDefault(); 
      let $this=$(this)

      if ($this.attr('name') !== 'pw_sf_hpp_product_id[]') {
         return; // Exit the function if the name is not 'pw_sf_hpp_product_id[]'
      }
      let pw_sf_product_id =$this.val();

      $.ajax({

         beforeSend: function() {

            $this.parent().siblings('.product-plan').append('<span class="spinner is-active" style="float: left;"></span>');
        },
         type : "post",
         dataType : "json",
         url : pw_sf_ajax_obj.ajax_url,
         data : {action: "pw_sf_get_product_plan", pw_sf_product_id : pw_sf_product_id},
         success: function(response) {

            $this.parent().next('.product-plan').children('.spinner').remove();

            if(response.status) {

               $this.parent().next('.product-plan').children('.pw-sf-product-list-dropdown').html(response.res_data);

            }
            else {

               alert("Something went wrong,Please refresh the page and try again!");

            }
         },
         error: function(xhr) {
            $this.parent().next('.product-plan').children('.spinner').remove();
         

         }
      })   

   });
  


      /**
       * 
       * Showing  SubscriptionFlow Setting Tabs
       * 
       * On Click sync Products/Plans 
       * 
       * Send ajax request admin\wc-sf-ajax-request.php
       * 
      */

      jQuery(document).on('click','.pw-sf-button', function(e) {
         e.preventDefault(); 
         let $this=$(this)
         let pw_sf_product_id =$this.val();
   
         $.ajax({

            beforeSend: function() {

               
               $this.parent().remove('.pw-sf-msg');
               $this.parent().append('<span class="spinner is-active" style="position: absolute;"></span>');
           },
            type : "post",
            dataType : "json",
            url : pw_sf_ajax_obj.ajax_url,
            data : {action:  $this.attr('data-action')},
            success: function(response) {

               $this.parent().children('.spinner').remove();

               $this.parent().append(response.res_data);

               
            },
            error: function(xhr) {
               $this.parent().children('.spinner').remove();
            

            }
         })   
   
      });
     

      let requestCounter = 1; // Initialize the counter
    
      $('.pw-sf-import-customer-button').on('click', function(ee) {
         ee.preventDefault(); 
         let $this=$(this)
         $this.prop('disabled', true); // Disable the button to prevent additional clicks

         //$this.parent().append('<span class="spinner is-active" style="position: absolute;"></span>');

         $('#sf-pw-import-customer-popup .wc-sf-msg').remove();
         $('#sf-pw-import-customer-popup .spinner').addClass('is-active');
         $('#sf-pw-import-customer-popup').fadeIn(); // Show the popup

         async function sendRequest() {
            try {
                const response = await $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'pw_sf_sync_import_customers',
                        counter: requestCounter
                    }
                });
                
               if(response.response_data)
                  $('.sf-pw-import-msg').html('<code>'+response.response_data.res_data+'</code>');

        
               if (response.status === 'complete') {
                  //console.log('Final response received, stopping requests.');
                  $this.prop('disabled', false); // Re-enable the button
                  //$this.parent().children('.spinner').remove();
                  $('#sf-pw-import-customer-popup .spinner').removeClass('is-active');
                  if(response.message)
                     $('.sf-pw-import-msg').html(response.message);

               } else {

                 
                  
                  requestCounter++;
                  setTimeout(sendRequest, 1000); // Retry after a short delay
               }
                
            } catch (error) {


               //  console.error(`Request ${requestCounter} failed:`, error);
                $('#sf-pw-import-customer-popup .spinner').removeClass('is-active');
                $this.prop('disabled', false); // Re-enable the button on error
            }
        }
        
         
         sendRequest(); // Call the async function for the first request
      });


      // Close the popup when clicking the close button
      $('.close-btn').on('click', function() {
         var obj=$(this).attr('data-id');
         $('#'+obj).fadeOut();

         // Check if the obj is 'sf-pw-import-customer-popup' and reload the page if true
         if (obj === 'sf-pw-import-customer-popup') {
            location.reload();  // Reload the current page
         }
      });

});


