<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
if (!class_exists('PW_SF_Settings_Page')) {
    class PW_SF_Settings_Page {
        private $options;
        private $pw_sf_form_response;
        private $roles;
        private $sections;
        private $fields;
        private $pw_sf_site_title;

        public function __construct() {
            // Initialize roles and sections in the constructor
            $this->roles = $this->get_wp_roles();
            $this->pw_sf_site_title = get_bloginfo('name');

            $admin_email = get_option('admin_email');

     
            $this->sections = array(
                'section1' => array(
                    'id' => 'pw_sf_setting_section_id_1',
                    'title' => __('SubscriptionFlow API', 'subscriptionflow-add-on-for-paywall'),
                    'callback' => 'pw_sf_print_section_info_1'
                )
            );
            

            $this->fields = array(
                'section1' => array(
                    array(
                        'id' => 'pw_sf_client_id',
                        'title' => __('Client ID', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your Client ID here', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text'
                    ),
                    array(
                        'id' => 'pw_sf_client_secret',
                        'title' => __('Client Secret', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your Client Secret here', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text'
                    ),
                    array(
                        'id' => 'pw_sf_domain_url',
                        'title' => __('Domain URL', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('https://example.subscriptionflow.com', 'subscriptionflow-add-on-for-paywall'),
                        'desc' => __(
                            '</br><div class="sync-pw-sf-data" style="margin: 13px 0px 0px;"><a class="button-primary pw-sf-button" href="#" data-action="pw_sf_sync_product">Get SubscriptionFlow Products</a></div></br><div class="sync-pw-sf-data" style="margin: 13px 0px 0px;"><a class="button-primary pw-sf-import-customer-button" href="#" data-action="pw_sf_sync_product">Import Customers from SubscriptionFlow</a><span class="spinner" style="position: absolute;"></span></div>',
                            'subscriptionflow-add-on-for-paywall'
                        ),
                        'type' => 'text'
                    ),
                    array(
                        'id' => 'pw_sf_user_role',
                        'title' => __('User Role', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'dropdown',
                        'options' => $this->roles
                    ),
                    array(
                        'id' => 'pw_sf_restricted_html',
                        'title' => __('Restricted Content Message', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your HTML content here', 'subscriptionflow-add-on-for-paywall'),
                        'default' => __('You need a subscription to access this content', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'textarea'
                    ),
                    array(
                        'id' => 'pw_sf_email_customer_login',
                        'title' => __('Email the customer login details.', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'checkbox',
                        'default' => '0',
                        'desc' => __('Do you want to send an email when the custom sync from SubscriptionFlow to the website occurs?', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_customer_email',
                        'title' => __('Customer Email Text', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your HTML content here', 'subscriptionflow-add-on-for-paywall'),
                        'default' => sprintf(
                                        /* translators: %s: Customer name */
                                        __( 'Hello %s,<br/>Welcome to %s. Below are your login details:<br/>Username: %s<br/>Password: %s<br />', 'subscriptionflow-add-on-for-paywall' ),
                                        '[display_name]',
                                        esc_html( $this->pw_sf_site_title ),
                                        '[user_login]',
                                        '[user_pass]'
                                    ),
                        'type' => 'textarea'
                    ),
                    array(
                        'id' => 'pw_sf_login_form_username_label',
                        'title' => __('Username Label', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your login form Username Label', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text',
                        'default' => __('Username', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_login_form_password_label',
                        'title' => __('Password Label', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your login form Password Label', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text',
                        'default' => __('Password', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_login_form_button_label',
                        'title' => __('Button Label', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your login form Button Label', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text',
                        'default' => __('Login', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_login_form_redirect_url',
                        'title' => __('Redirect URL After Login', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your login form Redirect URL', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text',
                        'default' => esc_url(home_url())
                    ),
                    array(
                        'id' => 'pw_sf_logout_form_redirect_url',
                        'title' => __('Redirect URL After Log Out', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your Log Out Redirect URL', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text',
                        'default' => esc_url(home_url())
                    ),
                    // array(
                    //     'id' => 'pw_sf_enable_inapp_portal',
                    //     'title' => __('Enable InApp Portal', 'subscriptionflow-add-on-for-paywall'),
                    //     'type' => 'checkbox',
                    //     'default' => '0'
                    // ),
                    array(
                        'id' => 'pw_sf_bypass_restrictions',
                        'title' => __('Bypass Restrictions', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'roles_checkbox',
                        'desc' => __('Allow the selected user roles to always bypass the paywall.', 'subscriptionflow-add-on-for-paywall'),
                        'options' => $this->roles
                    ),
                    array(
                        'id' => 'pw_sf_custom_taxonomies',
                        'title' => __('Add Custom Taxonomies', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'text',
                        'placeholder' => __('article_category,team_category,testimonial_category', 'subscriptionflow-add-on-for-paywall'),
                        'desc' => __('Add the custom taxonomies you want to include in the Paywall configuration. Please follow the placeholder to add the taxonomy names.', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_lead_in_elements',
                        'title' => __('Lead In Elements', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'number',
                        'desc' => __('Number of paragraphs word to show before displaying the Paywall box.', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_gutenberg_lead_in_elements',
                        'title' => __('Gutenberg Lead In Elements', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'checkbox',
                        'default' => '0',
						 'desc' => __('If you are using the WordPress Gutenberg Editor and encounter issues with the layout, please select this option.', 'subscriptionflow-add-on-for-paywall')
                    ),
                    array(
                        'id' => 'pw_sf_customer_profile_billing_info',
                        'title' => __('Billing Information Text', 'subscriptionflow-add-on-for-paywall'),
                        'placeholder' => __('Enter your HTML content here', 'subscriptionflow-add-on-for-paywall'),
                        'default' => sprintf(
                                        /* translators: %s: Customer name */
                                        __( 'If you have questions about your current subscription or would like to make changes, 
                                            please contact support by calling <span class="font-bold">%s</span> or emailing 
                                            <a class="underline font-bold" href="mailto:%s">%s</a>', 'subscriptionflow-add-on-for-paywall' ),
                                            esc_html('(866) 440-6916'),
                                            esc_attr($admin_email),
                                            esc_html($admin_email)
                                    ),
                        'desc' => __('This content will be displayed on the customer account page.', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'textarea'
                    ),
                    array(
                        'id' => 'pw_sf_customer_login_restriction',
                        'title' => __('Login Restriction', 'subscriptionflow-add-on-for-paywall'),
                        'type' => 'checkbox',
                        'default' => '0',
                        'desc' => __('Enable the checkbox so that login works only if the subscription is active and the payment status is paid', 'subscriptionflow-add-on-for-paywall')
                    ),
                    
                )
            );
            

            add_action('admin_menu', array($this, 'pw_sf_add_plugin_page'));
            add_action('admin_init', array($this, 'pw_sf_page_init'));
        }

        public function pw_sf_add_plugin_page() {
            add_menu_page(
                __('SubscriptionFlow Settings', 'subscriptionflow-add-on-for-paywall'),
                __('SF Settings', 'subscriptionflow-add-on-for-paywall'),
                'manage_options',
                'pw-sf-settings-page',
                array($this, 'pw_sf_create_admin_page'),
                'dashicons-admin-generic',
                30
            );
            
        }

        public function pw_sf_create_admin_page() {


            $this->options = get_option('pw_sf_option_name'); ?>
         
            <div class="wrap">
                <h1><?php esc_html_e('SubscriptionFlow Options', 'subscriptionflow-add-on-for-paywall'); ?>
                </h1>
                <form method="post" action="options.php">
                    <?php
                    settings_fields('pw_sf_option_group');
                    do_settings_sections('pw-sf-settings-page');
                    submit_button();
                    ?>
                </form>
                <?php settings_errors(); ?>
            </div>
            <?php
        }

        public function pw_sf_page_init() {
            register_setting(
                'pw_sf_option_group',
                'pw_sf_option_name',
                array($this, 'pw_sf_sanitize')
            );

            foreach ($this->sections as $section) {
                add_settings_section(
                    $section['id'],
                    $section['title'],
                    array($this, $section['callback']),
                    'pw-sf-settings-page'
                );
            }

            foreach ($this->fields as $section_id => $fields) {
                foreach ($fields as $field) {
                    add_settings_field(
                        $field['id'],
                        $field['title'],
                        array($this, 'pw_sf_field_callback'),
                        'pw-sf-settings-page',
                        $this->sections[$section_id]['id'],
                        $field
                    );
                }
            }
        }

        public function pw_sf_sanitize($input) {
            $new_input = array();
            foreach ($this->fields as $fields) {
                foreach ($fields as $field) {
                    if (isset($input[$field['id']])) {
                        switch ($field['type']) {
                            case 'text':
                            case 'number':
                            case 'dropdown':
                                $new_input[$field['id']] = sanitize_text_field($input[$field['id']]);
                                break;
                            case 'textarea':
                                $new_input[$field['id']] = wp_kses_post($input[$field['id']]);
                                break;

                            case 'checkbox':
                                $new_input[$field['id']] = isset($input[$field['id']]) ? '1' : '0';
                                break;

                            case 'roles_checkbox':
                                // Sanitize checkbox array
                                if (isset($input[$field['id']]) && is_array($input[$field['id']])) {
                                    $new_input[$field['id']] = implode(', ',array_map('sanitize_text_field', $input[$field['id']]));
                                } 
                                break;
                        }
                    }
                }
            }


            return $new_input;
        }

        public function pw_sf_print_section_info_1() {
            echo wp_kses_post('
            <div style="position:relative">
                <p style="
                    border: 1px dashed;
                    background: #fff;
                    padding: 10px 20px 10px;
                    font-size: 16px;
                    font-weight: 400;
                    box-shadow: 0px 0px 1px 0px rgba(0,0,0,0.9);
                ">
                    Please fill all the fields. You can find your Client ID and Secret ID from your SubscriptionFlow account.<br>
                    If you want to sync Customers from SubscriptionFlow to WP, please add Webhook into SubscriptionFlow account: 
                    '.home_url().'/wp-json/api/sf-pw-create-update-user?customer_id={SF_ID}&pw_sf_allow_content_access=allow/block</br>
                    To add Paywall restriction to a specific area, use the following shortcode before the restricted content: 
                    [pw_sf_content show="logged_in"] and after the restricted area: [/pw_sf_content].</br>
                    You can add login form by using following shortcode [pw_sf_ajax_login_form]
                </p>
                <div id="sf-pw-import-customer-popup" data-position="center">
                    <div class="sf-pw-popup-content">
                        <span class="close-btn" data-id="sf-pw-import-customer-popup" >&times;</span>
                        <p id="popup-message">Import is in progress. Please wait until it completes.</br><span class="sf-pw-import-msg"></span></p>
                        <span class="spinner is-active" style="position: absolute;"></span>
                    </div>
                </div>
            </div>
        ');
        


        }

        public function pw_sf_field_callback($field) {
            $value = isset($this->options[$field['id']]) ? esc_attr($this->options[$field['id']]) : (isset($field['default']) ? $field['default'] : '');

    
            $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';
            $desc = isset($field['desc']) ? $field['desc'] : '';
            switch ($field['type']) {
                case 'text':
                    printf(
                        '<input type="text" class="large-text" id="%1$s" name="pw_sf_option_name[%1$s]" value="%2$s" placeholder="%3$s" />%4$s',
                        esc_attr($field['id']),
                        esc_attr($value),
                        esc_attr($placeholder),
                        wp_kses_post($desc)

                    );
                    break;
                    case 'number':
                        printf(
                            '<input type="number" class="small-text" id="%1$s" name="pw_sf_option_name[%1$s]" value="%2$s" placeholder="%3$s" />%4$s',
                            esc_attr($field['id']),      // Escaping for an attribute
                            esc_attr($value),            // Escaping for an attribute
                            esc_attr($placeholder),      // Escaping for an attribute
                            wp_kses_post($desc)          // Allows safe HTML in the description
    
                        );
                        break;
                case 'textarea':
                    printf(
                        '<textarea id="%1$s" name="pw_sf_option_name[%1$s]" rows="10" cols="120">%2$s</textarea>',
                        esc_attr($field['id']),      // Escaping for an attribute
                        wp_kses_post($value)           // Escaping for an attribute
                    );
                    break;
                case 'dropdown':
                    echo '<select id="' . esc_attr($field['id']) . '" name="pw_sf_option_name[' . esc_attr($field['id']) . ']">';
                    echo '<option value="">' . esc_html__('Select Role', 'pw-subscriptionflow') . '</option>';
                    foreach ($field['options'] as $key => $label) {

                        $selected = selected($value, $key, false);
                        echo '<option value="' . esc_attr($key) . '"' . $selected . '>' . esc_html($label['name']) . '</option>';
                    }
                    echo '</select>';
                    break;

                case 'checkbox':
                    $checked = checked($value, '1', false);
                    printf(
                        '<input type="checkbox" id="%1$s" name="pw_sf_option_name[%1$s]" value="1" %2$s /></br><p>%3$s</p>',
                        esc_attr($field['id']), 
                        $checked,
                        $desc
                    );
                    break;

                case 'roles_multi_select':
                    echo '<select id="' . esc_attr($field['id']) . '" name="pw_sf_option_name[' . esc_attr($field['id']) . '][]" multiple="multiple" style="width: 100%;">';
                    foreach ($field['options'] as $role => $role_details) {
                        $selected = in_array($role, $value) ? 'selected' : '';
                        echo '<option value="' . esc_attr($role) . '" ' . $selected . '>' . esc_html($role_details['name']) . '</option>';
                    }
                    echo '</select>';
                    echo '<p class="description">' . esc_html($desc) . '</p>';
                    break;

                case 'roles_checkbox':
                    
        
                    if(!empty($value))
                        $value=array_map('trim',explode(',',$value));

                    foreach ($field['options'] as $role => $role_details) {

                      $checked = in_array($role, (array)$value) ? 'checked' : '';

                        printf(
                            '<input type="checkbox" id="%1$s_%2$s" name="pw_sf_option_name[%1$s][]" value="%2$s" %3$s /> %4$s<br/>',
                            esc_attr($field['id']), 
                            esc_attr($role),
                            $checked,
                            esc_html($role_details['name']) // Role name to display
                        );
                    }
                    echo '<p class="description">' . esc_html($desc) . '</p>';
                    break;
            }
        }

        private function get_wp_roles() {
            return wp_roles()->roles; // Fetch WordPress roles dynamically.
        }

    
    }

    if (is_admin()) {
        $pw_sf_settings_page = new PW_SF_Settings_Page();
    }
}
