<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('PW_SF_Content_Restriction')) {
    class PW_SF_Content_Restriction {
        public function __construct() {

            $pw_sf_Helper_class_obj = PW_sf_Helper::pw_sf_helper_object();

            $pw_sf_option_name =$pw_sf_Helper_class_obj->pw_sf_get_pw_sf_option_name();



            
            add_action('add_meta_boxes', array($this, 'pw_sf_add_metabox'));
            add_action('save_post', array($this, 'pw_sf_save_metabox_data'));
            add_action('category_edit_form_fields', array($this, 'pw_sf_render_category_meta_fields'), 10, 2);
     

            if(!empty($pw_sf_option_name['pw_sf_custom_taxonomies'])){

                $pw_sf_custom_taxonomies = array_map('trim', explode(',', $pw_sf_option_name['pw_sf_custom_taxonomies']));  // Convert the string to an array

                

                if(!empty($pw_sf_custom_taxonomies)){

                    // Loop through the taxonomies and add the edit_form_fields action for each one
                    foreach ($pw_sf_custom_taxonomies as $taxonomy) {
                        
                       add_action("{$taxonomy}_edit_form_fields", array($this, 'pw_sf_render_category_meta_fields'), 10, 2);
                    }
                }
                
    
            }
      
            //add_action('edited_category', array($this, 'pw_sf_save_category_meta_data'));
            
            // Add custom field to tag edit screen
            //add_action('edit_tag_form_fields', array($this, 'pw_sf_render_tag_meta_fields'), 10, 2);
            add_action('post_tag_edit_form_fields', array($this, 'pw_sf_render_tag_meta_fields'), 10, 2);
            add_action('edited_term', array($this, 'pw_sf_save_tag_meta_data'));


        }

        // Add the metabox
        public function pw_sf_add_metabox() {

            // Get all custom post types
            $pw_sf_custom_post_types = get_post_types(
                array(
                    'public'   => true,  // Only public post types
                    '_builtin' => false  // Exclude built-in post types
                ),
                'names'
            );

            $pw_sf_post_types =array('post', 'page');
            if(!empty($pw_sf_custom_post_types))
                $pw_sf_post_types = array_merge(array('post', 'page'), $pw_sf_custom_post_types);

            add_meta_box(
                'pw_restrict_content_metabox',
                __('SubscriptionFlow Content Restriction', 'subscriptionflow-add-on-for-paywall'),
                array($this, 'pw_sf_render_metabox'),
                $pw_sf_post_types, // Post types where the metabox should appear
                'normal',
                'high'
            );
        }

        // Render the metabox
        public function pw_sf_render_metabox($post) {
            $value = get_post_meta($post->ID, '_pw_restrict_content', true);
            $pw_sf_free_article_checkbox = get_post_meta($post->ID, 'pw_sf_free_article_checkbox', true);
            
            wp_nonce_field('pw_metabox_nonce_action', 'pw_metabox_nonce');
            $pw_sf_content_before_paywall_box = get_post_meta($post->ID, 'pw_sf_content_before_paywall_box', true);
            ?>
           <p class="pw_sf">
                <label for="pw_sf_free_article_checkbox">
                    <input type="checkbox" id="pw_sf_free_article_checkbox" name="pw_sf_free_article_checkbox" value="1" <?php checked($pw_sf_free_article_checkbox, 1); ?> />
                    <strong><?php echo esc_html(__('Remove Restriction and it\'s a free article', 'subscriptionflow-add-on-for-paywall')); ?></strong>
                </label>
            </p>
            <div class="seprator" style="font-size: 20px;font-weight: 600;width: 100%;">OR</div>
           <p class="pw_sf">
                <label for="pw_restrict_content_checkbox">
                    <input type="checkbox" id="pw_restrict_content_checkbox" name="pw_restrict_content_checkbox" value="1" <?php checked($value, 1); ?> />
                    <strong><?php echo esc_html(__('Restrict access to this content?', 'subscriptionflow-add-on-for-paywall')); ?>
                    </strong>
                </label>
            </p>
            <div class="pw_sf">
                <h2 style="padding: 20px 0px 0px;font-weight:600;font-size;font-size: 17px;"><?php esc_html_e('Content Before the Paywall Box.', 'subscriptionflow-add-on-for-paywall'); ?></h2>
                <?php
                // Render WYSIWYG editor
                wp_editor(wp_kses_post($pw_sf_content_before_paywall_box), 'pw_sf_content_before_paywall_box', array(
                    'textarea_name' => 'pw_sf_content_before_paywall_box',
                    'textarea_rows' => 5,
                    'media_buttons' => false,
                    'teeny' => true,
                ));
                ?>
            </div>

       


            <?php

            $pw_sf_post_ID=$post->ID;
            $current_screen='post';
            include  plugin_dir_path( __FILE__ ).'pw-sf-repeater-field.php';
           
        }

        // Save the metabox data
        public function pw_sf_save_metabox_data($post_id) {
            if (!isset($_POST['pw_metabox_nonce']) || !wp_verify_nonce(sanitize_text_field( wp_unslash ( $_POST['pw_metabox_nonce'])), 'pw_metabox_nonce_action')) {
                return;
            }

            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                return;
            }

            if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
                if (!current_user_can('edit_page', $post_id)) {
                    return;
                }
            } elseif (!current_user_can('edit_post', $post_id)) {
                return;
            }

            $value = isset($_POST['pw_restrict_content_checkbox']) ? 1 : 0;
            update_post_meta($post_id, '_pw_restrict_content', $value);

            $pw_sf_free_article_checkbox = isset($_POST['pw_sf_free_article_checkbox']) ? 1 : 0;
            update_post_meta($post_id, 'pw_sf_free_article_checkbox', $pw_sf_free_article_checkbox);
            

            if (isset($_POST['pw_sf_content_before_paywall_box'])) {
                $allowed_tags = wp_kses_allowed_html('post');
                $customer_notes = wp_kses($_POST['pw_sf_content_before_paywall_box'], $allowed_tags);
                update_post_meta($post_id, 'pw_sf_content_before_paywall_box', $customer_notes);
            }

            $pw_sf_post_ID=$post_id;
            $current_screen='post';
            include  plugin_dir_path( __FILE__ ).'pw-sf-repeater-field-save.php';

        }

        // Render category meta fields
        public function pw_sf_render_category_meta_fields($term) {
            $value = get_term_meta($term->term_id, '_pw_restrict_content', true);
            ?>
            <tr class="form-field">
                <th scope="row">
                    <label for="pw_restrict_content_checkbox"> <?php echo esc_html(__('Restrict access to this category?', 'subscriptionflow-add-on-for-paywall')); ?>
                    </label>
                </th>
                <td>
                    <input type="checkbox" id="pw_restrict_content_checkbox" name="pw_restrict_content_checkbox" value="1" <?php checked($value, 1); ?> />
                </td>
            </tr>
            <?php

            $pw_sf_post_ID=$term->term_id;
            $current_screen='term';
            include  plugin_dir_path( __FILE__ ).'pw-sf-repeater-field.php';
        }

        // Save category meta data
        public function pw_sf_save_category_meta_data($term_id) {
            if (isset($_POST['pw_restrict_content_checkbox'])) {
                update_term_meta($term_id, '_pw_restrict_content', 1);
            } else {
                delete_term_meta($term_id, '_pw_restrict_content');
            }


            $pw_sf_post_ID=$term_id;
            $current_screen='term';
            include  plugin_dir_path( __FILE__ ).'pw-sf-repeater-field-save.php';
        }

        // Render tag meta fields
        public function pw_sf_render_tag_meta_fields($term) {
            $value = get_term_meta($term->term_id, '_pw_restrict_content', true);
            ?>
            <tr class="form-field">
                <th scope="row">
                    <label for="pw_restrict_content_checkbox"> <?php echo esc_html(__('Restrict access to this tag?', 'subscriptionflow-add-on-for-paywall')); ?>
                    </label>
                </th>
                <td>
                    <input type="checkbox" id="pw_restrict_content_checkbox" name="pw_restrict_content_checkbox" value="1" <?php checked($value, 1); ?> />
                </td>
            </tr>
            <?php

            $pw_sf_post_ID=$term->term_id;
            $current_screen='term';
            include  plugin_dir_path( __FILE__ ).'pw-sf-repeater-field.php';
        }

        // Save tag meta data
        public function pw_sf_save_tag_meta_data($term_id) {

            if (isset($_POST['pw_restrict_content_checkbox'])) {
                update_term_meta($term_id, '_pw_restrict_content', 1);
            } else {
                delete_term_meta($term_id, '_pw_restrict_content');
            }

            $pw_sf_post_ID=$term_id;
            $current_screen='term';
            include  plugin_dir_path( __FILE__ ).'pw-sf-repeater-field-save.php';
        }
    }

    // Initialize the plugin
    new PW_SF_Content_Restriction();
}
