<?php

/**
 * Plugin Name:       Subscription Gifts for WooCommerce
 * Plugin URI:        https://wordpress.org/plugins/subscription-gifts-for-woocommerce/
 * Description:       Reward your loyal subscribers by effortlessly adding free gifts to their WooCommerce Subscriptions.
 * Version:           1.0.1
 * Author:            wpgenie2
 * Author URI:        https://wpgenie.org/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       subscription-gifts-for-woocommerce
 * Domain Path:       /languages
 * Requires Plugins:  woocommerce
 *
 * @package           Subscription_Gifts_For_Woocommerce
 */
// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
    die;
}
if ( !function_exists( 'subsgift' ) ) {
    // Create a helper function for easy SDK access.
    function subsgift() {
        global $subsgift;
        if ( !isset( $subsgift ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_22504_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_22504_MULTISITE', true );
            }
            // Include Freemius SDK.
            require_once __DIR__ . '/vendor/freemius/start.php';
            $subsgift = fs_dynamic_init( array(
                'id'               => '22504',
                'slug'             => 'subscription-gifts-for-woocommerce',
                'type'             => 'plugin',
                'public_key'       => 'pk_dc632a823fcf45f0111c638fad59a',
                'is_premium'       => false,
                'has_addons'       => false,
                'has_paid_plans'   => true,
                'is_org_compliant' => true,
                'menu'             => array(
                    'first-path' => 'plugins.php',
                    'account'    => false,
                    'support'    => true,
                ),
                'is_live'          => true,
            ) );
        }
        return $subsgift;
    }

    // Init Freemius.
    subsgift();
    // Signal that SDK was initiated.
    do_action( 'subsgift_loaded' );
}
/**
 * Currently plugin version.
 */
define( 'SUBSCRIPTION_GIFTS_FOR_WOOCOMMERCE_VERSION', '1.0.1' );
/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-subscription-gifts-for-woocommerce.php';
/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function subscription_gifts_for_woocommerce_run() {
    $plugin = new Subscription_Gifts_For_Woocommerce();
    $plugin->run();
}

add_action( 'woocommerce_init', 'subscription_gifts_for_woocommerce_run' );
add_action( 'admin_init', 'subsgift_enviroment_check' );
function subsgift_enviroment_check() {
    if ( !class_exists( 'WC_Subscriptions' ) ) {
        add_action( 'admin_notices', 'subsgift_notice' );
    }
}

function subsgift_notice() {
    ?>
		<div class="notice notice-error">
			<p><?php 
    esc_html_e( 'Subscription Gifts for WooCommerce requires WooCommerce Subscriptions plugin to be installed and activated.', 'subscription-gifts-for-woocommerce' );
    ?></p>
		</div>
	<?php 
}
