(function($) {
    'use strict';
    jQuery(document).ready(function($) {
        // Definiranje Underscore/Handlebars template-a
        var productRowTemplate = wp.template('custom-linked-product-row');

        var $container = $('#custom_linked_products_fields');
        var $tbody = $container.find('.custom-linked-products-container');
        var $sortableTable = $container.find('.wc_input_table');

        $container.on('click', '.add_custom_linked_product_row', function(e) {
            e.preventDefault();

            var $lastRow = $tbody.find('tr:last');
            var newIndex = $lastRow.length ? parseInt($lastRow.find('input, select').first().attr('name').match(/\[(\d+)\]/)[1]) + 1 : 0;

            var $newRow = $(productRowTemplate({
                data: { i: newIndex }
            }).replace(/__i__/g, newIndex));

            $tbody.append($newRow);

            $newRow.find('.wc-product-search').trigger('wc-enhanced-select-init');

            $newRow.find('.delete_custom_linked_product_row').show();

            $sortableTable.trigger('init_wc_input_table');
        });

        $tbody.on('click', '.delete_custom_linked_product_row', function(e) {
            e.preventDefault();
            if (confirm('Jeste li sigurni da želite ukloniti ovaj proizvod?')) {
                $(this).closest('tr').remove();
            }
        });

        $('.wc-product-search').trigger('wc-enhanced-select-init');

        if (typeof $.fn.sortable !== 'undefined') {
            $sortableTable.find('tbody').sortable({
                items: '.custom-linked-product-row',
                cursor: 'move',
                axis: 'y',
                handle: 'td.sort',
                scrollSensitivity: 40,
                helper: function(e, ui) {
                    ui.children().each(function() {
                        $(this).width($(this).width());
                    });
                    ui.css('background-color', '#f6f6f6');
                    return ui;
                },
                start: function(event, ui) {
                    ui.item.css('border-style', 'dashed');
                },
                stop: function(event, ui) {
                    ui.item.css('border-style', 'none');
                }
            });
        }

        var $metaBox = $('#subscription-gifts-for-woocommerce');
        var $productType = $('#product-type');

        function toggleLinkedProductsMetaBox() {

            if ($productType.val() === 'subscription' || $productType.val() === 'variable-subscription') {
                $metaBox.show();
            } else {
                $metaBox.hide();
            }
        }
        toggleLinkedProductsMetaBox();
        $productType.on('change', toggleLinkedProductsMetaBox);
    });
})(jQuery);