<?php

/*
Plugin Name: StyloPress
Plugin URI: https://codews.online/stylopress/
Description: Customize and elevate your WordPress login page and admin panel with advanced design tools, color schemes, and widgets.
Version: 1.0.0
Requires at least 5.6
Requires PHP: 7.4
Author: CodeWS
Author URI: https://codews.online/
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: stylopress
Domain Path: /languages
*/
/*
StyloPress - WordPress Plugin
Copyright (c) 2025 StyloPress - CodeWS.online

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with StyloPress. If not, see <https://www.gnu.org/licenses/>.
*/
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
define( 'SPSS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
if ( function_exists( 'spss_fs' ) ) {
    spss_fs()->set_basename( false, __FILE__ );
} else {
    if ( !function_exists( 'spss_fs' ) ) {
        function spss_fs() {
            global $spss_fs;
            if ( !isset( $spss_fs ) ) {
                require_once SPSS_PLUGIN_DIR . 'vendor/freemius/start.php';
                $spss_fs = fs_dynamic_init( array(
                    'id'             => '17620',
                    'slug'           => 'stylopress',
                    'type'           => 'plugin',
                    'public_key'     => 'pk_46d13e2a32bf78ef14189dc45a993',
                    'is_premium'     => false,
                    'premium_suffix' => 'Premium Plan',
                    'has_addons'     => false,
                    'has_paid_plans' => true,
                    'menu'           => array(
                        'slug'    => 'stylopress',
                        'support' => false,
                    ),
                    'is_live'        => true,
                ) );
            }
            return $spss_fs;
        }

        spss_fs();
        do_action( 'spss_fs_loaded' );
    }
}
function spss_activate_plugin() {
    add_option( 'spss_color_scheme_options', [] );
    add_option( 'spss_selected_color_scheme', [] );
    add_option( 'spss_selected_scheme_icons_color', '' );
    add_option( 'spss_custom_color_scheme_options', [] );
    add_option( 'spss_custom_color_scheme_dashboard_option', '' );
    add_option( 'spss_footer_toggle', false );
    add_option( 'spss_footer_version_toggle', false );
    add_option( 'spss_footer_content', '' );
    add_option( 'spss_profile_image', '' );
    add_option( 'spss_logo_image', '' );
    add_option( 'spss_admin_menu_font_weight', '400' );
    add_option( 'spss_hidden_dashboard_items', [] );
    add_option( 'spss_display_screen_options', [] );
    add_option( 'spss_custom_html_or_text_content', '' );
    add_option( 'spss_hide_plugin_for_other_admins', false );
    add_option( 'spss_developer_name', '' );
    add_option( 'spss_developer_email_address', '' );
    add_option( 'spss_developer_phone_number', '' );
    add_option( 'spss_developer_site_address', '' );
    add_option( 'spss_google_font_family', 'Open Sans' );
    add_option( 'spss_google_font_weight', '400' );
    add_option( 'spss_todo_list_tasks', [] );
    add_option( 'spss_admin_notice_message', '' );
    add_option( 'spss_admin_to_users_notice_message', '' );
    add_option( 'spss_site_database_size', '' );
    add_option( 'spss_remove_settings_uninstall', true );
    add_option( 'spss_reset_lp_customizer', false );
    add_option( 'spss_toggle_wp_menu_top_bar', false );
    add_option( 'spss_scheme_creator_options', [] );
    if ( is_user_logged_in() ) {
        $current_user_id = get_current_user_id();
        add_option( 'spss_installer_admin_id', $current_user_id );
    } else {
        add_option( 'spss_installer_admin_id', 0 );
    }
}

register_activation_hook( __FILE__, 'spss_activate_plugin' );
require_once SPSS_PLUGIN_DIR . 'functions.php';
require_once SPSS_PLUGIN_DIR . 'includes/admin-menu.php';
require_once SPSS_PLUGIN_DIR . 'includes/enqueue-scripts.php';
require_once SPSS_PLUGIN_DIR . 'includes/news-and-updates.php';
require_once SPSS_PLUGIN_DIR . 'includes/schemes-settings.php';
require_once SPSS_PLUGIN_DIR . 'includes/scheme-creator-settings.php';
require_once SPSS_PLUGIN_DIR . 'includes/login-page-settings.php';
require_once SPSS_PLUGIN_DIR . 'includes/admin-settings.php';
require_once SPSS_PLUGIN_DIR . 'includes/widget-settings.php';
require_once SPSS_PLUGIN_DIR . 'includes/general-settings.php';
function spss_fs_uninstall_cleanup() {
    if ( get_option( 'spss_remove_settings_uninstall' ) ) {
        delete_option( 'spss_installer_admin_id' );
        delete_option( 'spss_color_scheme_options' );
        delete_option( 'spss_selected_color_scheme' );
        delete_option( 'spss_selected_scheme_icons_color' );
        delete_option( 'spss_custom_color_scheme_options' );
        delete_option( 'spss_custom_color_scheme_dashboard_option' );
        delete_option( 'spss_footer_toggle' );
        delete_option( 'spss_footer_version_toggle' );
        delete_option( 'spss_footer_content' );
        delete_option( 'spss_profile_image' );
        delete_option( 'spss_logo_image' );
        delete_option( 'spss_hidden_dashboard_items' );
        delete_option( 'spss_admin_menu_font_weight' );
        delete_option( 'spss_display_screen_options' );
        delete_option( 'spss_custom_html_or_text_content' );
        delete_option( 'spss_hide_plugin_for_other_admins' );
        delete_option( 'spss_developer_name' );
        delete_option( 'spss_developer_email_address' );
        delete_option( 'spss_developer_phone_number' );
        delete_option( 'spss_developer_site_address' );
        delete_option( 'spss_google_font_family' );
        delete_option( 'spss_google_font_weight' );
        delete_option( 'spss_todo_list_tasks' );
        delete_option( 'spss_admin_notice_message' );
        delete_option( 'spss_admin_to_users_notice_message' );
        delete_option( 'spss_reset_lp_customizer' );
        delete_option( 'spss_toggle_wp_menu_top_bar' );
        delete_option( 'spss_remove_settings_uninstall' );
        delete_option( 'spss_site_database_size' );
        delete_option( 'spss_scheme_creator_options' );
    }
    if ( empty( $GLOBALS['wp_filesystem'] ) ) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
        WP_Filesystem();
    }
    global $wp_filesystem;
    $upload_dir = wp_upload_dir();
    $font_dir = $upload_dir['basedir'] . '/spss-stylopress-google-fonts/';
    if ( file_exists( $font_dir ) ) {
        foreach ( glob( $font_dir . '*' ) as $file ) {
            wp_delete_file( $file );
        }
        if ( $wp_filesystem->is_dir( $font_dir ) ) {
            $wp_filesystem->rmdir( $font_dir );
        }
    }
}

spss_fs()->add_action( 'after_uninstall', 'spss_fs_uninstall_cleanup' );