<?php

if (!defined('ABSPATH')) {
  exit;
}

define('SPSS_CUSTOMIZER_PATH', plugin_dir_path(__FILE__) . 'customizer/');

require_once SPSS_CUSTOMIZER_PATH . 'login-page-customizer.php';
require_once SPSS_CUSTOMIZER_PATH . 'login-page-template-creator.php';
require_once SPSS_CUSTOMIZER_PATH . 'login-page-styles-creator.php';
require_once SPSS_CUSTOMIZER_PATH . 'enqueue-scripts.php';

function spss_customize_login_page_settings_page()
{
?>
  <div class="spss-lp-customizer-container wrap">
    <h1 class="header"><?php esc_html_e('Login Page Customizer', 'stylopress'); ?></h1>
    <p class="description"><?php esc_html_e('Design a unique login experience that reflects your brand.', 'stylopress'); ?></p>
    <div class="instructions">
      <div class="login-page-customizing-content">
        <h3 class="warning">
          <?php esc_html_e('Important ⚠️', 'stylopress'); ?>
        </h3>
        <p><?php esc_html_e('Select "Post name" under Settings -> Permalinks.', 'stylopress'); ?></p>
        <h3>
          <?php esc_html_e('10 Simple Steps BEFORE Customizing Login Page:', 'stylopress'); ?>
        </h3>
        <ol>
          <li>
            <?php
            echo sprintf(
              /* Translators: %s is the title of the page being created (e.g., "Login Page"). */
              esc_html__('Create a new page titled "%s".', 'stylopress'),
              '<span>' . esc_html('Login Page', 'stylopress') . '</span>'
            );
            ?>
          </li>
          <li>
            <?php
            echo sprintf(
              /* Translators: %s is the slug of the page being set (e.g., "custom-login-page"). */
              esc_html__('Set the page slug to "%s". (important)', 'stylopress'),
              '<span>' . esc_html('custom-login-page', 'stylopress') . '</span>'
            );
            ?>
          </li>
          <li><?php esc_html_e('Publish the page.', 'stylopress'); ?></li>
          <li><?php esc_html_e('Go to the Pages list.', 'stylopress'); ?></li>
          <li>
            <?php
            echo sprintf(
              /* Translators: 1. "Quick Edit" option name, 2. "Login Page" page name. */
              esc_html__('Click "%1$s" under the "%2$s".', 'stylopress'),
              '<span>' . esc_html('Quick Edit', 'stylopress') . '</span>',
              '<span>' . esc_html('Login Page', 'stylopress') . '</span>'
            );
            ?>
          </li>
          <li>
            <?php
            echo sprintf(
              /* Translators: %s is the name of the template, e.g., "Custom Login Page". */
              esc_html__('In the Template dropdown, choose "%s". (important)', 'stylopress'),
              '<span>' . esc_html('Custom Login Page', 'stylopress') . '</span>'
            );
            ?>
          </li>
          <li><?php esc_html_e('Click Update to save the changes.', 'stylopress'); ?></li>
          <li><?php esc_html_e('Check the box below if you followed all steps.', 'stylopress'); ?></li>
          <li><?php esc_html_e('Click the button to get started, and...', 'stylopress'); ?></li>
          <li><?php esc_html_e('Enjoy customizing your login page! 🥳', 'stylopress'); ?></li>
        </ol>
        <label>
          <input type="checkbox" id="spss-toggleCheckbox">
          <span>I have successfully followed all steps to create the login page.</span>
        </label>
        <br>
        <a
          href="<?php echo esc_url(admin_url('customize.php?autofocus[panel]=spss_login_customizer_panel&url=' . site_url('/custom-login-page/'))); ?>"
          class="button button-primary"
          id="spss-customizerButton">
          <?php esc_html_e('Go to Customizer', 'stylopress'); ?>
        </a>
      </div>
      <div class="notes-content">
        <h3><?php esc_html_e('What you need to do:', 'stylopress'); ?></h3>
        <ul>
          <li><?php esc_html_e('Customize the login page only. 🎨', 'stylopress'); ?></li>
          <li><?php esc_html_e('Styles will automatically apply to the Registration and Forgot Password forms. 😎', 'stylopress'); ?></li>
          <li><?php esc_html_e('Save your changes, log out, and check out the updated login page. 👀', 'stylopress'); ?></li>
        </ul>
        <h3><?php esc_html_e('Recommendations:', 'stylopress'); ?></h3>
        <ul>
          <li><?php esc_html_e('Compress images to reduce size without quality loss. 📉', 'stylopress'); ?></li>
          <li><?php esc_html_e('Use PNG for logos. 🖼️', 'stylopress'); ?></li>
          <li><?php esc_html_e('Use JPEG for background images. 🖼️', 'stylopress'); ?></li>
          <li><?php esc_html_e('Use MP4 or WebM for background videos. 🎥', 'stylopress'); ?></li>
          <li><?php esc_html_e('Keep video sizes small for faster uploads. ⬇️', 'stylopress'); ?></li>
          <li><?php esc_html_e('Optimize all media for quick loading. ⚡', 'stylopress'); ?></li>
          <li><?php esc_html_e('Avoid using large, uncompressed files. 🚫', 'stylopress'); ?></li>
        </ul>
      </div>
    </div>
  </div>
<?php
}
