<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_widget_settings()
{
  register_setting('spss_widgets_settings', 'spss_display_screen_options', array(
    'type'              => 'array',
    'sanitize_callback' => 'spss_sanitize_widgets_checkbox_array',
  ));

  add_settings_section(
    'spss_widgets_settings_section',
    '',
    '',
    'spss_widgets-settings'
  );

  add_settings_field(
    'spss_display_screen_options',
    '',
    'spss_render_screen_options_field',
    'spss_widgets-settings',
    'spss_widgets_settings_section'
  );
}
add_action('admin_init', 'spss_register_widget_settings');

function spss_sanitize_widgets_checkbox_array($input)
{
  return is_array($input) ? array_map('sanitize_text_field', $input) : [];
}

function spss_render_screen_options_field()
{
  $custom_widgets = spss_get_custom_widgets();

  $selected_widgets = get_option('spss_display_screen_options', []);

  echo '<div class="spss_widget_options_container">';

  foreach ($custom_widgets as $widget_key => $widget_data) {
    $premium = spss_fs()->is_free_plan() && ($widget_key == 'widget_13' || $widget_key == 'widget_16');
    $disabled = spss_fs()->is_free_plan() && ($widget_key == 'widget_13' || $widget_key == 'widget_16') ? 'disabled' : '';
    $checked = in_array($widget_key, (array)$selected_widgets) ? 'checked' : '';
    echo '<div class="spss_widget_option">';

    echo '<input type="checkbox" id="' . esc_attr($widget_data['id']) . '" name="spss_display_screen_options[]" value="' . esc_attr($widget_key) . '" ' . esc_attr($checked) . ' ' . ($disabled ? 'disabled' : '') . '>';
    echo '<label for="' . esc_html($widget_data['id']) . '" style="margin-bottom: 10px;"> <strong>' . esc_html($widget_data['label']) . '</strong></label>';
    if (!empty($widget_data['premium']) && $premium) {
      echo '<div style="color: red;" class="widget-data">⭐ ' . esc_html($widget_data['premium']) . '</div>';
    }
    if (!empty($widget_data['settings'])) {
      echo '<div class="widget-data">✅ ' . esc_html($widget_data['settings']) . ' ⚙️</div>';
    }
    if (!empty($widget_data['admin'])) {
      echo '<div class="widget-data">✅ ' . esc_html($widget_data['admin']) . ' 🖥️</div>';
    }
    if (!empty($widget_data['developer'])) {
      echo '<div class="widget-data">✅ ' . esc_html($widget_data['developer']) . ' 💼</div>';
    }
    if (!empty($widget_data['description'])) {
      echo '<p>' . esc_html($widget_data['description']) . '</p>';
    }
    echo '</div>';
  }

  echo '</div>';
}

function spss_get_custom_widgets()
{
  return [
    'widget_1' => [
      'id' => 'widget-1',
      'label' => 'Post Status Summary',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays a summary of the total number of posts in each status (published, draft, pending, etc.).',
    ],
    'widget_2' => [
      'id' => 'widget-2',
      'label' => 'Latest 5 Posts',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays the 5 most recent posts published on the site.',
    ],
    'widget_3' => [
      'id' => 'widget-3',
      'label' => 'Logo',
      'settings' => 'Admin Settings',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Shows your site\'s logo in the dashboard. Upload it in "Admin Settings".',
    ],
    'widget_4' => [
      'id' => 'widget-4',
      'label' => 'Latest 10 Comments',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Lists the 10 most recent approved comments on your posts.',
    ],
    'widget_5' => [
      'id' => 'widget-5',
      'label' => 'Quick Links',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Links to Plugins, Media Library, Themes, Profile, and Settings with item counts.',
    ],
    'widget_6' => [
      'id' => 'widget-6',
      'label' => 'User Role Summary',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays all user roles with item counts for Admin, Author, Editor, and others.',
    ],
    'widget_7' => [
      'id' => 'widget-7',
      'label' => 'Recent Posts with Thumbnails',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays the latest 4 posts with titles and featured images.',
    ],
    'widget_8' => [
      'id' => 'widget-8',
      'label' => 'Pending Updates',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays pending updates for WordPress core, plugins, and themes.',
    ],
    'widget_9' => [
      'id' => 'widget-9',
      'label' => 'Recent Activity Log',
      'settings' => '',
      'admin' => 'Admin-only visible',
      'developer' => '',
      'premium' => '',
      'description' => 'Shows recent activities from posts, pages, and content types, including titles, authors, and time since modification.',
    ],
    'widget_10' => [
      'id' => 'widget-10',
      'label' => 'Post Drafts',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Lists all post drafts to quickly see unpublished content.',
    ],
    'widget_11' => [
      'id' => 'widget-11',
      'label' => 'Media Library Usage',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays the total number of media items and their combined size in the Media Library.',
    ],
    'widget_12' => [
      'id' => 'widget-12',
      'label' => 'Site Health Overview',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays key site metrics like database size, PHP version, WordPress version, and memory limit.',
    ],
    'widget_13' => [
      'id' => 'widget-13',
      'label' => 'Developer Contact Info',
      'settings' => 'Admin Settings',
      'admin' => '',
      'developer' => 'Ideal for freelancers & agencies',
      'premium' => 'Available only for premium users',
      'description' => 'Displays the developer\'s contact info. with contact form. Add the information in the "Admin Settings". (Useful for freelancers)',
    ],
    'widget_14' => [
      'id' => 'widget-14',
      'label' => 'Plugin Usage Stats',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays a summary of active and inactive plugins, along with any plugins needing updates.',
    ],
    'widget_15' => [
      'id' => 'widget-15',
      'label' => 'Recent User Registrations',
      'settings' => '',
      'admin' => 'Admin-only visible',
      'developer' => '',
      'premium' => '',
      'description' => 'Shows the latest user registration activity, including username, email, and date.',
    ],
    'widget_16' => [
      'id' => 'widget-16',
      'label' => 'Developer Client To-Do Hub',
      'settings' => '',
      'admin' => '',
      'developer' => 'Ideal for freelancers & agencies',
      'premium' => 'Available only for premium users',
      'description' => 'Show tasks for users, with creator-only deletion rights. Perfect for managing client tasks between freelancers/developers and clients.',
    ],
    'widget_17' => [
      'id' => 'widget-17',
      'label' => 'Note to Admins',
      'settings' => 'Admin Settings',
      'admin' => 'Admin-only visible',
      'developer' => 'Ideal for freelancers & agencies',
      'premium' => '',
      'description' => 'Show important updates or reminders for all site admins.',
    ],
    'widget_18' => [
      'id' => 'widget-18',
      'label' => 'Note to Users',
      'settings' => 'Admin Settings',
      'admin' => 'Ideal for freelancers & agencies',
      'developer' => 'Ideal for freelancers & agencies',
      'premium' => '',
      'description' => 'Show important updates or reminders for all site users.',
    ],
    'widget_19' => [
      'id' => 'widget-19',
      'label' => 'Posts and Comments Stats',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays statistics on posts and comments, including published, draft, pending, approved, and spam counts.',
    ],
    'widget_20' => [
      'id' => 'widget-20',
      'label' => 'Theme Information & Updates',
      'settings' => '',
      'admin' => '',
      'developer' => '',
      'premium' => '',
      'description' => 'Displays the active theme\'s details and lists all installed themes with update status.',
    ],
  ];
}

function spss_include_widget_files($widget_key)
{
  $widget_file = plugin_dir_path(__FILE__) . 'custom-widgets/' . $widget_key . '.php';

  if (file_exists($widget_file)) {
    require_once $widget_file;
  }
}

function spss_display_custom_widgets_on_dashboard()
{
  $selected_widgets = get_option('spss_display_screen_options', []);

  if (!is_array($selected_widgets)) {
    $selected_widgets = [];
  }

  foreach ($selected_widgets as $widget_key) {
    spss_include_widget_files($widget_key);

    if (function_exists('spss_render_custom_widget_content_' . $widget_key)) {
      $widget_label = spss_get_widget_label($widget_key);
      if (is_array($widget_label)) {
        $widget_label = isset($widget_label['label']) ? $widget_label['label'] : '';
      }
      if (($widget_key === 'widget_9' || $widget_key === 'widget_15' || $widget_key === 'widget_17')
        && current_user_can('administrator')
      ) {
        wp_add_dashboard_widget(
          $widget_key,
          $widget_label,
          'spss_render_custom_widget_content_' . $widget_key
        );
      } elseif ($widget_key !== 'widget_9' && $widget_key !== 'widget_15' && $widget_key !== 'widget_17') {
        wp_add_dashboard_widget(
          $widget_key,
          $widget_label,
          'spss_render_custom_widget_content_' . $widget_key
        );
      }
    }
  }
}
add_action('wp_dashboard_setup', 'spss_display_custom_widgets_on_dashboard');

function spss_get_widget_label($widget_key)
{
  $widgets = spss_get_custom_widgets();
  return isset($widgets[$widget_key]) ? $widgets[$widget_key] : 'Unknown Widget';
}
