<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_9_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-9-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-9.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_9_scripts');

function spss_render_custom_widget_content_widget_9()
{
  $cache_key = 'activity_logs_cache_key';
  $activity_logs = wp_cache_get($cache_key, 'activity_logs');

  if ($activity_logs === false) {
    $args = array(
      'post_type'      => 'any',
      'post_status'    => 'publish',
      'posts_per_page' => 10,
      'orderby'        => 'modified',
      'order'          => 'DESC',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
      $activity_logs = [];
      while ($query->have_posts()) {
        $query->the_post();
        $activity_logs[] = [
          'post_title'    => get_the_title(),
          'post_type'     => get_post_type(),
          'post_status'   => get_post_status(),
          'post_modified' => get_the_modified_date('Y-m-d H:i:s'),
          'post_author'   => get_post_field('post_author', get_the_ID()),
        ];
      }
      wp_cache_set($cache_key, $activity_logs, 'activity_logs', 3600);
    }

    wp_reset_postdata();
  }

  ob_start(); ?>
  <div class="spss-widget-9">
    <div class="spss-user-activity-widget">
      <?php if (!empty($activity_logs)) : ?>
        <ul class="spss-activity-list">
          <?php foreach ($activity_logs as $log) :
            $user_info = get_userdata($log['post_author']);
            $post_type = ucfirst($log['post_type']);
            $timestamp = strtotime($log['post_modified']);
            $time_diff = human_time_diff($timestamp, current_time('timestamp')) . ' ago';

            $post_icons = [
              'post' => '📄',
              'page' => '📑',
              'attachment' => '🖼️',
            ];
            $icon = $post_icons[$log['post_type']] ?? '🔘';
          ?>
            <li class="spss-activity-item">
              <div class="spss-activity-item-content">
                <div class="spss-activity-icon"><?php echo esc_html($icon); ?></div>
                <div class="spss-activity-details">
                  <strong><?php echo esc_html($post_type); ?>:</strong> <?php echo esc_html($log['post_title']); ?>
                  <br>
                  <span class="spss-activity-meta">
                    <?php if ($user_info) : ?>
                      <?php echo esc_html__('By ', 'stylopress') . esc_html($user_info->display_name) . ' - ' . esc_html($time_diff); ?>
                    <?php else : ?>
                      <?php echo esc_html__('By Unknown - ', 'stylopress') . esc_html($time_diff); ?>
                    <?php endif; ?>
                  </span>
                </div>
              </div>
            </li>
          <?php endforeach; ?>
        </ul>
      <?php else : ?>
        <p class="spss-no-activity"><?php echo esc_html__('No recent activity found.', 'stylopress'); ?></p>
      <?php endif; ?>
    </div>
  </div>
<?php
}

echo wp_kses(ob_get_clean(), array(
  'div' => array('class' => array()),
  'ul' => array('class' => array()),
  'li' => array('class' => array()),
  'p' => array('class' => array()),
  'span' => array('class' => array()),
  'strong' => array(),
));

function spss_clear_activity_logs_cache_on_post_change($post_id)
{
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
  if (get_post_status($post_id) === 'publish') {
    wp_cache_delete('activity_logs_cache_key', 'activity_logs');
  }
}
add_action('save_post', 'spss_clear_activity_logs_cache_on_post_change');
add_action('delete_post', 'spss_clear_activity_logs_cache_on_post_change');
