<?php
if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_8_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-8-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-8.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_8_scripts');

function spss_render_custom_widget_content_widget_8()
{
  $core_updates = get_site_transient('update_core');
  $plugin_updates = get_site_transient('update_plugins');
  $theme_updates = get_site_transient('update_themes');

  ob_start(); ?>

  <div class="spss-widget-8">
    <div class="spss-pending-updates-widget">
      <?php
      $icons = [
        'core' => '⚙️',
        'plugin' => '🔌',
        'theme' => '🎨'
      ];

      if (isset($core_updates->updates) && !empty($core_updates->updates)) : ?>
        <p class="spss-core-updates">
          <?php echo wp_kses_post($icons['core']); ?>
          <?php echo esc_html__('WordPress Core Updates: ', 'stylopress') . esc_html(count($core_updates->updates)) . ' pending'; ?>
        </p>
      <?php endif;

      if (isset($plugin_updates->response) && !empty($plugin_updates->response)) : ?>
        <p class="spss-plugin-updates">
          <?php echo wp_kses_post($icons['plugin']); ?>
          <?php echo esc_html__('Plugin Updates: ', 'stylopress') . esc_html(count($plugin_updates->response)) . ' pending'; ?>
        </p>
      <?php endif;

      if (isset($theme_updates->response) && !empty($theme_updates->response)) : ?>
        <p class="spss-theme-updates">
          <?php echo wp_kses_post($icons['theme']); ?>
          <?php echo esc_html__('Theme Updates: ', 'stylopress') . esc_html(count($theme_updates->response)) . ' pending'; ?>
        </p>
      <?php endif;

      $total_pending = (isset($core_updates->updates) ? count($core_updates->updates) : 0) +
        (isset($plugin_updates->response) ? count($plugin_updates->response) : 0) +
        (isset($theme_updates->response) ? count($theme_updates->response) : 0);

      if ($total_pending > 0) : ?>
        <p class="spss-total-updates">
          <?php echo esc_html__('Total Pending Updates: ', 'stylopress') . esc_html($total_pending); ?>
        </p>
      <?php else : ?>
        <p class="spss-no-updates"><?php echo esc_html__('No updates pending!', 'stylopress'); ?></p>
      <?php endif; ?>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'p' => array('class' => array()),
  ));
}
