<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_7_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-7-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-7.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_7_scripts');

function spss_render_custom_widget_content_widget_7()
{
  $args = array(
    'posts_per_page' => 4,
    'post_status' => 'publish',
  );
  $recent_posts = new WP_Query($args);

  ob_start();

  if ($recent_posts->have_posts()) : ?>
    <div class="spss-widget-7">
      <div class="spss-recent-posts-grid">
        <?php while ($recent_posts->have_posts()) : $recent_posts->the_post(); ?>
          <div class="spss-recent-post-item">
            <?php if (has_post_thumbnail()) : ?>
              <a href="<?php echo esc_url(get_permalink()); ?>">
                <?php echo get_the_post_thumbnail(null, [200, 200]); ?>
              </a>
            <?php endif; ?>
            <p><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></p>
          </div>
        <?php endwhile; ?>
      </div>
    </div>
  <?php else : ?>
    <p>No recent posts found.</p>
<?php endif;

  wp_reset_postdata();

  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'a' => array('href' => array()),
    'p' => array(),
    'img' => array(
      'src' => array(),
      'alt' => array(),
      'class' => array(),
      'width' => array(),
      'height' => array(),
    ),
  ));
}
