<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_6_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-6-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-6.css',
    [],
    '1.0.0'
  );

  wp_enqueue_script(
    'spss-custom-widget-6-js',
    plugin_dir_url(__FILE__) . '../assets/javascript/spss-custom-widget-6.js',
    array(),
    null,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_6_scripts');

function spss_render_custom_widget_content_widget_6()
{
  $all_roles = wp_roles()->roles;
  $user_counts = count_users()['avail_roles'];
  $usernames = [];

  $roles_to_display_users = ['administrator', 'editor', 'author', 'contributor', 'subscriber'];
  foreach ($roles_to_display_users as $role) {
    $usernames[$role] = get_users([
      'role'   => $role,
      'number' => 3,
    ]);
  }

  $role_icons = [
    'administrator' => '👑',
    'editor' => '✏️',
    'author' => '📖',
    'contributor' => '🛠️',
    'subscriber' => '👥',
    'default' => '🔹',
  ];

  ob_start();
?>
  <div class="spss-widget-6">
    <?php foreach ($all_roles as $role_key => $details):
      $role_count = $user_counts[$role_key] ?? 0;
      $icon = $role_icons[$role_key] ?? $role_icons['default'];
    ?>
      <div class="spss-role">
        <strong class="spss-role-name"><?php echo esc_html($icon) . ' ' . esc_html($details['name']); ?></strong>
        <span class="spss-role-count"><?php echo esc_html($role_count); ?> Users</span>
        <?php if (!empty($usernames[$role_key])): ?>
          <div class="spss-user-list">
            <?php foreach ($usernames[$role_key] as $user): ?>
              <div class="spss-user-avatar">
                <div class="spss-avatar-container">
                  <?php echo get_avatar($user->ID, 50, '', '', array('class' => 'spss-avatar')); ?>
                </div>
                <span class="spss-username-tooltip"><?php echo esc_html($user->user_login); ?></span>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>

<?php
  $content = ob_get_clean();

  echo wp_kses($content, array(
    'div' => array('class' => array()),
    'strong' => array(),
    'span' => array('class' => array()),
    'img' => array(
      'src' => array(),
      'class' => array(),
      'width' => array(),
      'height' => array(),
      'alt' => array(),
      'loading' => array(),
    ),
  ));
}
