<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_5_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-5-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-5.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_5_scripts');

function spss_render_custom_widget_content_widget_5()
{
  $image_count = count(get_posts(array(
    'post_type' => 'attachment',
    'posts_per_page' => -1,
    'post_mime_type' => 'image',
  )));

  $video_count = count(get_posts(array(
    'post_type' => 'attachment',
    'posts_per_page' => -1,
    'post_mime_type' => array('video/mp4', 'video/quicktime'),
  )));

  $theme_count = wp_get_themes();
  $installed_themes_count = count($theme_count);

  ob_start();
?>

  <div class="spss-widget-5">
    <div class="spss-user-quick-links-widget">
      <ul class="spss-quick-links-list">
        <li class="spss-quick-links-item">
          <a href="<?php echo esc_url(admin_url('upload.php')) ?>" class="spss-quick-link">
            <span class="spss-icon">🖼️</span> Media Library
          </a>
          <small class="spss-quick-link-small">
            <?php echo esc_html($image_count) ?> image(s) - <?php echo esc_html($video_count) ?> video(s)
          </small>
        </li>
        <li class="spss-quick-links-item">
          <a href="<?php echo esc_url(admin_url('plugins.php')) ?>" class="spss-quick-link">
            <span class="spss-icon">🔌</span> Plugins
          </a>
          <small class="spss-quick-link-small">
            <?php echo esc_html(count(get_plugins())) ?> plugin(s)
          </small>
        </li>
        <li class="spss-quick-links-item">
          <a href="<?php echo esc_url(admin_url('themes.php')) ?>" class="spss-quick-link">
            <span class="spss-icon">🎨</span> Themes
          </a>
          <small class="spss-quick-link-small">
            <?php echo esc_html($installed_themes_count) ?> theme(s)
          </small>
        </li>
        <li class="spss-quick-links-item">
          <a href="<?php echo esc_url(admin_url('options-general.php')) ?>" class="spss-quick-link">⚙️ Settings</a>
        </li>
        <li class="spss-quick-links-item">
          <a href="<?php echo esc_url(admin_url('profile.php')) ?>" class="spss-quick-link">👤 Your Profile</a>
        </li>
      </ul>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'ul' => array('class' => array()),
    'li' => array('class' => array()),
    'a' => array('href' => array(), 'class' => array()),
    'span' => array('class' => array()),
    'small' => array('class' => array())
  ));
}
