<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_4_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-4-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-4.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_4_scripts');

function spss_render_custom_widget_content_widget_4()
{
  $comments = get_comments(array(
    'number' => 10,
    'status' => 'approve',
  ));

  ob_start();
?>

  <div class="spss-widget-4">
    <ul class="spss-comment-list">
      <?php if ($comments) : ?>
        <?php foreach ($comments as $comment) :
          $comment_date = gmdate('F j, Y', strtotime($comment->comment_date));
          $comment_link = get_comment_link($comment);
        ?>
          <li class="spss-comment-item">
            <div class="spss-comment-avatar">
              <?php echo get_avatar($comment->comment_author_email, 64, '', '', ['class' => 'spss-avatar-img']); ?>
            </div>
            <div>
              <strong>
                <a href="<?php echo esc_url($comment_link); ?>" class="spss-comment-link" title="<?php echo esc_attr('View this comment'); ?>">
                  <?php echo esc_html($comment->comment_author); ?>
                </a>
              </strong>
              <p class="spss-comment-content"><?php echo esc_html(wp_trim_words($comment->comment_content, 20, '...')); ?></p>
              <small class="spss-comment-date">Commented on: <?php echo esc_html($comment_date); ?></small>
            </div>
          </li>
        <?php endforeach; ?>
      <?php else : ?>
        <li class="spss-no-comments">No comments available.</li>
      <?php endif; ?>
    </ul>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'ul' => array('class' => array()),
    'li' => array('class' => array()),
    'div' => array('class' => array()),
    'strong' => array(),
    'a' => array('href' => array(), 'class' => array(), 'title' => array()),
    'p' => array('class' => array()),
    'small' => array('class' => array()),
    'img' => array(
      'src' => array(),
      'alt' => array(),
      'class' => array(),
      'width' => array(),
      'height' => array(),
    )
  ));
}
