<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_3_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-3-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-3.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_3_scripts');

function spss_render_custom_widget_content_widget_3()
{
  $logo_value = get_option('spss_logo_image', '');

  ob_start();
?>

  <div class="spss-widget-3">
    <div class="logo-widget">
      <?php if (!empty($logo_value)) : ?>
        <img src="<?php echo esc_url($logo_value) ?>" alt="Site Logo">
      <?php else : ?>
        <p>No logo available.</p>
      <?php endif; ?>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'p' => array(),
    'img' => array(
      'src' => array(),
      'alt' => array(),
    ),
  ));
}
