<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_20_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-20-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-20.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_20_scripts');

function spss_render_custom_widget_content_widget_20()
{
  $themes = wp_get_themes();
  $active_theme = wp_get_theme();
  $themes_count = count($themes);

  ob_start();
?>

  <div class="spss-widget-20">
    <div class="spss-widget-theme-info">
      <ul>
        <li><span class="spss-icon dashicons dashicons-admin-appearance"></span><strong>Active Theme:</strong> <?php echo esc_html($active_theme->get('Name')); ?></li>
        <li><span class="spss-icon dashicons dashicons-update"></span><strong>Installed Themes:</strong> <?php echo esc_html($themes_count); ?></li>
      </ul>
      <h3>Installed Themes:</h3>
      <ul>
        <?php foreach ($themes as $theme) : ?>
          <li class="spss-theme-item">
            <span class="spss-icon dashicons dashicons-admin-appearance"></span>
            <strong><?php echo esc_html($theme->get('Name')); ?></strong>
            <span>(<?php echo esc_html($theme->get('Version')); ?>)</span>
          </li>
        <?php endforeach; ?>
      </ul>
      <div class="spss-actions">
        <a href="<?php echo esc_url(admin_url('themes.php')); ?>">View Themes</a>
      </div>
    </div>
  </div>

<?php
  $content = ob_get_clean();

  echo wp_kses($content, array(
    'div' => array('class' => array()),
    'span' => array('class' => array()),
    'ul' => array('class' => array()),
    'li' => array('class' => array()),
    'p' => array('class' => array()),
    'h3' => array('class' => array()),
    'a' => array('href' => array(), 'title' => array()),
    'strong' => array('class' => array()),
    'small' => array('class' => array())
  ));
}
