<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_2_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-2-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-2.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_2_scripts');

function spss_render_custom_widget_content_widget_2()
{
  $recent_posts = wp_get_recent_posts([
    'numberposts' => 5,
    'post_status' => ['publish', 'draft', 'private', 'future'],
  ]);

  ob_start();
?>

  <div class="spss-widget-2">
    <div class="spss-recent-posts-widget">
      <ul>
        <?php if (!empty($recent_posts)) : ?>
          <?php foreach ($recent_posts as $post) :
            $status = $post['post_status'];
            $status_color = match ($status) {
              'publish' => 'green',
              'draft' => 'grey',
              'private' => 'red',
              'future' => 'blue',
              default => 'black',
            };
          ?>
            <li>
              <strong><?php echo esc_html($post['post_title']); ?></strong>
              <span class="spss-<?php echo esc_attr($status_color); ?>">
                <?php echo esc_html(ucfirst($status)); ?>
              </span>
              <small><?php echo esc_html(gmdate('F j, Y', strtotime($post['post_date']))); ?></small>
            </li>
          <?php endforeach; ?>
        <?php else : ?>
          <p>No recent posts available.</p>
        <?php endif; ?>
      </ul>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'span' => array('class' => array()),
    'ul' => array(),
    'li' => array(),
    'a' => array('href' => array(), 'title' => array()),
    'strong' => array(),
    'small' => array()
  ));
}
