<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_19_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-19-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-19.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_19_scripts');

function spss_render_custom_widget_content_widget_19()
{
  $post_counts = wp_count_posts();
  $published_count = $post_counts->publish;
  $draft_count = $post_counts->draft;
  $pending_count = $post_counts->pending;

  $comment_counts = wp_count_comments();
  $approved_count = $comment_counts->approved;
  $pending_comment_count = isset($comment_counts->pending) ? $comment_counts->pending : 0;
  $spam_count = $comment_counts->spam;

  ob_start();
?>

  <div class="spss-widget-19">
    <div class="spss-widget-post-comment-stats">
      <ul>
        <li><strong>📄 Published Posts:</strong> <span><?php echo esc_html($published_count); ?></span> Post(s)</li>
        <li><strong>📄 Published Posts:</strong> <span><?php echo esc_html($published_count); ?></span> Post(s)</li>
        <li><strong>📝 Draft Posts:</strong> <span><?php echo esc_html($draft_count); ?></span> Post(s)</li>
        <li><strong>⏳ Pending Posts:</strong> <span><?php echo esc_html($pending_count); ?></span> Post(s)</li>
        <li><strong>💬 Approved Comments:</strong> <span><?php echo esc_html($approved_count); ?></span> Comment(s)</li>
        <li><strong>⏳ Pending Comments:</strong> <span><?php echo esc_html($pending_comment_count); ?></span> Comment(s)</li>
        <li><strong>🗑️ Spam Comments:</strong> <span><?php echo esc_html($spam_count); ?></span> Comment(s)</li>
      </ul>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'span' => array(),
    'ul' => array(),
    'li' => array(),
    'a' => array('href' => array(), 'title' => array()),
    'strong' => array(),
    'small' => array()
  ));
}
