<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_18_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-18-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-18.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_18_scripts');

function spss_render_custom_widget_content_widget_18()
{
  $admin_to_users_notice_message = get_option('spss_admin_to_users_notice_message', '');

  ob_start();
?>

  <div class="spss-widget-18">
    <div class="spss-widget-admin-notice">
      <?php echo esc_html($admin_to_users_notice_message); ?>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'strong' => array(),
  ));
}
