<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_17_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-17-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-17.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_17_scripts');

function spss_render_custom_widget_content_widget_17()
{
  $admin_notice_message = get_option('spss_admin_notice_message', '');

  ob_start();
?>

  <div class="spss-widget-17">
    <div class="spss-widget-admin-notice">
      <?php echo esc_html($admin_notice_message); ?>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'strong' => array(),
  ));
}
