<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_16_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-16-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-16.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_16_scripts');

function spss_render_custom_widget_content_widget_16()
{
  $tasks = get_option('spss_todo_list_tasks', []);

  if (isset($_POST['spss_add_task']) && !empty($_POST['spss_task'])) {

    if (isset($_POST['_wpnonce']) && !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'spss_task_nonce')) {
      die('Nonce verification failed');
    }

    if (isset($_POST['spss_task'])) {
      $new_task = sanitize_text_field(wp_unslash($_POST['spss_task']));
      $current_user = wp_get_current_user();

      $task_id = uniqid();

      $tasks[$task_id] = [
        'task' => $new_task,
        'user' => $current_user->user_login,
      ];

      update_option('spss_todo_list_tasks', $tasks);
    }
  }

  if (isset($_POST['spss_remove_task']) && isset($_POST['task_id'])) {

    if (isset($_POST['_wpnonce']) && !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'spss_task_nonce')) {
      die('Nonce verification failed');
    }

    if (isset($_POST['task_id'])) {
      $task_id = sanitize_text_field(wp_unslash($_POST['task_id']));
      $current_user = wp_get_current_user();

      if (isset($tasks[$task_id]) && $tasks[$task_id]['user'] === $current_user->user_login) {
        unset($tasks[$task_id]);
        update_option('spss_todo_list_tasks', $tasks);
      }
    }
  }

  ob_start();
?>

  <div class="spss-widget-16">
    <div class="spss-widget-todo-list">
      <form method="POST" action="">
        <input type="text" name="spss_task" placeholder="What needs to be done?" required>
        <input type="submit" class="button-primary" name="spss_add_task" value="Add Task">
      </form>
      <ul>
        <?php foreach ($tasks as $task_id => $task) : ?>
          <li>
            <strong><?php echo esc_html($task['task']); ?></strong>
            <span>(Added by: <?php echo esc_html($task['user']); ?>)</span>
            <?php if ($task['user'] === wp_get_current_user()->user_login) : ?>
              <div class="spss-actions">
                <form method="POST">
                  <input type="hidden" name="task_id" value="<?php echo esc_attr($task_id); ?>">
                  <input type="hidden" name="_wpnonce" value="<?php echo esc_attr(wp_create_nonce('spss_task_nonce')); ?>" />
                  <input type="submit" name="spss_remove_task" value="Delete">
                </form>
              </div>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  </div>

<?php
  $output = ob_get_clean();

  echo wp_kses($output, array(
    'div' => array('class' => array()),
    'form' => array('method' => array()),
    'ul' => array('class' => array()),
    'li' => array('class' => array()),
    'strong' => array(),
    'input' => array('type' => array(), 'name' => array(), 'value' => array(), 'class' => array(), 'placeholder' => array(), 'id' => array(), 'required' => array()),
    'button' => array('type' => array(), 'class' => array(), 'id' => array(), 'name' => array()),
    'span' => array('class' => array(), 'id' => array()),
    'p' => array(),
    'br' => array(),
    'script' => array()
  ));
}
