<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_15_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-15-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-15.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_15_scripts');

function spss_render_custom_widget_content_widget_15()
{
  $cache_key = 'recent_logins_cache_key';
  $login_logs = wp_cache_get($cache_key, 'login_logs');

  if ($login_logs === false) {
    $login_logs = get_users([
      'orderby' => 'registered',
      'order' => 'DESC',
      'number' => 5,
      'fields' => ['user_login', 'user_email', 'user_registered'],
    ]);

    wp_cache_set($cache_key, $login_logs, 'login_logs', 3600);
  }

  ob_start();
?>

  <div class="spss-widget-15">
    <div class="spss-widget-recent-logins">
      <?php if (!empty($login_logs)) : ?>
        <ul>
          <?php foreach ($login_logs as $log) : ?>
            <li>
              <strong><?php echo esc_html($log->user_login); ?></strong>
              <span>Email: <?php echo esc_html($log->user_email); ?></span><br>
              <span>Registered: <?php echo esc_html(gmdate('Y-m-d H:i', strtotime($log->user_registered))); ?></span>
            </li>
          <?php endforeach; ?>
        </ul>
      <?php else : ?>
        <p>No recent user logins found.</p>
      <?php endif; ?>
    </div>
  </div>

<?php
  $content = ob_get_clean();

  echo wp_kses($content, array(
    'div' => array('class' => array()),
    'ul' => array(),
    'li' => array(),
    'p' => array(),
    'strong' => array(),
    'span' => array(),
    'br' => array()
  ));
}

function spss_clear_recent_logins_cache_on_user_change()
{
  wp_cache_delete('recent_logins_cache_key', 'login_logs');
}
add_action('user_register', 'spss_clear_recent_logins_cache_on_user_change');
add_action('profile_update', 'spss_clear_recent_logins_cache_on_user_change');
add_action('delete_user', 'spss_clear_recent_logins_cache_on_user_change');
