<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_14_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-14-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-14.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_14_scripts');

function spss_render_custom_widget_content_widget_14()
{
  $active_plugins = get_option('active_plugins');
  $all_plugins = get_plugins();
  $active_count = count($active_plugins);
  $inactive_count = count($all_plugins) - $active_count;
  $plugin_updates = get_plugin_updates();
  $plugins_with_updates = count($plugin_updates);

  ob_start();
?>

  <div class="spss-widget-14">
    <div class="spss-widget-plugin-usage-stats">
      <ul>
        <li><strong>✅ Active Plugins:</strong> <span><?php echo esc_html($active_count) ?></span></li>
        <li><strong>❌ Inactive Plugins:</strong> <span><?php echo esc_html($inactive_count) ?></span></li>
        <?php if ($plugins_with_updates > 0) : ?>
          <li><strong>🔄 Plugins Needing Updates:</strong> <span><?php echo esc_html($plugins_with_updates) ?></span></li>
        <?php endif; ?>
      </ul>
      <div class="plugin-action">
        <a href="<?php echo esc_url(admin_url('plugins.php')) ?>" class="button-primary"><?php echo esc_html__('Manage Plugins', 'stylopress') ?></a>
      </div>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'span' => array(),
    'ul' => array(),
    'li' => array(),
    'a' => array('href' => array(), 'title' => array(), 'class' => array()),
    'strong' => array(),
  ));
}
